 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Project: gafix                                                         *
 * File: statusbar.c                                                      *
 * Copyright: (c) 2007 Sebastian Reichel                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This program is free software; you can redistribute it and/or modidy   *
 * it under the terms of GNU Public License as published by               *
 * the Free Software Foundation; either version 2 of the License, or      *
 * (at your option) any later version.                                    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <gtk/gtk.h>
#include <glib/gprintf.h>
#include <stdarg.h>
#include "gafix.h"

/* my own printf, but for writing into the statusbar */
void
statusbar_write (gchar *text, ...)
{
	gchar string[100];	
	va_list ap;

    va_start(ap, text);						//init va_list
    g_vsnprintf(string, 100, text, ap);		//do the snprintf with va_list
    va_end(ap);								//end va_list

	/* write new string to statusbar */
	gtk_statusbar_push ( GTK_STATUSBAR(statusbar), 0, string );
}

void
statusbar_clear ( void )
{
	gtk_statusbar_pop ( GTK_STATUSBAR(statusbar), 0 );
}
