/**
 * @file meta-person.h MetaPerson API
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#ifndef _GALAGOD_META_PERSON_H_
#define _GALAGOD_META_PERSON_H_

typedef struct _GalagodMetaPerson GalagodMetaPerson;

#include <libgalago/galago.h>

struct _GalagodMetaPerson
{
	GalagoPerson *person;

	GList *people;
};

#define GALAGOD_META_PERSON(person) \
	(g_object_get_data(G_OBJECT(person), "meta-person"))

GalagodMetaPerson *galagod_meta_person_new(void);
void galagod_meta_person_destroy(GalagodMetaPerson *meta_person);

void galagod_meta_person_merge(GalagodMetaPerson *dest,
							   GalagodMetaPerson *src);

GalagoPerson *galagod_meta_person_get_person(
	const GalagodMetaPerson *meta_person);

GList *galagod_meta_person_get_people(const GalagodMetaPerson *meta_person);

void galagod_meta_person_add_person(GalagodMetaPerson *meta_person,
									GalagoPerson *person);
void galagod_meta_person_remove_person(GalagodMetaPerson *meta_person,
									   GalagoPerson *person);

#endif /* _GALAGOD_META_PERSON_H_ */
