#!/usr/bin/env python

import pygtk
import galago
import sys

def get_name_from_status_type(status_type):
    if status_type == galago.STATUS_UNSET:
        return "Unset"
    elif status_type == galago.STATUS_OFFLINE:
        return "Offline"
    elif status_type == galago.STATUS_AVAILABLE:
        return "Available"
    elif status_type == galago.STATUS_AWAY:
        return "Away"
    elif status_type == galago.STATUS_EXTENDED_AWAY:
        return "Extended Away"
    elif status_type == galago.STATUS_HIDDEN:
        return "Hidden"
    else:
        raise "Unknown status type %d" % status_type


if len(sys.argv) != 3:
    print "Usage: get-presence.py service-id username"
    sys.exit(1)

service_id = sys.argv[1]
username   = sys.argv[2]

galago.init("get-presence")

service = galago.get_service(service_id)

if service == None:
    print "Unknown service %s" % service_id
    sys.exit(1)

account = service.get_account(username)

if account == None:
    print "Unknown account %s on service %s" % (username, service_id)
    sys.exit(1)

presence = account.get_presence()
person = account.get_person()

print "Service:      %s" % service.get_name()
print "Username:     %s" % account.get_username()
print "Display name: %s" % account.get_display_name()

if presence == None:
    print "No presence"
else:
    print "Idle:         %d" % presence.is_idle()
    print "Idle Time:    %d" % presence.get_idle_time()

    print "Status(es):"

    for status in presence.get_statuses():
        print "\tType: %s" % get_name_from_status_type(status.get_primitive())
        print "\tID:   %s" % status.get_id()
        print "\tName: %s" % status.get_name()

        attrs = status.get_attributes()

        if len(attrs) > 0:
            print "\tAttributes:"
            for attr in attrs:
                print "\t\t%s: %s" % (attr[0], attr[1])
