namespace Galago
{
	using System;
	using System.Runtime.InteropServices;

	public class Log
	{
		[DllImport("libgalago.so")]
		static extern void galago_log_set_enabled(int level, bool enabled);

		public static void SetEnabled(LogLevel level, bool enabled)
		{
			galago_log_set_enabled((int)level, enabled);
		}

		[DllImport("libgalago.so")]
		static extern void galago_log(int level, string format);

		public static void Message(LogLevel level, string text)
		{
			galago_log((int)level, text);
		}

		public static void Misc(string text)
		{
			Message(LogLevel.Misc, text);
		}

		public static void Info(string text)
		{
			Message(LogLevel.Info, text);
		}

		public static void Warning(string text)
		{
			Message(LogLevel.Warning, text);
		}

		public static void Error(string text)
		{
			Message(LogLevel.Error, text);
		}

		public static void Fatal(string text)
		{
			Message(LogLevel.Fatal, text);
		}
	}
}
