namespace Galago
{
	using System;
	using System.Runtime.InteropServices;

	public class Photo
		: Object
	{
		~Photo()
		{
			Dispose();
		}

		public Photo(IntPtr raw) : base(raw) {}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_photo_new(IntPtr person, byte[] data,
											   int len);

		public Photo(Person person, byte[] data)
		{
			Raw = galago_photo_new(person.Handle, data, data.Length);
		}

		[DllImport("libgalago.so")]
		static extern void galago_photo_set_image_data(IntPtr photo,
													   byte[] data, int len);

		[DllImport("libgalago.so")]
		unsafe static extern void galago_photo_get_image_data(IntPtr photo,
															  out byte *data,
															  out int len);

		public byte[] ImageData
		{
			get
			{
				unsafe
				{
					byte *data = null;
					int len = 0;

					galago_photo_get_image_data(Handle, out data, out len);

					byte[] ret_data = new byte[len];

					for (int i = 0; i < len; i++) {
						ret_data[i] = *data++;
					}

					return ret_data;
				}
			}
			set { galago_photo_set_image_data(Handle, value, value.Length); }
		}
	}
}
