namespace Galago
{
	using System;
	using System.Collections;
	using System.Runtime.InteropServices;

	public abstract class SignalCallback
		: IDisposable
	{
		protected static int _NextKey = 0;
		protected static Hashtable _Instances = new Hashtable();

		protected Object _obj;
		protected Delegate _handler;
		protected int _key;
		protected System.Type _argsType;
		protected uint _handlerId;

		protected SignalCallback(Object obj, Delegate d, System.Type argsType)
		{
			_key      = _NextKey++;
			_obj      = obj;
			_handler  = d;
			_argsType = argsType;

			_Instances[_key] = this;
		}

		public void Dispose()
		{
			Dispose(true);

			GC.SuppressFinalize(this);
		}

		protected virtual void Dispose(bool disposing)
		{
			if (disposing)
			{
				_obj      = null;
				_handler  = null;
				_argsType = null;
			}
		}

		~SignalCallback()
		{
			Dispose(false);
		}

		public void AddDelegate(Delegate d)
		{
			_handler = Delegate.Combine(_handler, d);
		}

		public void RemoveDelegate(Delegate d)
		{
			_handler = Delegate.Remove(_handler, d);
		}

		[DllImport("libgalago.so")]
		static extern uint galago_signal_connect(IntPtr obj, string signal,
												 Delegate cb, int key);

		protected void Connect(string name, Delegate cb)
		{
			_handlerId = galago_signal_connect(_obj.Handle, name, cb, _key);
		}

		[DllImport("libgalago.so")]
		static extern void galago_signals_disconnect_by_id(uint id);

		protected void Disconnect()
		{
			galago_signals_disconnect_by_id(_handlerId);
		}
	}
}
