namespace Galago.Tests
{
	using System;
	using Galago;
	using GLib;

	public class PresenceFeed
	{
		public static int Main(string[] args)
		{
			MainLoop mainloop = new MainLoop();

			if (!Galago.Global.Init("test-feed", Galago.InitFlags.Feed))
			{
				Console.WriteLine("Unable to initialize Galago");

				return 1;
			}

			SetupInfo();

			mainloop.Run();

			return 0;
		}

		private static void SetupInfo()
		{
			Service aimService, jabberService;
			Status status;
			Account account;
			Account contact;
			Person person;
			Person me;
			Presence presence;

			/* Setup our services */
			aimService =
				Galago.Global.CreateService("aim", "AOL Instant Messenger");
			jabberService =
				Galago.Global.CreateService("jabber", "Jabber");

			/* Create our local person */
			me = Galago.Global.GetMe(Galago.Origin.Local, false);

			/* Setup our person's AIM account */
			account  = aimService.CreateAccount(me, "GalagoAIMUser");
			presence = account.CreatePresence();

			presence.SetIdle(true, System.DateTime.Now);

			status = new Status(StatusType.Away, "away", "Away");
			status.SetAttribute("message", "I'm eating dinner.");

			presence.AddStatus(status);

			/* Add contacts to our AIM account */
			person   = Galago.Global.CreatePerson("gonkulator-1");
			contact  = aimService.CreateAccount(person, "lottabs2");
			presence = contact.CreatePresence();

			presence.SetIdle(true, System.DateTime.Now);
			account.AddContact(contact);

			/* Setup our person's Jabber account */
			account = jabberService.CreateAccount(me,
												  "jabberuser@galago.sf.net");
			presence = account.CreatePresence();

			status = new Status(StatusType.Available, "available", "Available");
			presence.AddStatus(status);

			/* Add contacts to our Jabber account */
			person   = Galago.Global.CreatePerson("cae-1");
			contact  = jabberService.CreateAccount(person, "caedan@jabber.org");
			presence = contact.CreatePresence();

			status = new Status(StatusType.Available, "available", "Available");
			presence.AddStatus(status);

			account.AddContact(contact);

			contact = jabberService.CreateAccount(person, "caelum@chipx86.com");
			presence = contact.CreatePresence();

			status = new Status(StatusType.Offline, "offline", "Offline");
			presence.AddStatus(status);

			account.AddContact(contact);
		}
	}
}
