/*
 * Galaxium Messenger
 * Copyright (C) 2007 Ben Motmans <ben.motmans@gmail.com>
 * Copyright (C) 2007 Philippe Durand <draekz@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Collections.Generic;

using Gtk;
using Gdk;

using Galaxium.Core;
using Galaxium.Gui;
using Galaxium.Gui.GtkGui;

namespace Galaxium.Client.GtkGui
{
	public sealed class CategoryTreeNodeBuilder : ITreeNodeBuilder<HintTreeNodeRenderer>
	{
		public void BuildDynamicChildNodes (TreeNodeContext context)
		{
			PreferenceCategory category = context.NodeObject as PreferenceCategory;
			
			foreach (PreferenceWidgetExtension plugin in category.Plugins)
				context.TreeBuilder.AddNode (context.Node, plugin);
		}

		public string ContextMenuExtensionPoint
		{
			get { return "/Galaxium/Gui/PreferenceTree/ContextMenu/Category"; }
		}

		public bool HasDynamicChildNodes (TreeNodeContext context)
		{
			PreferenceCategory category = context.NodeObject as PreferenceCategory;
			return category.Plugins.Count > 0;
		}

		public Type NodeType
		{
			get { return typeof (PreferenceCategory); }
		}

		public void RenderIcon (TreeNodeContext context, HintTreeNodeRenderer renderer, ITreeNodeWidget widget)
		{
			DefaultTreeNodeWidget nodeWidget = widget as DefaultTreeNodeWidget;
			
			if (nodeWidget != null)
			{
				CellRendererPixbuf cell = nodeWidget.GetPixbufRenderer ();
				
				if (cell != null)
					renderer.RenderIcon (cell, null, true);
			}
		}

		public void RenderText (TreeNodeContext context, HintTreeNodeRenderer renderer, ITreeNodeWidget widget)
		{
			DefaultTreeNodeWidget nodeWidget = widget as DefaultTreeNodeWidget;
			
			if (nodeWidget != null)
			{
				CellRendererText cell = nodeWidget.GetTextRenderer ();
				
				if (cell != null)
				{
					PreferenceCategory category = context.NodeObject as PreferenceCategory;
					renderer.RenderText (cell, String.Concat ("<b>", category.Name, "</b>"), true);
				}
			}
		}

		public void NodeActivated (TreeNodeContext context)
		{
			
		}

		public string GetComparableContent (TreeNodeContext context)
		{
			return (context.NodeObject as PreferenceCategory).Name;
		}
	}
}