/*
 * Galaxium Messenger
 * 
 * Copyright (C) 2008 Paul Burton <paulburton89@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace Galaxium.Protocol.Msn.Soap.BodyParts
{
	[XmlRoot (Namespace=SoapConstants.nsAddressBook)]
	public class Service
	{
		MembershipCollection _memberships = new MembershipCollection ();
		ServiceInfo _info = new ServiceInfo ();
		DateTime _lastChange;
		bool _lastChangeSpecified;
		
		[XmlArray]
		[XmlArrayItem (Type=typeof (Membership))]
		public MembershipCollection Memberships
		{
			get { return _memberships; }
			set { _memberships = value; }
		}
		
		public ServiceInfo Info
		{
			get { return _info; }
			set { _info = value; }
		}
		
		public DateTime LastChange
		{
			get { return _lastChange; }
			set
			{
				_lastChange = value;
				_lastChangeSpecified = true;
			}
		}
		
		[XmlIgnore]
		public bool LastChangeSpecified
		{
			get { return _lastChangeSpecified; }
			set { _lastChangeSpecified = value; }
		}
		
		public Service Clone ()
		{
			Service s = new Service ();
			
			s._info = _info.Clone ();
			s._lastChange = _lastChange;
			s._lastChangeSpecified = _lastChangeSpecified;
			s._memberships = _memberships.Clone ();
			
			return s;
		}
	}
	
	public class ServiceCollection : List<Service>
	{
		public Service this [string id]
		{
			get
			{
				foreach (Service service in this)
				{
					if ((service.Info != null) && (service.Info.Handle != null) && (service.Info.Handle.Type.Name == id))
						return service;
				}
				
				return null;
			}
		}
	}
}
