/*
 * Galaxium Messenger
 * Copyright (C) 2007 Ben Motmans <ben.motmans@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Text;
using System.Collections.Generic;

using Galaxium.Core;

namespace Galaxium.Protocol
{
	public class TextStyle : ITextStyle
	{
		protected bool _bold = false;
		protected bool _italic = false;
		protected bool _underline = false;
		protected bool _strike = false;

		protected int _foreColor = -1;
		protected int _foreColorEnd = -1;
		protected int _backColor = -1;
		protected int _backColorEnd = -1;
		
		protected string _font = "sans-serif";
		protected int _fontSize = 10;

		protected bool _isDefault;
		protected bool _isDefaultFont;
		protected bool _isHyperlink = false;

		public TextStyle ()
		{
			_isDefault = true;
			_isDefaultFont = true;
		}

		public TextStyle (bool isHyperlink)
		{
			_isDefault = !isHyperlink;
			_isHyperlink = isHyperlink;
			_isDefaultFont = true;
		}
		
		public TextStyle (bool bold, bool italic, bool underline, bool strike)
		{
			this._isDefault = false;
			this._isDefaultFont = true;

			this._bold = bold;
			this._italic = italic;
			this._underline = underline;
			this._strike = strike;
		}

		public TextStyle (string font, int fontSize, bool bold, bool italic, bool underline, bool strike, int color)
			: this (bold, italic, underline, strike)
		{
			ThrowUtility.ThrowIfNull ("font", font);
			ThrowUtility.ThrowIfLessThenOne ("fontSize", fontSize);

			this._isDefaultFont = false;
			this._foreColor = color;
			
			this._font = font;
			this._fontSize = fontSize;
		}
		
		public TextStyle(string font, int fontSize)
		{
			ThrowUtility.ThrowIfNull ("font", font);
			ThrowUtility.ThrowIfLessThenOne ("fontSize", fontSize);
			
			this._isDefault = false;
			this._isDefaultFont = false;
			
			this._font = font;
			this._fontSize = fontSize;
		}
		
		public virtual object Clone ()
		{
			TextStyle style = new TextStyle ();
			
			style._backColor = _backColor;
			style._backColorEnd = _backColorEnd;
			style._bold = _bold;
			style._font = _font;
			style._fontSize = _fontSize;
			style._foreColor = _foreColor;
			style._foreColorEnd = _foreColorEnd;
			style._isDefault = _isDefault;
			style._isDefaultFont = _isDefaultFont;
			style._isHyperlink = _isHyperlink;
			style._italic = _italic;
			style._strike = _strike;
			style._underline = _underline;
			
			return style;
		}
		
		public bool Bold
		{
			get { return _bold; }
			set { _bold = value; }
		}

		public bool Italic
		{
			get { return _italic; }
			set { _italic = value; }
		}

		public bool Underline
		{
			get { return _underline; }
			set { _underline = value; }
		}

		public bool Strikethrough
		{
			get { return _strike; }
			set { _strike = value; }
		}

		public int ForeColor
		{
			get { return _foreColor; }
			set { _foreColor = value; }
		}

		public int ForeColorEnd
		{
			get { return _foreColorEnd; }
			set { _foreColorEnd = value; }
		}

		public int BackColor
		{
			get { return _backColor; }
			set { _backColor = value; }
		}

		public int BackColorEnd
		{
			get { return _backColorEnd; }
			set { _backColorEnd = value; }
		}

		public string Font
		{
			get { return _font; }
			set { _font = value; }
		}

		public int FontSize
		{
			get { return _fontSize; }
			set { _fontSize = value; }
		}

		public bool IsDefault
		{
			get { return _isDefault; }
		}
		
		public bool IsDefaultFont
		{
			get { return _isDefaultFont; }
		}
		
		public bool IsHyperlink
		{
			get { return _isHyperlink; }
			set { _isHyperlink = value; }
		}
	}
}