/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import HTTPClient.AuthorizationInfo;
import HTTPClient.Cookie;
import HTTPClient.CookieModule;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import com.gallery.GalleryRemote.AuthorizePopup;
import com.gallery.GalleryRemote.GalleryComm2;
import com.gallery.GalleryRemote.GalleryComm2_5;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.swing.JOptionPane;

public abstract class GalleryComm
implements PreferenceNames {
    private static final String MODULE = "GalComm";
    int[] capabilities = null;
    private static int lastRespCode = 0;
    protected boolean isLoggedIn = false;
    protected boolean triedLogin = false;

    public void uploadFiles(StatusUpdate su, boolean async) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public void fetchAlbums(StatusUpdate su, boolean async) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public void albumInfo(StatusUpdate su, Album a, boolean async) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public String newAlbum(StatusUpdate su, Album parentAlbum, String newAlbumName, String newAlbumTitle, String newAlbumDesc, boolean async) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public void fetchAlbumImages(StatusUpdate su, Album a, boolean recusive, boolean async, int maxPictures) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public boolean moveAlbum(StatusUpdate su, Album a, Album newParent, boolean async) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public void login(StatusUpdate su) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public void logOut() {
        Log.log(2, MODULE, "Logging out and clearing cookies");
        this.isLoggedIn = false;
        CookieModule.discardAllCookies();
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public boolean hasCapability(StatusUpdate su, int capability) {
        if (!this.isLoggedIn() && !this.triedLogin) {
            this.login(su);
        }
        return Arrays.binarySearch(this.capabilities, capability) >= 0;
    }

    public static boolean wasAuthFailure() {
        boolean result = lastRespCode == 401;
        return result;
    }

    public static GalleryComm getCommInstance(StatusUpdate su, URL url, Gallery g) {
        block18: {
            try {
                PropertiesFile p = GalleryRemote._().properties;
                String proxyList = System.getProperty("javaplugin.proxy.config.list");
                String proxyHost = null;
                int proxyPort = 80;
                String proxyUsername = null;
                String proxyPassword = null;
                if (proxyList != null && proxyList.length() != 0) {
                    try {
                        proxyList = proxyList.toUpperCase();
                        Log.log(3, MODULE, "Plugin Proxy Config List Property:" + proxyList);
                        proxyHost = proxyList.indexOf("HTTP=") > -1 ? proxyList.substring(proxyList.indexOf("HTTP=") + 5, proxyList.indexOf(":")) : proxyList.substring(0, proxyList.indexOf(":"));
                        int endOfPort = proxyList.indexOf(",");
                        if (endOfPort < 1) {
                            endOfPort = proxyList.length();
                        }
                        proxyPort = Integer.parseInt(proxyList.substring(proxyList.indexOf(":") + 1, endOfPort));
                        Log.log(3, MODULE, "proxy " + proxyHost + " port " + proxyPort);
                    }
                    catch (Exception e) {
                        Log.log(3, MODULE, "Exception during failover auto proxy detection");
                        Log.logException(1, MODULE, e);
                    }
                } else if (p.getBooleanProperty("useProxy")) {
                    proxyHost = ((Properties)p).getProperty("proxyHost");
                    try {
                        proxyPort = p.getIntProperty("proxyPort");
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    proxyUsername = ((Properties)p).getProperty("proxyUsername");
                    if (proxyUsername != null && proxyUsername.length() > 0) {
                        proxyPassword = p.getBase64Property("proxyPassword");
                    }
                }
                if (proxyHost != null) {
                    Log.log(3, MODULE, "Setting proxy to " + proxyHost + ":" + proxyPort);
                    HTTPConnection.setProxyServer((String)proxyHost, (int)proxyPort);
                    if (proxyUsername != null && proxyUsername.length() > 0) {
                        Log.log(3, MODULE, "Setting proxy auth to " + proxyUsername + ":" + proxyPassword);
                        AuthorizationInfo.addBasicAuthorization((String)proxyHost, (int)proxyPort, (String)"", (String)proxyUsername, (String)proxyPassword);
                    }
                } else {
                    HTTPConnection.setProxyServer(null, (int)0);
                }
                HTTPConnection mConnection = new HTTPConnection(url);
                GalleryComm.addUserInfo(mConnection, url);
                if (g.getType() == 0) {
                    String urlPath = url.getFile();
                    Log.log(3, MODULE, "Trying protocol 2 for " + url);
                    String urlPath2 = urlPath + (urlPath.endsWith("/") ? "gallery_remote2.php" : "/gallery_remote2.php");
                    if (GalleryComm.tryComm(su, mConnection, urlPath2)) {
                        Log.log(3, MODULE, "Server has protocol 2");
                        return new GalleryComm2(g);
                    }
                    Log.log(3, MODULE, "Trying protocol 2.5 for " + url);
                    String urlPath2_5 = urlPath + (urlPath.endsWith("/") ? "modules/remote/module.inc" : "/modules/remote/module.inc");
                    if (GalleryComm.tryComm(su, mConnection, urlPath2_5)) {
                        Log.log(3, MODULE, "Server has protocol 2.5");
                        return new GalleryComm2_5(g);
                    }
                    Log.log(3, MODULE, "Trying protocol 1 for " + url);
                    String scriptName = "gallery_remote.php";
                    String urlPath1 = urlPath + (urlPath.endsWith("/") ? scriptName : "/" + scriptName);
                    if (lastRespCode != 401 && GalleryComm.tryComm(su, mConnection, urlPath1)) {
                        Log.log(3, MODULE, "Server has protocol 1");
                    }
                    break block18;
                }
                return new GalleryComm2(g);
            }
            catch (ProtocolNotSuppException e) {
                Log.logException(1, MODULE, e);
            }
        }
        return null;
    }

    public static void addUserInfo(HTTPConnection conn, URL url) {
        StringTokenizer st;
        String userInfo = url.getUserInfo();
        if (userInfo != null && (st = new StringTokenizer(userInfo, ":")).countTokens() == 2) {
            String username = st.nextToken();
            String password = st.nextToken();
            Log.log(3, MODULE, "Added basic auth params: " + username + " - " + password);
            AuthorizePopup.hackUsername = username;
            AuthorizePopup.hackPassword = password;
            return;
        }
        AuthorizePopup.hackUsername = null;
        AuthorizePopup.hackPassword = null;
    }

    private static boolean tryComm(StatusUpdate su, HTTPConnection mConnection, String urlPath) {
        try {
            int rspCode;
            HTTPResponse rsp = null;
            rsp = mConnection.Head(urlPath);
            lastRespCode = rspCode = rsp.getStatusCode();
            if (rspCode >= 300 && rspCode < 400) {
                rsp = mConnection.Post(urlPath);
                rspCode = rsp.getStatusCode();
            }
            Log.log(3, MODULE, "tryComm " + urlPath + ": " + rspCode);
            return rspCode == 200;
        }
        catch (UnknownHostException uhe) {
            su.error("Unknown host: " + mConnection.getHost());
        }
        catch (IOException ioe) {
            try {
                if (ioe instanceof SSLPeerUnverifiedException) {
                    Log.logException(1, MODULE, ioe);
                    JOptionPane.showMessageDialog((Component)((Object)su), GRI18n.getString(MODULE, "noAuth"), GRI18n.getString(MODULE, "error"), 0);
                }
                Log.logException(1, MODULE, ioe);
            }
            catch (NoClassDefFoundError ncdfe) {
                Log.logException(1, MODULE, ioe);
            }
        }
        catch (ModuleException me) {
            Log.logException(1, MODULE, me);
        }
        return false;
    }

    static {
        AuthorizePopup.enable();
        CookieModule.setCookiePolicyHandler((CookiePolicyHandler)new CookiePolicyHandler(){

            public boolean acceptCookie(Cookie cookie, RoRequest req, RoResponse resp) {
                Log.log(3, GalleryComm.MODULE, "Accepting cookie: " + cookie);
                return true;
            }

            public boolean sendCookie(Cookie cookie, RoRequest req) {
                Log.log(3, GalleryComm.MODULE, "Sending cookie: " + cookie);
                return true;
            }
        });
    }
}

