/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Dimension;
import java.awt.Image;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.ImageIcon;

public class ThumbnailCache
implements Runnable {
    public static final String MODULE = "ThumbCache";
    boolean stillRunning = false;
    Stack toLoad = new Stack();
    HashMap thumbnails = new HashMap();

    public void run() {
        Thread.yield();
        int loaded = 0;
        GalleryRemote._().getCore().getMainStatusUpdate().startProgress(2, 0, this.toLoad.size(), GRI18n.getString((String)MODULE, (String)"loadThmb"), false);
        while (!this.toLoad.isEmpty()) {
            Picture p = (Picture)this.toLoad.pop();
            ImageIcon i = null;
            if (this.thumbnails.containsKey(p)) continue;
            if (p.isOnline()) {
                i = new ImageIcon(p.getUrlThumbnail());
                Image scaled = null;
                Dimension newD = ImageUtils.getSizeKeepRatio((Dimension)new Dimension(i.getIconWidth(), i.getIconHeight()), (Dimension)GalleryRemote._().properties.getThumbnailSize(), (boolean)true);
                if (newD != null) {
                    scaled = i.getImage().getScaledInstance(newD.width, newD.height, 2);
                    i.getImage().flush();
                    i.setImage(scaled);
                }
            } else {
                i = ImageUtils.load((String)p.getSource().getPath(), (Dimension)GalleryRemote._().properties.getThumbnailSize(), (int)0);
            }
            this.thumbnails.put(p, i);
            Log.log((int)3, (String)MODULE, (String)("update progress " + ++loaded + "/" + (loaded + this.toLoad.size())));
            GalleryRemote._().getCore().getMainStatusUpdate().updateProgressValue(2, loaded, loaded + this.toLoad.size());
            GalleryRemote._().getCore().thumbnailLoadedNotify();
        }
        this.stillRunning = false;
        GalleryRemote._().getCore().getMainStatusUpdate().stopProgress(2, GRI18n.getString((String)MODULE, (String)"thmbLoaded"));
    }

    public void preloadThumbnailFirst(Picture p) {
        Log.log((int)3, (String)MODULE, (String)("preloadThumbnailFirst " + p));
        if (!this.thumbnails.containsKey(p)) {
            this.toLoad.push(p);
            this.rerun();
        }
    }

    public void preloadThumbnails(Iterator pictures) {
        Log.log((int)3, (String)MODULE, (String)"preloadThumbnails");
        while (pictures.hasNext()) {
            Picture p = (Picture)pictures.next();
            if (this.thumbnails.containsKey(p)) continue;
            this.toLoad.add(0, p);
        }
        this.rerun();
    }

    public void reload() {
        Iterator it = ((HashMap)this.thumbnails.clone()).keySet().iterator();
        this.thumbnails.clear();
        this.preloadThumbnails(it);
    }

    public void flushMemory() {
        Iterator it = this.thumbnails.values().iterator();
        while (it.hasNext()) {
            ImageIcon i = (ImageIcon)it.next();
            if (i.getImage() == null) continue;
            i.getImage().flush();
        }
        this.thumbnails.clear();
    }

    void rerun() {
        if (!this.stillRunning && GalleryRemote._().properties.getShowThumbnails()) {
            this.stillRunning = true;
            Log.log((int)3, (String)MODULE, (String)"Calling Start");
            new Thread(this).start();
        }
    }

    void cancelLoad() {
        this.toLoad.clear();
    }

    public ImageIcon getThumbnail(Picture p) {
        return (ImageIcon)this.thumbnails.get(p);
    }
}

