/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;

public class OlympusMakernoteDescriptor
extends TagDescriptor {
    public OlympusMakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int n) throws MetadataException {
        switch (n) {
            case 512: {
                return this.getSpecialModeDescription();
            }
            case 513: {
                return this.getJpegQualityDescription();
            }
            case 514: {
                return this.getMacroModeDescription();
            }
            case 516: {
                return this.getDigiZoomRatioDescription();
            }
        }
        return this._directory.getString(n);
    }

    private String getDigiZoomRatioDescription() throws MetadataException {
        if (!this._directory.containsTag(516)) {
            return null;
        }
        int n = this._directory.getInt(516);
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 2: {
                return "Digital 2x Zoom";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String getMacroModeDescription() throws MetadataException {
        if (!this._directory.containsTag(514)) {
            return null;
        }
        int n = this._directory.getInt(514);
        switch (n) {
            case 0: {
                return "Normal (no macro)";
            }
            case 1: {
                return "Macro";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String getJpegQualityDescription() throws MetadataException {
        if (!this._directory.containsTag(513)) {
            return null;
        }
        int n = this._directory.getInt(513);
        switch (n) {
            case 1: {
                return "SQ";
            }
            case 2: {
                return "HQ";
            }
            case 3: {
                return "SHQ";
            }
        }
        return "Unknown (" + n + ")";
    }

    private String getSpecialModeDescription() throws MetadataException {
        if (!this._directory.containsTag(512)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(512);
        StringBuffer stringBuffer = new StringBuffer();
        switch (nArray[0]) {
            case 0: {
                stringBuffer.append("Normal picture taking mode");
                break;
            }
            case 1: {
                stringBuffer.append("Unknown picture taking mode");
                break;
            }
            case 2: {
                stringBuffer.append("Fast picture taking mode");
                break;
            }
            case 3: {
                stringBuffer.append("Panorama picture taking mode");
                break;
            }
            default: {
                stringBuffer.append("Unknown picture taking mode");
            }
        }
        stringBuffer.append(" - ");
        switch (nArray[1]) {
            case 0: {
                stringBuffer.append("Unknown sequence number");
                break;
            }
            case 1: {
                stringBuffer.append("1st in a sequnce");
                break;
            }
            case 2: {
                stringBuffer.append("2nd in a sequence");
                break;
            }
            case 3: {
                stringBuffer.append("3rd in a sequence");
                break;
            }
            default: {
                stringBuffer.append(nArray[1]);
                stringBuffer.append("th in a sequence");
            }
        }
        switch (nArray[2]) {
            case 1: {
                stringBuffer.append("Left to right panorama direction");
                break;
            }
            case 2: {
                stringBuffer.append("Right to left panorama direction");
                break;
            }
            case 3: {
                stringBuffer.append("Bottom to top panorama direction");
                break;
            }
            case 4: {
                stringBuffer.append("Top to bottom panorama direction");
            }
        }
        return stringBuffer.toString();
    }
}

