<?php
/*
 * $RCSfile: WatermarkImage.inc,v $
 *
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2005 Bharat Mediratta
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
/**
 * @package Watermark
 * @subpackage ClassInterfaces
 * @version $Revision: 1.7 $ $Date: 2005/08/23 03:49:57 $
 * @author Bharat Mediratta <bharat@menalto.com>
 */

/**
 * Interface class for the WatermarkImage class.
 * (Class schema version: 1.1)
 *
 * This file is automatically generated from XML embedded in the
 * class, combined with the ClassCode.xsl file.  You should not modify
 * it by hand, as your changes will be lost next time this file is
 * rebuilt.  If you want to add more getters/setters, you should add
 * them in the core class.  If you want to change the format of this
 * file, then you should edit the XSL template.
 *
 * @package Watermark
 * @subpackage Classes
 */
class WatermarkImage extends WatermarkImage_core {
  
    /**
     * Return meta information about the members of this class
     *
     * @return array member => array(type, class)
     */
    function getPersistentMemberInfo() {
	$meta = parent::getPersistentMemberInfo();
	$meta['members']['applyToPreferred'] = array('class' => 'WatermarkImage', 'type' => STORAGE_TYPE_BOOLEAN);
    
	$meta['members']['applyToResizes'] = array('class' => 'WatermarkImage', 'type' => STORAGE_TYPE_BOOLEAN);
    
	$meta['members']['applyToThumbnail'] = array('class' => 'WatermarkImage', 'type' => STORAGE_TYPE_BOOLEAN);
    
	$meta['members']['name'] = array('class' => 'WatermarkImage', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['fileName'] = array('class' => 'WatermarkImage', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['mimeType'] = array('class' => 'WatermarkImage', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['size'] = array('class' => 'WatermarkImage', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['width'] = array('class' => 'WatermarkImage', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['height'] = array('class' => 'WatermarkImage', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['ownerId'] = array('class' => 'WatermarkImage', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['xPercentage'] = array('class' => 'WatermarkImage', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['yPercentage'] = array('class' => 'WatermarkImage', 'type' => STORAGE_TYPE_STRING);
    
	return $meta;
    }

    /**
     * Get the data from this persistent object as an associative array
     *
     * @return array memberName => memberValue
     */
    function getMemberData() {
	$data = parent::getMemberData();
        $data['applyToPreferred'] = isset($this->_applyToPreferred) ? $this->_applyToPreferred : null;
        $data['applyToResizes'] = isset($this->_applyToResizes) ? $this->_applyToResizes : null;
        $data['applyToThumbnail'] = isset($this->_applyToThumbnail) ? $this->_applyToThumbnail : null;
        $data['name'] = isset($this->_name) ? $this->_name : null;
        $data['fileName'] = isset($this->_fileName) ? $this->_fileName : null;
        $data['mimeType'] = isset($this->_mimeType) ? $this->_mimeType : null;
        $data['size'] = isset($this->_size) ? $this->_size : null;
        $data['width'] = isset($this->_width) ? $this->_width : null;
        $data['height'] = isset($this->_height) ? $this->_height : null;
        $data['ownerId'] = isset($this->_ownerId) ? $this->_ownerId : null;
        $data['xPercentage'] = isset($this->_xPercentage) ? $this->_xPercentage : null;
        $data['yPercentage'] = isset($this->_yPercentage) ? $this->_yPercentage : null;
	return $data;
    }
  
    /**
     * Return the name of this class with the proper mix of uppercase and
     * lowercase (get_class() always returns lowercase)
     *
     * @return string class name
     */
    function getClassName() {
	return 'WatermarkImage';
    }

    /** 
     * Return the path to the PHP file for this class, relative to the gallery2 dir
     * 
     * @return string path
     */ 
    function getClassFile() { 
        return 'modules/' .  
            basename(dirname(dirname(dirname(__FILE__)))) .  
            '/classes/WatermarkImage.class'; 
    }
    
    /**
     * Get the value of applyToPreferred
     *
     * @return BOOLEAN the value
     */
    function getapplyToPreferred() {
	if (!isset($this->_applyToPreferred)) {
	    return null;
	}
	return $this->_applyToPreferred;
    }

    /**
     * Set the value of applyToPreferred
     *
     * @param BOOLEAN the value
     */
    function setapplyToPreferred($value) {
	/* Set the incoming value to be a 1 or 0 */
	$value = empty($value) ? 0 : 1;
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_applyToPreferred) ? $this->_applyToPreferred : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('applyToPreferred', $value);
	    $this->_applyToPreferred = $value;
	}
    }
  
    /**
     * Get the value of applyToResizes
     *
     * @return BOOLEAN the value
     */
    function getapplyToResizes() {
	if (!isset($this->_applyToResizes)) {
	    return null;
	}
	return $this->_applyToResizes;
    }

    /**
     * Set the value of applyToResizes
     *
     * @param BOOLEAN the value
     */
    function setapplyToResizes($value) {
	/* Set the incoming value to be a 1 or 0 */
	$value = empty($value) ? 0 : 1;
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_applyToResizes) ? $this->_applyToResizes : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('applyToResizes', $value);
	    $this->_applyToResizes = $value;
	}
    }
  
    /**
     * Get the value of applyToThumbnail
     *
     * @return BOOLEAN the value
     */
    function getapplyToThumbnail() {
	if (!isset($this->_applyToThumbnail)) {
	    return null;
	}
	return $this->_applyToThumbnail;
    }

    /**
     * Set the value of applyToThumbnail
     *
     * @param BOOLEAN the value
     */
    function setapplyToThumbnail($value) {
	/* Set the incoming value to be a 1 or 0 */
	$value = empty($value) ? 0 : 1;
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_applyToThumbnail) ? $this->_applyToThumbnail : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('applyToThumbnail', $value);
	    $this->_applyToThumbnail = $value;
	}
    }
  
    /**
     * Get the value of name
     *
     * @return STRING the value
     */
    function getname() {
	if (!isset($this->_name)) {
	    return null;
	}
	return $this->_name;
    }

    /**
     * Set the value of name
     *
     * @param STRING the value
     */
    function setname($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 128);
	$orig = isset($this->_name) ? $this->_name : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('name', $value);
	    $this->_name = $value;
	}
    }
  
    /**
     * Get the value of fileName
     *
     * @return STRING the value
     */
    function getfileName() {
	if (!isset($this->_fileName)) {
	    return null;
	}
	return $this->_fileName;
    }

    /**
     * Set the value of fileName
     *
     * @param STRING the value
     */
    function setfileName($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 128);
	$orig = isset($this->_fileName) ? $this->_fileName : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('fileName', $value);
	    $this->_fileName = $value;
	}
    }
  
    /**
     * Get the value of mimeType
     *
     * @return STRING the value
     */
    function getmimeType() {
	if (!isset($this->_mimeType)) {
	    return null;
	}
	return $this->_mimeType;
    }

    /**
     * Set the value of mimeType
     *
     * @param STRING the value
     */
    function setmimeType($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 128);
	$orig = isset($this->_mimeType) ? $this->_mimeType : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('mimeType', $value);
	    $this->_mimeType = $value;
	}
    }
  
    /**
     * Get the value of size
     *
     * @return INTEGER the value
     */
    function getsize() {
	if (!isset($this->_size)) {
	    return null;
	}
	return $this->_size;
    }

    /**
     * Set the value of size
     *
     * @param INTEGER the value
     */
    function setsize($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_size) ? $this->_size : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('size', $value);
	    $this->_size = $value;
	}
    }
  
    /**
     * Get the value of width
     *
     * @return INTEGER the value
     */
    function getwidth() {
	if (!isset($this->_width)) {
	    return null;
	}
	return $this->_width;
    }

    /**
     * Set the value of width
     *
     * @param INTEGER the value
     */
    function setwidth($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_width) ? $this->_width : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('width', $value);
	    $this->_width = $value;
	}
    }
  
    /**
     * Get the value of height
     *
     * @return INTEGER the value
     */
    function getheight() {
	if (!isset($this->_height)) {
	    return null;
	}
	return $this->_height;
    }

    /**
     * Set the value of height
     *
     * @param INTEGER the value
     */
    function setheight($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_height) ? $this->_height : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('height', $value);
	    $this->_height = $value;
	}
    }
  
    /**
     * Get the value of ownerId
     *
     * @return INTEGER the value
     */
    function getownerId() {
	if (!isset($this->_ownerId)) {
	    return null;
	}
	return $this->_ownerId;
    }

    /**
     * Set the value of ownerId
     *
     * @param INTEGER the value
     */
    function setownerId($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_ownerId) ? $this->_ownerId : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('ownerId', $value);
	    $this->_ownerId = $value;
	}
    }
  
    /**
     * Get the value of xPercentage
     *
     * @return STRING the value
     */
    function getxPercentage() {
	if (!isset($this->_xPercentage)) {
	    return null;
	}
	return $this->_xPercentage;
    }

    /**
     * Set the value of xPercentage
     *
     * @param STRING the value
     */
    function setxPercentage($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 32);
	$orig = isset($this->_xPercentage) ? $this->_xPercentage : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('xPercentage', $value);
	    $this->_xPercentage = $value;
	}
    }
  
    /**
     * Get the value of yPercentage
     *
     * @return STRING the value
     */
    function getyPercentage() {
	if (!isset($this->_yPercentage)) {
	    return null;
	}
	return $this->_yPercentage;
    }

    /**
     * Set the value of yPercentage
     *
     * @param STRING the value
     */
    function setyPercentage($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 32);
	$orig = isset($this->_yPercentage) ? $this->_yPercentage : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('yPercentage', $value);
	    $this->_yPercentage = $value;
	}
    }
  
}
?>
