/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.prefs.PreferenceNames;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Log
implements PreferenceNames,
Runnable {
    public static final int LEVEL_CRITICAL = 0;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_TRACE = 3;
    static String[] levelName = new String[]{"CRITI", "ERROR", "INFO ", "TRACE"};
    public static final int sleepInterval = 500;
    public static final int moduleLength = 10;
    public static final String emptyModule = "          ";
    public static final String emptyTime = "       ";
    public static long startTime = System.currentTimeMillis();
    public static int maxLevel = 3;
    public static boolean toSysOut;
    Thread loggerThread = null;
    static int threadPriority;
    static Log singleton;
    static boolean started;
    List logLines = Collections.synchronizedList(new LinkedList());
    boolean running = false;
    List moduleList = null;

    private Log() {
    }

    public static void log(int level, String module, String message) {
        if (level <= maxLevel || !started) {
            module = module == null ? emptyModule : (module + emptyModule).substring(0, 10);
            if (Log.singleton.moduleList != null && !Log.singleton.moduleList.contains(module)) {
                return;
            }
            String time = emptyTime + (System.currentTimeMillis() - startTime);
            time = time.substring(time.length() - emptyTime.length());
            Log.singleton.logLines.add(time + "|" + levelName[level] + "|" + module + "|" + message);
        }
    }

    public static void log(int level, Class c, String message) {
        Log.log(level, c.getName(), message);
    }

    public static void log(int level, Object o, String message) {
        Log.log(level, Log.getShortClassName(o.getClass()), message);
    }

    public static void log(int level, String message) {
        Log.log(level, (String)null, message);
    }

    public static void log(Class c, String message) {
        Log.log(3, Log.getShortClassName(c), message);
    }

    public static void log(Object o, String message) {
        Log.log(3, Log.getShortClassName(o.getClass()), message);
    }

    public static void log(String module, String message) {
        Log.log(3, module, message);
    }

    public static void log(String message) {
        Log.log(3, (String)null, message);
    }

    public static void logStack(int level, String module) {
        if (level <= maxLevel || !started) {
            CharArrayWriter caw = new CharArrayWriter();
            try {
                throw new Exception("Dump stack");
            }
            catch (Exception e) {
                e.printStackTrace(new PrintWriter(caw));
                Log.log(level, module, caw.toString());
            }
        }
    }

    public static void logException(int level, String module, Throwable t) {
        if (level <= maxLevel || !started) {
            CharArrayWriter caw = new CharArrayWriter();
            t.printStackTrace(new PrintWriter(caw));
            Log.log(level, module, caw.toString());
        }
    }

    public static String getShortClassName(Class c) {
        String name = c.getName();
        int i = name.lastIndexOf(".");
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public static void shutdown() {
        Log.singleton.running = false;
        try {
            Log.singleton.loggerThread.join();
        }
        catch (InterruptedException ee) {
            System.err.println("Logger thread killed");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        started = false;
        singleton = new Log();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("Logger thread running");
        BufferedWriter writer = null;
        this.running = true;
        try {
            System.out.println("Creating log file in " + System.getProperty("java.io.tmpdir"));
            writer = new BufferedWriter(new FileWriter(new File(System.getProperty("java.io.tmpdir"), "GalleryRemoteLog.txt")));
            while (this.running) {
                Thread.sleep(500L);
                while (!this.logLines.isEmpty()) {
                    String s = (String)this.logLines.remove(0);
                    writer.write(s);
                    writer.newLine();
                    if (!toSysOut) continue;
                    System.out.println(s);
                }
                writer.flush();
            }
        }
        catch (IOException e) {
            System.err.println("Can't write to log file. Disabling log...");
            maxLevel = -1;
        }
        catch (InterruptedException e) {
            System.err.println("Logger thread killed");
        }
        finally {
            this.running = false;
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Logger thread shutting down");
    }

    public static void startLog(int maxLevel, boolean toSysOut) {
        if (Log.maxLevel != maxLevel) {
            Log.maxLevel = maxLevel;
            Log.singleton.logLines.add("       |" + levelName[3] + "|" + emptyModule + "|" + "Setting Log level to " + levelName[Log.maxLevel]);
        }
        Log.toSysOut = toSysOut;
        try {
            String modules = System.getenv("GR_LOG_MODULES");
            if (modules != null) {
                Log.singleton.moduleList = Arrays.asList(modules.split(","));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Log.singleton.loggerThread = new Thread(singleton);
        Log.singleton.loggerThread.setPriority(threadPriority);
        Log.singleton.loggerThread.start();
    }

    static {
        threadPriority = 3;
        singleton = new Log();
        started = false;
    }
}

