/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import HTTPClient.Codecs;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.TransferListener;
import com.gallery.GalleryRemote.GR2Exception;
import com.gallery.GalleryRemote.GalleryComm;
import com.gallery.GalleryRemote.GalleryComm2Consts;
import com.gallery.GalleryRemote.GalleryCommCapabilities;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.StatusUpdateAdapter;
import com.gallery.GalleryRemote.UploadProgress;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.GalleryProperties;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.HTMLEscaper;
import com.gallery.GalleryRemote.util.NaturalOrderComparator;
import com.gallery.GalleryRemote.util.UrlMessageDialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JOptionPane;

public class GalleryComm2
extends GalleryComm
implements GalleryComm2Consts,
GalleryCommCapabilities,
PreferenceNames {
    private static final String MODULE = "GalComm2";
    public static final String SCRIPT_NAME = "gallery_remote2.php";
    protected String scriptName = "gallery_remote2.php";
    protected final Gallery g;
    protected int serverMinorVersion = 0;
    private static int[] capabilities1;
    private static int[] capabilities2;
    private static int[] capabilities5;
    private static int[] capabilities7;
    private static int[] capabilities9;
    private static int[] capabilities13;
    private static int[] capabilities14;
    private static int[] capabilities15;

    protected GalleryComm2(Gallery g) {
        if (g == null) {
            throw new IllegalArgumentException("Must supply a non-null gallery.");
        }
        this.g = g;
        this.capabilities = new int[]{1, 2, 3, 4, 5};
        capabilities1 = new int[]{1, 2, 3, 4, 5, 6};
        capabilities2 = new int[]{1, 2, 3, 4, 5, 6, 7};
        capabilities5 = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        capabilities7 = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10};
        capabilities9 = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 9};
        capabilities13 = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 9, 11, 12};
        capabilities14 = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 9, 11, 12, 13};
        capabilities15 = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 9, 11, 12, 13, 14};
        Arrays.sort(this.capabilities);
        Arrays.sort(capabilities1);
        Arrays.sort(capabilities2);
        Arrays.sort(capabilities5);
        Arrays.sort(capabilities7);
        Arrays.sort(capabilities9);
        Arrays.sort(capabilities13);
        Arrays.sort(capabilities14);
        Arrays.sort(capabilities15);
    }

    public void uploadFiles(StatusUpdate su, boolean async) {
        UploadTask uploadTask = new UploadTask(su);
        this.doTask(uploadTask, async);
    }

    public void fetchAlbums(StatusUpdate su, boolean async) {
        this.doTask(new AlbumListTask(su), async);
    }

    public void albumProperties(StatusUpdate su, Album a, boolean async) {
        this.doTask(new AlbumPropertiesTask(su, a), async);
    }

    public String newAlbum(StatusUpdate su, Album parentAlbum, String newAlbumName, String newAlbumTitle, String newAlbumDesc, boolean async) {
        NewAlbumTask newAlbumTask = new NewAlbumTask(su, parentAlbum, newAlbumName, newAlbumTitle, newAlbumDesc);
        this.doTask(newAlbumTask, async);
        return newAlbumTask.getNewAlbumName();
    }

    public void fetchAlbumImages(StatusUpdate su, Album a, boolean recusive, boolean async, int maxPictures, boolean random) {
        FetchAlbumImagesTask fetchAlbumImagesTask = new FetchAlbumImagesTask(su, a, recusive, maxPictures, random);
        this.doTask(fetchAlbumImagesTask, async);
    }

    public boolean moveAlbum(StatusUpdate su, Album a, Album newParent, boolean async) {
        MoveAlbumTask moveAlbumTask = new MoveAlbumTask(su, a, newParent);
        this.doTask(moveAlbumTask, async);
        return moveAlbumTask.getSuccess();
    }

    public void login(StatusUpdate su) {
        LoginTask loginTask = new LoginTask(su);
        this.doTask(loginTask, false);
    }

    void doTask(GalleryTask task, boolean async) {
        if (async) {
            Thread t = new Thread(task);
            t.start();
        } else {
            task.run();
        }
    }

    void status(StatusUpdate su, int level, String message) {
        Log.log(2, MODULE, message);
        su.updateProgressStatus(level, message);
    }

    void error(StatusUpdate su, String message) {
        this.status(su, 0, message);
        su.error(message);
    }

    void trace(String message) {
        Log.log(3, MODULE, message);
    }

    boolean isTrue(String s) {
        return s != null && s.equals("true");
    }

    GalleryProperties requestResponse(NVPair[] form_data, StatusUpdate su, GalleryTask task) throws ModuleException, IOException {
        return this.requestResponse(form_data, null, this.g.getGalleryUrl(this.scriptName), true, su, task, null);
    }

    GalleryProperties requestResponse(NVPair[] form_data, URL galUrl, StatusUpdate su, GalleryTask task) throws ModuleException, IOException {
        return this.requestResponse(form_data, null, galUrl, true, su, task, null);
    }

    GalleryProperties requestResponse(NVPair[] form_data, byte[] data, URL galUrl, boolean checkResult, StatusUpdate su, GalleryTask task, MyTransferListener transferListener) throws ModuleException, IOException {
        return this.requestResponse(form_data, data, galUrl, checkResult, su, task, false, transferListener);
    }

    GalleryProperties requestResponse(NVPair[] form_data, byte[] data, URL galUrl, boolean checkResult, StatusUpdate su, GalleryTask task, boolean alreadyRetried, MyTransferListener transferListener) throws ModuleException, IOException {
        String response;
        String urlPath = galUrl.getFile();
        Log.log(3, MODULE, "Connecting to: " + galUrl);
        Log.log(3, MODULE, "Path: " + urlPath);
        if (data != null) {
            su.startProgress(3, 0, 0, GRI18n.getString(MODULE, "upStart"), false);
        }
        HTTPConnection mConnection = new HTTPConnection(galUrl);
        ArrayList<NVPair> nvPairs = new ArrayList<NVPair>();
        nvPairs.add(new NVPair("Connection", "close"));
        String userAgent = this.g.getUserAgent();
        if (userAgent != null) {
            nvPairs.add(new NVPair("User-Agent", userAgent));
        }
        mConnection.setDefaultHeaders(nvPairs.toArray(new NVPair[nvPairs.size()]));
        Log.log(3, MODULE, "Extra headers: " + nvPairs);
        if (this.g.getForceProtocolEncoding() != null) {
            mConnection.setForceCharset(this.g.getForceProtocolEncoding());
        }
        HTTPResponse rsp = data == null ? (form_data == null ? mConnection.Get(urlPath) : mConnection.Post(urlPath, form_data)) : mConnection.Post(urlPath, data, form_data, (TransferListener)transferListener);
        if (rsp.getStatusCode() >= 300 && rsp.getStatusCode() < 400) {
            this.status(su, 3, GRI18n.getString(MODULE, "redirect"));
            rsp = data == null ? (form_data == null ? mConnection.Get(urlPath) : mConnection.Post(urlPath, form_data)) : mConnection.Post(urlPath, data, form_data, (TransferListener)transferListener);
        }
        if (rsp.getStatusCode() >= 300) {
            Object[] params = new Object[]{new Integer(rsp.getStatusCode()), rsp.getReasonLine()};
            throw new GR2Exception(GRI18n.getString(MODULE, "httpPostErr", params));
        }
        Log.log(3, MODULE, "Content-type: " + rsp.getHeader("Content-type"));
        try {
            response = rsp.getText().trim();
        }
        catch (ParseException e) {
            Log.log(1, MODULE, "HTTPClient failed to parse response, getting data instead of text");
            response = new String(rsp.getData()).trim();
        }
        Log.log(3, MODULE, response);
        if (checkResult) {
            int i = response.indexOf("#__GR2PROTO__");
            if (i == -1) {
                if (alreadyRetried) {
                    Object[] params = new Object[]{galUrl.toString()};
                    throw new GR2Exception(GRI18n.getString(MODULE, "gllryNotFound", params));
                }
                Log.log(2, MODULE, "Request failed the first time: trying again...");
                return this.requestResponse(form_data, data, galUrl, checkResult, su, task, true, transferListener);
            }
            if (i > 0) {
                response = response.substring(i);
                Log.log(3, MODULE, "Short response: " + response);
            }
            GalleryProperties p = new GalleryProperties();
            p.load(response);
            if (!(alreadyRetried || this.g.cookieLogin || this.g.getUsername() == null || this.g.getUsername().length() == 0 || p.getProperty("debug_user_already_logged_in") == null || "1".equals(p.getProperty("debug_user_already_logged_in")))) {
                Log.log(2, MODULE, "The session seems to have expired: trying to login and retry...");
                if (task.login()) {
                    return this.requestResponse(form_data, data, galUrl, checkResult, su, task, true, transferListener);
                }
                Log.log(2, MODULE, "Login attempt unsuccessful");
            }
            su.stopProgress(3, GRI18n.getString(MODULE, "addImgOk"));
            this.g.setAuthToken(p.getProperty("auth_token"));
            return p;
        }
        su.stopProgress(3, GRI18n.getString(MODULE, "addImgErr"));
        return null;
    }

    public NVPair[] fudgeFormParameters(NVPair[] form_data) {
        return form_data;
    }

    public NVPair[] fudgeParameters(NVPair[] data) {
        return data;
    }

    void handleCapabilities() {
        if (this.serverMinorVersion >= 15) {
            this.capabilities = capabilities15;
        } else if (this.serverMinorVersion >= 14) {
            this.capabilities = capabilities14;
        } else if (this.serverMinorVersion >= 13) {
            this.capabilities = capabilities13;
        } else if (this.serverMinorVersion >= 9) {
            this.capabilities = capabilities9;
        } else if (this.serverMinorVersion >= 7) {
            this.capabilities = capabilities7;
        } else if (this.serverMinorVersion >= 5) {
            this.capabilities = capabilities5;
        } else if (this.serverMinorVersion >= 2) {
            this.capabilities = capabilities2;
        } else if (this.serverMinorVersion == 1) {
            this.capabilities = capabilities1;
        }
    }

    class MyTransferListener
    implements TransferListener {
        StatusUpdate su;
        DecimalFormat df = new DecimalFormat("##,##0");
        DecimalFormat ff = new DecimalFormat("##,##0.0");
        String currentFile;
        long sizeAllFiles;
        long transferredFilesDone = 0L;
        long transferredThisFile = 0L;
        int numberAllFiles;
        int numberFilesDone = 0;
        long timeStarted = 0L;
        double kbPerSecond = 0.0;

        MyTransferListener(StatusUpdate su) {
            this.su = su;
        }

        public void dataTransferred(int transferredThisFile, int sizeThisFile, double kbPerSecond) {
            this.transferredThisFile = transferredThisFile;
            Object[] params = new Object[]{this.df.format(transferredThisFile / 1024), this.df.format(sizeThisFile / 1024), this.ff.format(kbPerSecond / 1024.0)};
            this.su.updateProgressStatus(3, GRI18n.getString(GalleryComm2.MODULE, "trnsfrStat", params));
            this.su.updateProgressValue(3, transferredThisFile);
            params = new Object[]{this.currentFile, new Integer(this.numberFilesDone + 1), new Integer(this.numberAllFiles), new Integer((int)((this.transferredFilesDone + (long)transferredThisFile) / 1024L / 1024L)), new Integer((int)(this.sizeAllFiles / 1024L / 1024L)), this.getProjectedTimeLeft()};
            this.su.updateProgressStatus(4, GRI18n.getString(GalleryComm2.MODULE, "upStatus", params));
            this.su.updateProgressValue(4, (int)((this.transferredFilesDone + (long)transferredThisFile) * 100L / this.sizeAllFiles));
        }

        public void transferStart(int sizeThisFile) {
            this.transferredThisFile = sizeThisFile;
            if (this.timeStarted == 0L) {
                this.timeStarted = System.currentTimeMillis();
            }
            this.su.updateProgressValue(3, 0, sizeThisFile);
        }

        public void transferEnd(int sizeThisFile) {
            this.transferredFilesDone += (long)sizeThisFile;
            this.transferredThisFile = 0L;
            ++this.numberFilesDone;
            this.su.updateProgressStatus(3, GRI18n.getString(GalleryComm2.MODULE, "upCompSrvrProc"));
            this.su.setUndetermined(3, true);
        }

        public String getProjectedTimeLeft() {
            int secondsLeft = this.getProjectedSecondsLeft();
            if (secondsLeft == -1) {
                return "";
            }
            if (secondsLeft >= 120) {
                Object[] params = new Object[]{new Integer(secondsLeft / 60)};
                return GRI18n.getString(GalleryComm2.MODULE, "minutesLeft", params);
            }
            Object[] params = new Object[]{new Integer(secondsLeft)};
            return GRI18n.getString(GalleryComm2.MODULE, "secondsLeft", params);
        }

        public int getProjectedSecondsLeft() {
            long timeNow = System.currentTimeMillis();
            if (this.timeStarted == 0L || timeNow - this.timeStarted < 500L) {
                return -1;
            }
            double denom = (this.kbPerSecond + (double)((this.transferredFilesDone + this.transferredThisFile) / (timeNow - this.timeStarted) * 1000L)) / 2.0;
            if (denom == 0.0) {
                return -1;
            }
            return (int)((double)(this.sizeAllFiles - this.transferredFilesDone - this.transferredThisFile) / denom);
        }
    }

    class MoveAlbumTask
    extends GalleryTask {
        Album a;
        Album newParent;
        boolean success = false;

        MoveAlbumTask(StatusUpdate su, Album a, Album newParent) {
            super(su);
            this.a = a;
            this.newParent = newParent;
        }

        void runTask() {
            String newParentName;
            String destAlbumName;
            if (this.newParent != null) {
                newParentName = destAlbumName = this.newParent.getName();
            } else {
                newParentName = GRI18n.getString(GalleryComm2.MODULE, "rootAlbum");
                destAlbumName = "0";
            }
            GalleryComm2.this.status(this.su, 0, GRI18n.getString(GalleryComm2.MODULE, "moveAlbum", new String[]{this.a.getName(), newParentName}));
            try {
                NVPair[] form_data = new NVPair[]{new NVPair("cmd", "move-album"), new NVPair("protocol_version", "2.3"), new NVPair("set_albumName", this.a.getName()), new NVPair("set_destalbumName", destAlbumName)};
                Log.log(3, GalleryComm2.MODULE, "move-album parameters: " + Arrays.asList(form_data));
                form_data = GalleryComm2.this.fudgeFormParameters(form_data);
                GalleryProperties p = GalleryComm2.this.requestResponse(form_data, this.su, this);
                if (p.getProperty("status").equals("0")) {
                    GalleryComm2.this.status(this.su, 0, GRI18n.getString(GalleryComm2.MODULE, "moveAlbumDone"));
                    this.success = true;
                } else {
                    GalleryComm2.this.error(this.su, "Error: " + p.getProperty("status_text"));
                }
            }
            catch (GR2Exception gr2e) {
                Log.logException(1, GalleryComm2.MODULE, gr2e);
                Object[] params2 = new Object[]{gr2e.getMessage()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
            catch (IOException ioe) {
                Log.logException(1, GalleryComm2.MODULE, ioe);
                Object[] params2 = new Object[]{ioe.toString()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
            catch (ModuleException me) {
                Log.logException(1, GalleryComm2.MODULE, me);
                Object[] params2 = new Object[]{me.toString()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
        }

        public boolean getSuccess() {
            return this.success;
        }
    }

    class FetchAlbumImagesTask
    extends GalleryTask {
        Album a;
        boolean recursive = false;
        int maxPictures = 0;
        boolean random = false;

        FetchAlbumImagesTask(StatusUpdate su, Album a, boolean recursive, int maxPictures, boolean random) {
            super(su);
            this.a = a;
            this.recursive = recursive;
            this.maxPictures = maxPictures;
            this.random = random;
        }

        void runTask() {
            this.su.startProgress(0, 0, 10, GRI18n.getString(GalleryComm2.MODULE, "fetchAlbImages", new String[]{this.a.getName()}), true);
            try {
                ArrayList newPictures = new ArrayList();
                this.fetch(this.a, this.a.getName(), newPictures);
                this.a.setHasFetchedImages(true);
                this.a.addPictures(newPictures);
                GalleryRemote._().getCore().preloadThumbnails(newPictures.iterator());
                this.su.stopProgress(0, GRI18n.getString(GalleryComm2.MODULE, "fetchAlbImagesDone", new String[]{"" + newPictures.size()}));
            }
            catch (GR2Exception e) {
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", new String[]{e.getMessage()}));
                this.su.stopProgress(0, e.getMessage());
            }
        }

        private void fetch(Album a, String albumName, ArrayList newPictures) throws GR2Exception {
            block19: {
                this.su.updateProgressStatus(0, GRI18n.getString(GalleryComm2.MODULE, "fetchAlbImages", new String[]{albumName}));
                try {
                    NVPair[] form_data = new NVPair[]{new NVPair("cmd", "fetch-album-images"), new NVPair("protocol_version", "2.3"), new NVPair("set_albumName", albumName), new NVPair("albums_too", this.recursive ? "yes" : "no"), new NVPair("random", this.random ? "yes" : "no"), new NVPair("limit", this.maxPictures + ""), new NVPair("extrafields", "yes")};
                    Log.log(3, GalleryComm2.MODULE, "fetch-album-images parameters: " + Arrays.asList(form_data));
                    form_data = GalleryComm2.this.fudgeFormParameters(form_data);
                    GalleryProperties p = GalleryComm2.this.requestResponse(form_data, this.su, this);
                    if (p.getProperty("status").equals("0")) {
                        String extraFieldsString;
                        int numImages = p.getIntProperty("image_count");
                        String baseUrl = p.getProperty("baseurl");
                        try {
                            if (baseUrl == null) {
                                Log.log(3, GalleryComm2.MODULE, "Gallery root, baseurl is null");
                            } else {
                                new URL(baseUrl);
                            }
                        }
                        catch (MalformedURLException e) {
                            Log.log(3, GalleryComm2.MODULE, "baseurl is relative, tacking on Gallery URL (only works for standalone)");
                            URL tmpUrl = new URL(GalleryComm2.this.g.getStUrlString());
                            baseUrl = new URL(tmpUrl.getProtocol(), tmpUrl.getHost(), tmpUrl.getPort(), baseUrl).toString();
                        }
                        String caption = p.getProperty("album.caption");
                        if (caption != null) {
                            a.setCaption(caption);
                        }
                        if ((extraFieldsString = p.getProperty("album.extrafields")) != null) {
                            a.setExtraFieldsString(extraFieldsString);
                        }
                        ArrayList extraFields = a.getExtraFields();
                        for (int i = 1; i <= numImages; ++i) {
                            String resizedName;
                            String forceExtension;
                            int height;
                            int width;
                            if (this.maxPictures > 0 && newPictures.size() >= this.maxPictures) {
                                Log.log(3, GalleryComm2.MODULE, "Fetched maximum of " + this.maxPictures + " pictures: stopping.");
                                break block19;
                            }
                            String subAlbumName = p.getProperty("album.name." + i);
                            boolean subAlbumHidden = p.getBooleanProperty("album.hidden." + i, false);
                            if (subAlbumName != null) {
                                if (subAlbumHidden) continue;
                                this.fetch(a, subAlbumName, newPictures);
                                continue;
                            }
                            Picture picture = new Picture(GalleryComm2.this.g);
                            picture.setOnline(true);
                            String rawName = p.getProperty("image.name." + i);
                            if (rawName != null) {
                                picture.setUrlFull(new URL(baseUrl + rawName));
                                width = p.getIntProperty("image.raw_width." + i, 0);
                                height = p.getIntProperty("image.raw_height." + i, 0);
                                picture.setSizeFull(new Dimension(width, height));
                                picture.setFileSize(p.getIntProperty("image.raw_filesize." + i));
                                picture.setUniqueId(a.getName() + '_' + rawName);
                                picture.setItemId(rawName);
                            }
                            if ((forceExtension = p.getProperty("image.forceExtension." + i)) != null) {
                                picture.setForceExtension(forceExtension);
                            }
                            if ((resizedName = p.getProperty("image.resizedName." + i)) != null) {
                                picture.setUrlResized(new URL(baseUrl + resizedName));
                                width = p.getIntProperty("image.resized_width." + i);
                                height = p.getIntProperty("image.resized_height." + i);
                                picture.setSizeResized(new Dimension(width, height));
                            }
                            picture.setUrlThumbnail(new URL(baseUrl + p.getProperty("image.thumbName." + i)));
                            width = p.getIntProperty("image.thumb_width." + i);
                            height = p.getIntProperty("image.thumb_height." + i);
                            picture.setSizeThumbnail(new Dimension(width, height));
                            picture.setCaption(p.getProperty("image.caption." + i));
                            String title = p.getProperty("image.title." + i);
                            if (title != null) {
                                picture.setName(title);
                            }
                            if (extraFields != null) {
                                Iterator it = extraFields.iterator();
                                while (it.hasNext()) {
                                    String name = (String)it.next();
                                    String value = p.getProperty("image.extrafield." + name + "." + i);
                                    if (value == null) continue;
                                    picture.setExtraField(name, value);
                                }
                            }
                            picture.setHidden(p.getBooleanProperty("image.hidden." + i, false));
                            picture.setAlbumOnServer(a);
                            picture.setIndexOnServer(i - 1);
                            if (picture.isHidden() || rawName == null && resizedName == null) continue;
                            newPictures.add(picture);
                        }
                        break block19;
                    }
                    throw new GR2Exception(p.getProperty("error"));
                }
                catch (IOException ioe) {
                    Log.logException(1, GalleryComm2.MODULE, ioe);
                    Object[] params2 = new Object[]{ioe.toString()};
                    GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
                }
                catch (ModuleException me) {
                    Log.logException(1, GalleryComm2.MODULE, me);
                    Object[] params2 = new Object[]{me.toString()};
                    GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
                }
            }
        }
    }

    class NewAlbumTask
    extends GalleryTask {
        Album parentAlbum;
        String albumName;
        String albumTitle;
        String albumDesc;
        private String newAlbumName;

        NewAlbumTask(StatusUpdate su, Album parentAlbum, String albumName, String albumTitle, String albumDesc) {
            super(su);
            this.parentAlbum = parentAlbum;
            this.albumName = albumName;
            this.albumTitle = albumTitle;
            this.albumDesc = albumDesc;
        }

        void runTask() {
            String parentAlbumName;
            boolean utf8;
            GalleryComm2.this.status(this.su, 0, GRI18n.getString(GalleryComm2.MODULE, "newAlbm", new Object[]{this.albumName, GalleryComm2.this.g.toString()}));
            boolean escapeCaptions = GalleryRemote._().properties.getBooleanProperty("htmlEscapeCaptions");
            boolean bl = utf8 = !escapeCaptions && this.parentAlbum.getGallery().getGalleryVersion() == 2;
            if (utf8) {
                Log.log(2, GalleryComm2.MODULE, "Will upload using UTF-8 for text data");
            }
            String string = parentAlbumName = this.parentAlbum == null ? "hack_null_albumName" : this.parentAlbum.getName();
            if (escapeCaptions) {
                this.albumTitle = HTMLEscaper.escape(this.albumTitle);
                this.albumDesc = HTMLEscaper.escape(this.albumDesc);
            }
            try {
                GalleryProperties p;
                NVPair[] form_data = new NVPair[]{new NVPair("cmd", "new-album"), new NVPair("protocol_version", "2.3"), new NVPair("set_albumName", parentAlbumName), new NVPair("newAlbumName", this.albumName), new NVPair("newAlbumTitle", this.albumTitle, utf8 ? "UTF-8" : null), new NVPair("newAlbumDesc", this.albumDesc, utf8 ? "UTF-8" : null)};
                form_data = GalleryComm2.this.fudgeFormParameters(form_data);
                Log.log(3, GalleryComm2.MODULE, "new-album parameters: " + Arrays.asList(form_data));
                if (utf8) {
                    NVPair[] hdrs = new NVPair[1];
                    byte[] data = Codecs.mpFormDataEncode(form_data, new NVPair[0], hdrs);
                    p = GalleryComm2.this.requestResponse(hdrs, data, GalleryComm2.this.g.getGalleryUrl(GalleryComm2.this.scriptName), true, this.su, this, null);
                } else {
                    p = GalleryComm2.this.requestResponse(form_data, this.su, this);
                }
                if (((Properties)p).getProperty("status").equals("0")) {
                    GalleryComm2.this.status(this.su, 0, GRI18n.getString(GalleryComm2.MODULE, "crateAlbmOk"));
                    this.newAlbumName = ((Properties)p).getProperty("album_name");
                } else {
                    Object[] params2 = new Object[]{((Properties)p).getProperty("status_text")};
                    GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
                }
            }
            catch (GR2Exception gr2e) {
                Log.logException(1, GalleryComm2.MODULE, gr2e);
                Object[] params2 = new Object[]{gr2e.getMessage()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
            catch (IOException ioe) {
                Log.logException(1, GalleryComm2.MODULE, ioe);
                Object[] params2 = new Object[]{ioe.toString()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
            catch (ModuleException me) {
                Log.logException(1, GalleryComm2.MODULE, me);
                Object[] params2 = new Object[]{me.toString()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
        }

        public String getNewAlbumName() {
            return this.newAlbumName;
        }
    }

    class AlbumPropertiesTask
    extends GalleryTask {
        Album a;

        AlbumPropertiesTask(StatusUpdate su, Album a) {
            super(su);
            this.a = a;
        }

        void runTask() {
            GalleryComm2.this.status(this.su, 0, GRI18n.getString(GalleryComm2.MODULE, "getAlbmInfo", new String[]{this.a.toString()}));
            try {
                NVPair[] form_data = new NVPair[]{new NVPair("cmd", "album-properties"), new NVPair("protocol_version", "2.3"), new NVPair("set_albumName", this.a.getName())};
                Log.log(3, GalleryComm2.MODULE, "album-info parameters: " + Arrays.asList(form_data));
                form_data = GalleryComm2.this.fudgeFormParameters(form_data);
                GalleryProperties p = GalleryComm2.this.requestResponse(form_data, this.su, this);
                if (p.getProperty("status").equals("0")) {
                    int maxSize;
                    int autoResize = p.getIntProperty("auto_resize");
                    this.a.setServerAutoResize(autoResize > (maxSize = p.getIntProperty("max_size", 0)) ? autoResize : maxSize);
                    String extrafields = p.getProperty("extrafields");
                    this.a.setExtraFieldsString(extrafields);
                    GalleryComm2.this.status(this.su, 0, GRI18n.getString(GalleryComm2.MODULE, "ftchdAlbmProp"));
                } else {
                    GalleryComm2.this.error(this.su, "Error: " + p.getProperty("status_text"));
                }
            }
            catch (GR2Exception gr2e) {
                Log.logException(1, GalleryComm2.MODULE, gr2e);
                Object[] params2 = new Object[]{gr2e.getMessage()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
            catch (IOException ioe) {
                Log.logException(1, GalleryComm2.MODULE, ioe);
                Object[] params2 = new Object[]{ioe.toString()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
            catch (ModuleException me) {
                Log.logException(1, GalleryComm2.MODULE, me);
                Object[] params2 = new Object[]{me.toString()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
        }
    }

    class AlbumListTask
    extends GalleryTask {
        AlbumListTask(StatusUpdate su) {
            super(su);
        }

        void runTask() {
            this.su.startProgress(1, 0, 10, GRI18n.getString(GalleryComm2.MODULE, "albmFtchng", new Object[]{GalleryComm2.this.g.toString()}), true);
            try {
                long startTime = System.currentTimeMillis();
                if (GalleryComm2.this.serverMinorVersion < 2) {
                    this.list20();
                } else {
                    this.list22();
                }
                GalleryComm2.this.g.reload();
                Log.log(2, GalleryComm2.MODULE, "execution time for AlbumList: " + (System.currentTimeMillis() - startTime));
            }
            catch (GR2Exception gr2e) {
                Log.logException(1, GalleryComm2.MODULE, gr2e);
                Object[] params2 = new Object[]{gr2e.getMessage()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
            catch (IOException ioe) {
                Log.logException(1, GalleryComm2.MODULE, ioe);
                Object[] params2 = new Object[]{ioe.toString()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
            catch (ModuleException me) {
                Log.logException(1, GalleryComm2.MODULE, me);
                Object[] params2 = new Object[]{me.toString()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
            this.su.stopProgress(1, GRI18n.getString(GalleryComm2.MODULE, "fetchComplete"));
        }

        private void list20() throws IOException, ModuleException {
            NVPair[] form_data = new NVPair[]{new NVPair("cmd", "fetch-albums"), new NVPair("protocol_version", "2.3")};
            Log.log(3, GalleryComm2.MODULE, "fetchAlbums parameters: " + Arrays.asList(form_data));
            form_data = GalleryComm2.this.fudgeFormParameters(form_data);
            GalleryProperties p = GalleryComm2.this.requestResponse(form_data, this.su, this);
            if (((Properties)p).getProperty("status").equals("0")) {
                int i;
                ArrayList<Album> mAlbumList = new ArrayList<Album>();
                int albumCount = Integer.parseInt(((Properties)p).getProperty("album_count"));
                HashMap<String, String> ref2parKey = new HashMap<String, String>();
                HashMap<String, Album> ref2album = new HashMap<String, Album>();
                Album rootAlbum = GalleryComm2.this.g.createRootAlbum();
                for (i = 1; i < albumCount + 1; ++i) {
                    Album a = new Album(GalleryComm2.this.g);
                    a.setSuppressEvents(true);
                    String nameKey = "album.name." + i;
                    String titleKey = "album.title." + i;
                    String parentKey = "album.parent." + i;
                    String permsAddKey = "album.perms.add." + i;
                    String permsWriteKey = "album.perms.write." + i;
                    String permsDelItemKey = "album.perms.del_item." + i;
                    String permsDelAlbKey = "album.perms.del_alb." + i;
                    String permsCreateSubKey = "album.perms.create_sub." + i;
                    String infoExtraFieldsKey = "album.info.extrafields." + i;
                    a.setCanAdd(GalleryComm2.this.isTrue(((Properties)p).getProperty(permsAddKey)));
                    a.setCanWrite(GalleryComm2.this.isTrue(((Properties)p).getProperty(permsWriteKey)));
                    a.setCanDeleteFrom(GalleryComm2.this.isTrue(((Properties)p).getProperty(permsDelItemKey)));
                    a.setCanDeleteThisAlbum(GalleryComm2.this.isTrue(((Properties)p).getProperty(permsDelAlbKey)));
                    a.setCanCreateSubAlbum(GalleryComm2.this.isTrue(((Properties)p).getProperty(permsCreateSubKey)));
                    a.setExtraFieldsString(HTMLEscaper.unescape(((Properties)p).getProperty(infoExtraFieldsKey)));
                    a.setName(((Properties)p).getProperty(nameKey));
                    a.setTitle(HTMLEscaper.unescape(((Properties)p).getProperty(titleKey)));
                    a.setSuppressEvents(false);
                    mAlbumList.add(a);
                    ref2album.put("" + i, a);
                    String parentRefS = ((Properties)p).getProperty(parentKey);
                    int parentRef = Integer.parseInt(parentRefS);
                    if (parentRef != 0) {
                        ref2parKey.put("" + i, parentRefS);
                        continue;
                    }
                    rootAlbum.add(a);
                }
                for (i = 1; i < albumCount + 1; ++i) {
                    Album a;
                    String parentKey = (String)ref2parKey.get("" + i);
                    if (parentKey == null || (a = (Album)ref2album.get("" + i)) == null) continue;
                    Album pa = (Album)ref2album.get(parentKey);
                    pa.add(a);
                }
                GalleryComm2.this.status(this.su, 1, GRI18n.getString(GalleryComm2.MODULE, "ftchdAlbms"));
            } else {
                Object[] params = new Object[]{((Properties)p).getProperty("status_text")};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params));
            }
        }

        private void list22() throws IOException, ModuleException {
            NVPair[] form_data = new NVPair[]{new NVPair("cmd", "fetch-albums-prune"), new NVPair("protocol_version", "2.3")};
            Log.log(3, GalleryComm2.MODULE, "fetchAlbums parameters: " + Arrays.asList(form_data));
            form_data = GalleryComm2.this.fudgeFormParameters(form_data);
            GalleryProperties p = GalleryComm2.this.requestResponse(form_data, this.su, this);
            if (p.getProperty("status").equals("0")) {
                ArrayList<Album> albums = new ArrayList<Album>();
                int albumCount = Integer.parseInt(p.getProperty("album_count"));
                HashMap<String, String> name2parentName = new HashMap<String, String>();
                HashMap<String, Album> name2album = new HashMap<String, Album>();
                Album rootAlbum = GalleryComm2.this.g.createRootAlbum();
                for (int i = 1; i < albumCount + 1; ++i) {
                    Album a = new Album(GalleryComm2.this.g);
                    a.setSuppressEvents(true);
                    String nameKey = "album.name." + i;
                    String titleKey = "album.title." + i;
                    String parentKey = "album.parent." + i;
                    String permsAddKey = "album.perms.add." + i;
                    String permsWriteKey = "album.perms.write." + i;
                    String permsDelItemKey = "album.perms.del_item." + i;
                    String permsDelAlbKey = "album.perms.del_alb." + i;
                    String permsCreateSubKey = "album.perms.create_sub." + i;
                    String infoExtraFieldKey = "album.info.extrafields." + i;
                    a.setCanAdd(GalleryComm2.this.isTrue(p.getProperty(permsAddKey)));
                    a.setCanWrite(GalleryComm2.this.isTrue(p.getProperty(permsWriteKey)));
                    a.setCanDeleteFrom(GalleryComm2.this.isTrue(p.getProperty(permsDelItemKey)));
                    a.setCanDeleteThisAlbum(GalleryComm2.this.isTrue(p.getProperty(permsDelAlbKey)));
                    a.setCanCreateSubAlbum(GalleryComm2.this.isTrue(p.getProperty(permsCreateSubKey)));
                    String name = p.getProperty(nameKey);
                    a.setName(name);
                    a.setTitle(HTMLEscaper.unescape(p.getProperty(titleKey)));
                    a.setExtraFieldsString(HTMLEscaper.unescape(p.getProperty(infoExtraFieldKey)));
                    a.setSuppressEvents(false);
                    albums.add(a);
                    name2album.put(name, a);
                    String parentName = p.getProperty(parentKey);
                    if (parentName == null) {
                        Log.log(1, GalleryComm2.MODULE, "Gallery error: the album " + name + " doesn't have a parent. You should delete it, the album database " + "is corrupted because of it.");
                    } else if (parentName.equals(name)) {
                        Log.log(1, GalleryComm2.MODULE, "Gallery error: the album " + name + " is its own parent. You should delete it, the album database " + "is corrupted because of it.");
                        parentName = null;
                    }
                    if (parentName != null && parentName.length() > 0 && !parentName.equals("0")) {
                        name2parentName.put(name, parentName);
                        continue;
                    }
                    rootAlbum.add(a);
                }
                Log.log(3, GalleryComm2.MODULE, "Created " + albums.size() + " albums");
                Iterator<Object> it = name2parentName.keySet().iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    String parentName = (String)name2parentName.get(name);
                    Album child = (Album)name2album.get(name);
                    Album parent = (Album)name2album.get(parentName);
                    if (child == null || parent == null) continue;
                    parent.add(child);
                }
                Log.log(3, GalleryComm2.MODULE, "Linked " + name2parentName.size() + " albums to their parents");
                Collections.sort(albums, new NaturalOrderComparator());
                Collections.reverse(albums);
                ArrayList<Album> orderedAlbums = new ArrayList<Album>();
                int depth = 0;
                while (!albums.isEmpty()) {
                    it = albums.iterator();
                    while (it.hasNext()) {
                        Album a = (Album)it.next();
                        try {
                            if (a.getAlbumDepth() != depth) continue;
                            it.remove();
                            a.sortSubAlbums();
                            Album parentAlbum = a.getParentAlbum();
                            if (parentAlbum == null) {
                                orderedAlbums.add(0, a);
                                continue;
                            }
                            int i = orderedAlbums.indexOf(parentAlbum);
                            orderedAlbums.add(i + 1, a);
                        }
                        catch (IllegalArgumentException e) {
                            UrlMessageDialog md;
                            it.remove();
                            Log.log(3, GalleryComm2.MODULE, "Gallery server album list is corrupted: album " + a.getName() + " has a bad containment hierarchy.");
                            if (GalleryRemote._().properties.getBooleanProperty("suppressWarningCorrupted") || !(md = new UrlMessageDialog(GRI18n.getString(GalleryComm2.MODULE, "fixCorrupted", new String[]{a.getTitle(), a.getGallery().getGalleryUrl(a.getName()).toString()}), a.getGallery().getGalleryUrl(GRI18n.getString(GalleryComm2.MODULE, "fixCorruptedUrl", new String[]{a.getName()})).toString(), null)).dontShow()) continue;
                            GalleryRemote._().properties.setBooleanProperty("suppressWarningCorrupted", true);
                        }
                    }
                    ++depth;
                }
                rootAlbum.setCanCreateSubAlbum(p.getBooleanProperty("can_create_root", false));
                Log.log(3, GalleryComm2.MODULE, "Ordered " + orderedAlbums.size() + " albums");
                GalleryComm2.this.status(this.su, 1, GRI18n.getString(GalleryComm2.MODULE, "ftchdAlbms"));
            } else {
                Object[] params = new Object[]{p.getProperty("status_text")};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params));
            }
        }
    }

    class UploadTask
    extends GalleryTask {
        MyTransferListener transferListener;

        UploadTask(StatusUpdate su) {
            super(su);
        }

        void runTask() {
            ArrayList pictures = GalleryComm2.this.g.getAllUploadablePictures();
            long totalSize = 0L;
            Iterator iter = pictures.iterator();
            while (iter.hasNext()) {
                Picture p = (Picture)iter.next();
                totalSize = (long)((double)totalSize + p.getFileSize());
            }
            this.transferListener = new MyTransferListener(this.su);
            this.transferListener.sizeAllFiles = totalSize;
            this.transferListener.numberAllFiles = pictures.size();
            this.su.startProgress(4, 0, 100, GRI18n.getString(GalleryComm2.MODULE, "upPic"), false);
            if (this.su instanceof UploadProgress) {
                ((UploadProgress)this.su).setCancelListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        UploadTask.this.su.updateProgressStatus(4, GRI18n.getString(GalleryComm2.MODULE, "upStop"));
                        UploadTask.this.su.setUndetermined(4, true);
                        UploadTask.this.interrupt();
                        long startTime = System.currentTimeMillis();
                        while (!UploadTask.this.terminated && System.currentTimeMillis() < startTime + 10000L) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e1) {}
                        }
                        if (!UploadTask.this.terminated) {
                            Log.log(1, "Thread would not terminate properly: killing it");
                            UploadTask.this.thread.stop();
                            UploadTask.this.cleanUp();
                        }
                        ((UploadProgress)UploadTask.this.su).done();
                    }
                });
            }
            boolean allGood = true;
            iter = pictures.iterator();
            while (iter.hasNext() && !this.interrupt) {
                Picture p = (Picture)iter.next();
                allGood = this.uploadPicture(p, p);
                if (!allGood) continue;
                p.getParentAlbum().removePicture(p);
            }
            if (allGood) {
                this.su.stopProgress(4, GRI18n.getString(GalleryComm2.MODULE, "upComplete"));
                if (this.su instanceof UploadProgress && ((UploadProgress)this.su).isShutdown()) {
                    GalleryRemote._().getCore().shutdown(true);
                }
                GalleryComm2.this.g.setDirty(false);
                GalleryRemote._().getCore().flushMemory();
            } else {
                this.su.stopProgress(4, GRI18n.getString(GalleryComm2.MODULE, "upFailed"));
            }
        }

        boolean uploadPicture(Picture p, Picture picture) {
            try {
                boolean utf8 = p.getParentAlbum().getGallery().getGalleryVersion() == 2;
                boolean escapeCaptions = !utf8 && GalleryRemote._().properties.getBooleanProperty("htmlEscapeCaptions");
                this.transferListener.currentFile = p.toString();
                if (utf8) {
                    Log.log(2, GalleryComm2.MODULE, "Will upload using UTF-8 for text data");
                }
                GalleryComm2.this.status(this.su, 3, GRI18n.getString(GalleryComm2.MODULE, "upPrep"));
                String caption = p.getCaption();
                String string = caption = caption == null ? "" : caption;
                if (escapeCaptions) {
                    caption = HTMLEscaper.escape(caption);
                }
                NVPair[] opts = new NVPair[]{new NVPair("cmd", "add-item"), new NVPair("protocol_version", "2.3"), new NVPair("set_albumName", p.getParentAlbum().getName()), new NVPair("caption", caption, utf8 ? "UTF-8" : null), new NVPair("force_filename", p.getSource().getName()), null};
                if (p.getAngle() != 0) {
                    opts[5] = new NVPair("auto_rotate", "no");
                }
                if (p.getExtraFieldsMap() != null && p.getExtraFieldsMap().size() > 0) {
                    ArrayList<NVPair> optsList = new ArrayList<NVPair>(Arrays.asList(opts));
                    Iterator it = p.getExtraFieldsMap().keySet().iterator();
                    while (it.hasNext()) {
                        String name = (String)it.next();
                        String value = p.getExtraField(name);
                        if (value == null) continue;
                        if (escapeCaptions) {
                            value = HTMLEscaper.escape(value);
                        }
                        optsList.add(new NVPair("extrafield." + name, value, utf8 ? "UTF-8" : null));
                    }
                    opts = optsList.toArray(opts);
                }
                Log.log(3, GalleryComm2.MODULE, "add-item parameters: " + Arrays.asList(opts));
                NVPair[] afile = new NVPair[]{new NVPair("userfile", p.getUploadSource().getAbsolutePath())};
                NVPair[] hdrs = new NVPair[1];
                byte[] data = Codecs.mpFormDataEncode(GalleryComm2.this.fudgeFormParameters(opts), GalleryComm2.this.fudgeParameters(afile), hdrs);
                GalleryProperties props = GalleryComm2.this.requestResponse(hdrs, data, GalleryComm2.this.g.getGalleryUrl(GalleryComm2.this.scriptName), true, this.su, this, this.transferListener);
                if (((Properties)props).getProperty("status").equals("0")) {
                    GalleryComm2.this.status(this.su, 3, GRI18n.getString(GalleryComm2.MODULE, "upSucc"));
                    String newItemName = ((Properties)props).getProperty("item_name");
                    if (newItemName != null) {
                        this.su.doneUploading(newItemName, picture);
                    }
                    return true;
                }
                Object[] params = new Object[]{((Properties)props).getProperty("status_text")};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "upErr", params));
                return false;
            }
            catch (GR2Exception gr2e) {
                Log.logException(1, GalleryComm2.MODULE, gr2e);
                Object[] params = new Object[]{gr2e.getMessage()};
                GalleryComm2.this.error(this.su, p.toString() + ": " + GRI18n.getString(GalleryComm2.MODULE, "error", params));
            }
            catch (SocketException swe) {
                Log.logException(1, GalleryComm2.MODULE, swe);
                Object[] params = new Object[]{swe.toString()};
                GalleryComm2.this.error(this.su, p.toString() + ": " + GRI18n.getString(GalleryComm2.MODULE, "confErr", params));
            }
            catch (IOException ioe) {
                Log.logException(1, GalleryComm2.MODULE, ioe);
                Object[] params = new Object[]{ioe.toString()};
                GalleryComm2.this.error(this.su, p.toString() + ": " + GRI18n.getString(GalleryComm2.MODULE, "error", params));
            }
            catch (ModuleException me) {
                Log.logException(1, GalleryComm2.MODULE, me);
                Object[] params = new Object[]{me.getMessage()};
                GalleryComm2.this.error(this.su, p.toString() + ": " + GRI18n.getString(GalleryComm2.MODULE, "errReq", params));
            }
            return false;
        }
    }

    class LoginTask
    extends GalleryTask {
        LoginTask(StatusUpdate su) {
            super(su);
        }

        void runTask() {
        }
    }

    abstract class GalleryTask
    implements Runnable {
        StatusUpdate su;
        HTTPConnection mConnection;
        boolean interrupt = false;
        boolean terminated = false;
        Thread thread = null;

        public GalleryTask(StatusUpdate su) {
            this.su = su == null ? new StatusUpdateAdapter(){} : su;
        }

        public void run() {
            this.thread = Thread.currentThread();
            this.su.setInProgress(true);
            if (!GalleryComm2.this.isLoggedIn) {
                if (!this.login()) {
                    Log.log(3, GalleryComm2.MODULE, "Failed to log in to " + GalleryComm2.this.g.toString());
                    this.su.setInProgress(false);
                    return;
                }
                GalleryComm2.this.isLoggedIn = true;
            } else {
                Log.log(3, GalleryComm2.MODULE, "Still logged in to " + GalleryComm2.this.g.toString());
            }
            this.runTask();
            this.cleanUp();
        }

        public void interrupt() {
            this.thread.interrupt();
            this.interrupt = true;
        }

        public void cleanUp() {
            this.su.setInProgress(false);
            this.terminated = true;
        }

        abstract void runTask();

        private boolean login() {
            Object[] params = new Object[]{GalleryComm2.this.g.toString()};
            GalleryComm2.this.status(this.su, 0, GRI18n.getString(GalleryComm2.MODULE, "logIn", params));
            if (GalleryComm2.this.g.getType() != 0 && GalleryComm2.this.g.getType() != 99) {
                Object[] params2;
                try {
                    GalleryComm2.this.requestResponse(null, null, GalleryComm2.this.g.getLoginUrl(GalleryComm2.this.scriptName), false, this.su, this, null);
                }
                catch (IOException ioe) {
                    Log.logException(1, GalleryComm2.MODULE, ioe);
                    params2 = new Object[]{ioe.toString()};
                    GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
                }
                catch (ModuleException me) {
                    Log.logException(1, GalleryComm2.MODULE, me);
                    params2 = new Object[]{me.getMessage()};
                    GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "errReq", params2));
                }
            }
            String username = GalleryComm2.this.g.getUsername();
            String password = GalleryComm2.this.g.getPassword();
            if (!(username != null && username.length() != 0 || GalleryComm2.this.g.cookieLogin || (username = (String)JOptionPane.showInputDialog(GalleryRemote._().getMainFrame(), GRI18n.getString(GalleryComm2.MODULE, "usernameLbl"), GRI18n.getString(GalleryComm2.MODULE, "username"), -1, null, null, null)) == null)) {
                GalleryComm2.this.g.setUsername(username);
            }
            if (username != null && (password == null || password.length() == 0)) {
                password = (String)JOptionPane.showInputDialog(GalleryRemote._().getMainFrame(), GRI18n.getString(GalleryComm2.MODULE, "passwdLbl"), GRI18n.getString(GalleryComm2.MODULE, "passwd"), -1, null, null, null);
                GalleryComm2.this.g.setPassword(password);
            }
            NVPair[] form_data = new NVPair[]{new NVPair("cmd", "login"), new NVPair("protocol_version", "2.3"), null, null};
            if (username != null) {
                form_data[2] = new NVPair("uname", username);
                Log.log(3, GalleryComm2.MODULE, "login parameters: " + Arrays.asList(form_data));
                form_data[3] = new NVPair("password", password);
            } else {
                Log.log(3, GalleryComm2.MODULE, "login parameters: " + Arrays.asList(form_data));
            }
            form_data = GalleryComm2.this.fudgeFormParameters(form_data);
            try {
                GalleryComm2.this.triedLogin = true;
                GalleryProperties p = GalleryComm2.this.requestResponse(form_data, null, GalleryComm2.this.g.getGalleryUrl(GalleryComm2.this.scriptName), true, this.su, this, true, null);
                if ("0".equals(((Properties)p).getProperty("status")) || "202".equals(((Properties)p).getProperty("status"))) {
                    GalleryComm2.this.status(this.su, 0, GRI18n.getString(GalleryComm2.MODULE, "loggedIn"));
                    try {
                        String serverVersion = ((Properties)p).getProperty("server_version");
                        int i = serverVersion.indexOf(".");
                        GalleryComm2.this.serverMinorVersion = Integer.parseInt(serverVersion.substring(i + 1));
                        Log.log(3, GalleryComm2.MODULE, "Server minor version: " + GalleryComm2.this.serverMinorVersion);
                        GalleryComm2.this.handleCapabilities();
                    }
                    catch (Exception e) {
                        Log.log(1, GalleryComm2.MODULE, "Malformed server_version: " + ((Properties)p).getProperty("server_version"));
                        Log.logException(1, GalleryComm2.MODULE, e);
                    }
                    return true;
                }
                if ("201".equals(((Properties)p).getProperty("status"))) {
                    GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "usrpwdErr"));
                    return false;
                }
                Object[] params2 = new Object[]{((Properties)p).getProperty("status_text")};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "loginErr", params2));
                return false;
            }
            catch (GR2Exception gr2e) {
                Log.logException(1, GalleryComm2.MODULE, gr2e);
                Object[] params2 = new Object[]{gr2e.getMessage()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
            catch (IOException ioe) {
                Log.logException(1, GalleryComm2.MODULE, ioe);
                Object[] params2 = new Object[]{ioe.toString()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "error", params2));
            }
            catch (ModuleException me) {
                Log.logException(1, GalleryComm2.MODULE, me);
                Object[] params2 = new Object[]{me.getMessage()};
                GalleryComm2.this.error(this.su, GRI18n.getString(GalleryComm2.MODULE, "errReq", params2));
            }
            return false;
        }
    }
}

