#!/bin/sh

test -d translations || cd ..

intltool-merge -d translations galternatives.desktop.in galternatives.desktop

for desc in descriptions/*.in; do
    intltool-merge -d translations ${desc} ${desc/.in/}
done

cd translations

LANGS=$(find . -name galternatives.po | cut -d '/' -f 2)
for lang in ${LANGS}; do
    msgfmt --statistics -o ${lang}/galternatives.mo ${lang}/galternatives.po
done
