/***************************************************************************

  common.c

  common useful routines

  Datatype management routines. Conversions between each Gambas datatype,
  and conversions between Gambas datatypes and native datatypes.

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __COMMON_BUFFER_C

#include <ctype.h>
#include "gb_common.h"

PUBLIC char COMMON_buffer[256];
PUBLIC long COMMON_pos;

PRIVATE char *common_buffer;
PRIVATE long common_len;
PRIVATE int common_last;

PUBLIC char COMMON_tolower[256];
PUBLIC char COMMON_toupper[256];


PUBLIC void COMMON_init(void)
{
  int i;
  
  for (i = 0; i < 256; i++)
  {
    COMMON_tolower[i] = tolower(i);
    COMMON_toupper[i] = toupper(i);
  }
}


PUBLIC int COMMON_strcasecmp(const char *s1, const char *s2)
{
  register unsigned int i;
  register int d;
  register char c;
  
  for (i = 0;; i++)
  {
    c = COMMON_tolower[(unsigned char)s1[i]];
    d = c - COMMON_tolower[(unsigned char)s2[i]];
    if (d < 0)
      return -1;
    else if (d > 0)
      return 1;
    else if (c == 0)
      return 0;
  }
}

PUBLIC int COMMON_strncasecmp(const char *s1, const char *s2, size_t n)
{
  register unsigned int i;
  register int d;
  register char c;
  
  for (i = 0; i < n; i++)
  {
    c = COMMON_tolower[(unsigned char)s1[i]];
    d = c - COMMON_tolower[(unsigned char)s2[i]];
    if (d < 0)
      return -1;
    else if (d > 0)
      return 1;
  }
  
  return 0;
}


PUBLIC void COMMON_buffer_init(char *str, long len)
{
  common_buffer = str;
  common_len = len;
  COMMON_pos = 0;
  common_last = (-1);
}


PUBLIC int COMMON_look_char(void)
{
  if (COMMON_pos >= common_len)
    return (-1);

  return (unsigned char)(common_buffer[COMMON_pos]);
}


PUBLIC int COMMON_get_char(void)
{
  if (COMMON_pos >= common_len)
    common_last = (-1);
  else
    common_last = (unsigned char)(common_buffer[COMMON_pos++]);

  return common_last;
}


PUBLIC int COMMON_last_char(void)
{
  return common_last;
}


PUBLIC int COMMON_put_char(char c)
{
  if (COMMON_pos >= common_len)
    return (-1);

  common_buffer[COMMON_pos++] = c;
  return 0;
}


PUBLIC void COMMON_jump_space(void)
{
  int c;

  for(;;)
  {
    c = COMMON_look_char();
    if (c <= 0 || !isspace(c))
      break;
    COMMON_pos++;
  }
}


PUBLIC char *COMMON_get_current(void)
{
  return &common_buffer[COMMON_pos];
}


PUBLIC long COMMON_get_size_left(void)
{
  return common_len - COMMON_pos;
}


#if 0
PUBLIC void SWAP_long(long *val)
{
  char *addr = (char *)val;

  addr[0] ^= addr[3];
  addr[1] ^= addr[2];

  addr[3] ^= addr[0];
  addr[2] ^= addr[1];

  addr[0] ^= addr[3];
  addr[1] ^= addr[2];
}

PUBLIC void SWAP_short(short *val)
{
  char *addr = (char *)val;

  addr[0] ^= addr[1];
  addr[1] ^= addr[0];
  addr[0] ^= addr[1];
}
#endif


PUBLIC void SWAP_long(long *val)
{
  char *p = (char *)val;
  char t1, t2;

  t1 = p[0];
  t2 = p[1];
  p[0] = p[3];
  p[1] = p[2];
  p[3] = t1;
  p[2] = t2;
}


PUBLIC void SWAP_short(short *val)
{
  char *p = (char *)val;
  char t;

  t = p[0];
  p[0] = p[1];
  p[1] = t;
}


PUBLIC void SWAP_double(double *val)
{
  char *p = (char *)val;
  char t;
  int i, j;

  for (i = 0; i < 4; i++)
  {
    j = i ^ 7;
    t = p[i];
    p[i] = p[j];
    p[j] = t;
  }
}

