/***************************************************************************

  compare.c

  Comparison functions

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __GBX_COMPARE_C

#include "gb_common.h"
#include "gbx_type.h"
#include "gbx_compare.h"
#include "gbx_date.h"

PRIVATE bool descent = FALSE;


int compare_nothing(void *a, void *b)
{
  return 0;
}

int compare_integer(int *a, int *b)
{
  bool comp;

  if (*a < *b)
    comp = -1;
  else if (*a > *b)
    comp = 1;
  else
    return 0;

  if (descent)
    comp = -comp;

  return comp;
}

int compare_short(short *a, short *b)
{
  bool comp;

  if (*a < *b)
    comp = -1;
  else if (*a > *b)
    comp = 1;
  else
    return 0;

  if (descent)
    comp = -comp;

  return comp;
}


int compare_byte(unsigned char *a, unsigned char *b)
{
  bool comp;

  if (*a < *b)
    comp = -1;
  else if (*a > *b)
    comp = 1;
  else
    return 0;

  if (descent)
    comp = -comp;

  return comp;
}


int compare_float(double *a, double *b)
{
  bool comp;

  if (*a < *b)
    comp = -1;
  else if (*a > *b)
    comp = 1;
  else
    return 0;

  if (descent)
    comp = -comp;

  return comp;
}

int compare_date(DATE *a, DATE *b)
{
  bool comp;

  comp = DATE_comp(a, b);

  if (descent)
    comp = -comp;

  return comp;
}

#define IMPLEMENT_COMPARE_STRING(_name, _func) \
int compare_string_##_name(char **pa, char **pb) \
{ \
  char *a; \
  char *b; \
  int comp; \
  \
  a = *pa; \
  if (!a) \
    a = ""; \
  \
  b = *pb; \
  if (!b) \
    b = ""; \
  \
  comp = _func(a, b); \
  if (descent) \
    comp = -comp; \
  return comp; \
}

IMPLEMENT_COMPARE_STRING(binary, strcmp)
IMPLEMENT_COMPARE_STRING(text, strcasecmp)
IMPLEMENT_COMPARE_STRING(lang, strcoll)


int compare_object(void **a, void **b)
{
  if (*a == *b)
    return 0;
  else
    return descent ? 1 : -1;
}

PUBLIC COMPARE_FUNC COMPARE_get(TYPE type, int mode)
{
  descent = (mode & GB_COMP_DESCENT) != 0;
  mode &= GB_COMP_TYPE_MASK;

  switch(type)
  {
    case T_INTEGER:
      return (COMPARE_FUNC)compare_integer;

    case T_SHORT:
      return (COMPARE_FUNC)compare_short;

    case T_BYTE:
      return (COMPARE_FUNC)compare_byte;

    case T_FLOAT:
      return (COMPARE_FUNC)compare_float;

    case T_DATE:
      return (COMPARE_FUNC)compare_date;

    case T_STRING:
      switch(mode)
      {
        case GB_COMP_TEXT: return (COMPARE_FUNC)compare_string_text;
        case GB_COMP_LANG: return (COMPARE_FUNC)compare_string_lang;
        default: return (COMPARE_FUNC)compare_string_binary;
      }

    case T_OBJECT:
      return (COMPARE_FUNC)compare_object;

    default:
      return (COMPARE_FUNC)compare_nothing;
  }
}
