/***************************************************************************

  subr_math.c

  Mathematical routines

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#include "gb_common.h"

#ifdef __sun__
/* Make math.h define M_PI and a few other things */
#define __EXTENSIONS__
#endif

#include <math.h>

#ifdef __sun__
/* Get definition for finite() */
#include <ieeefp.h>
#endif

#include "gbx_value.h"
#include "gbx_subr.h"
#include "gbx_math.h"


PRIVATE MATH_FUNC MathFunc[] = {
  NULL, frac, log, exp, sqrt, sin, cos, tan, atan, asin, acos,
  deg, rad, log10, sinh, cosh, tanh, asinh, acosh, atanh
  };


/* Arithmtique */

#define SMT_NAME  SUBR_add
#define SMT_TYPE  2
#define SMT_OP    +=
#define SMT_DATE

#include "gbx_subr_math_temp.h"


#define SMT_NAME  SUBR_sub
#define SMT_TYPE  2
#define SMT_OP    -=
#define SMT_DATE

#include "gbx_subr_math_temp.h"


#define SMT_NAME  SUBR_mul
#define SMT_TYPE  2
#define SMT_OP    *=

#include "gbx_subr_math_temp.h"


#define SMT_NAME  SUBR_div
#define SMT_TYPE  2
#define SMT_OP    /=
#define SMT_TEST_ZERO
#define SMT_FLOAT

#include "gbx_subr_math_temp.h"


#define SMT_NAME  SUBR_neg
#define SMT_TYPE  1
#define SMT_OP    -

#include "gbx_subr_math_temp.h"


#define SMT_NAME    SUBR_quo
#define SMT_TYPE    3
#define SMT_RESULT  quot

#include "gbx_subr_math_temp.h"


#define SMT_NAME    SUBR_rem
#define SMT_TYPE    3
#define SMT_RESULT  rem

#include "gbx_subr_math_temp.h"



/* Logique */

#define SMT_NAME  SUBR_and
#define SMT_TYPE  2
#define SMT_OP    &=
#define SMT_INTEGER

#include "gbx_subr_math_temp.h"


#define SMT_NAME  SUBR_or
#define SMT_TYPE  2
#define SMT_OP    |=
#define SMT_INTEGER

#include "gbx_subr_math_temp.h"


#define SMT_NAME  SUBR_xor
#define SMT_TYPE  2
#define SMT_OP    ^=
#define SMT_INTEGER

#include "gbx_subr_math_temp.h"


/*
#define SMT_NAME  SUBR_not
#define SMT_TYPE  1
#define SMT_OP    ~
#define SMT_INTEGER

#include "gbx_subr_math_temp.h"
*/

#define SMT_NAME  SUBR_pow
#define SMT_TYPE  2
#define SMT_FUNC  pow
#define SMT_FLOAT

#include "gbx_subr_math_temp.h"


#define SMT_NAME          SUBR_abs
#define SMT_TYPE          1
#define SMT_FUNC_INTEGER  labs
#define SMT_FUNC_FLOAT    fabs

#include "gbx_subr_math_temp.h"


#define SMT_NAME          SUBR_int
#define SMT_TYPE          1
#define SMT_FUNC_INTEGER  0+
#define SMT_FUNC_FLOAT    floor

#include "gbx_subr_math_temp.h"


#define SMT_NAME          SUBR_fix
#define SMT_TYPE          1
#define SMT_FUNC_INTEGER  0+
#define SMT_FUNC_FLOAT    fix

#include "gbx_subr_math_temp.h"


#define SMT_NAME          SUBR_sgn
#define SMT_TYPE          1
#define SMT_FUNC_INTEGER  lsgn
#define SMT_FUNC_FLOAT    fsgn

#include "gbx_subr_math_temp.h"


void SUBR_pi(void)
{
  SUBR_ENTER();

  if (NPARAM == 0)
  {
    RETURN->type = T_FLOAT;
    RETURN->_float.value = M_PI;
  }
  else
  {
    VALUE_conv(PARAM, T_FLOAT);
    RETURN->type = T_FLOAT;
    RETURN->_float.value = M_PI * PARAM->_float.value;
  }

  SUBR_LEAVE();
}


void SUBR_randomize(void)
{
  randomize();
  SP->type = T_VOID;
  SP++;
}


void SUBR_rnd(void)
{
  double min = 0.0, max = 1.0;

  SUBR_ENTER();

  if (NPARAM >= 1)
  {
    VALUE_conv(&PARAM[0], T_FLOAT);
    max = PARAM->_float.value;
  }

  if (NPARAM == 2)
  {
    min = max;
    VALUE_conv(&PARAM[1], T_FLOAT);
    max = PARAM[1]._float.value;
  }

  RETURN->type = T_FLOAT;
  RETURN->_float.value = (rnd() * (max - min)) + min;

  SUBR_LEAVE();
}


void SUBR_round(void)
{
  long val = 0;
  double power;

  SUBR_ENTER();

  if (NPARAM == 2)
    val = SUBR_get_integer(&PARAM[1]);

  power = pow(10, val);

  VALUE_conv(&PARAM[0], T_FLOAT);

  RETURN->type = T_FLOAT;
  /*RETURN->_float.value = rint(PARAM->_float.value / power) * power;*/
  RETURN->_float.value = rint(PARAM->_float.value / power) * power;

  SUBR_LEAVE();
}


PUBLIC void SUBR_math(void)
{
  SUBR_ENTER_PARAM(1);

  if (TYPE_is_variant(PARAM->type))
    VARIANT_undo(PARAM);

  if (!TYPE_is_number(PARAM->type))
    THROW(E_TYPE, "Number", TYPE_get_name(PARAM->type));

  VALUE_conv(PARAM, T_FLOAT);

  PARAM->_float.value = (*MathFunc[EXEC_code & 0x1F])(PARAM->_float.value);

  if (!finite(PARAM->_float.value))
    THROW(E_MATH);
}


PUBLIC void SUBR_not(void)
{
  static void *jump[17] = {
    &&__VARIANT, &&__BOOLEAN, &&__INTEGER, &&__INTEGER, &&__INTEGER, &&__LONG, &&__FLOAT, &&__DATE,
    &&__STRING, &&__STRING, &&__ERROR, &&__ERROR, &&__ERROR, &&__ERROR, &&__ERROR, &&__NULL,
    &&__OBJECT
    };

  VALUE *P1;
  void *jump_end;
  TYPE type = EXEC_code & 0x1F;
  boolean test;

  P1 = SP - 1;
  jump_end = &&__END;
  goto *jump[type];

__VARIANT:

  type = P1->type;

  if (TYPE_is_variant(type))
  {
    type = P1->_variant.vtype;
    jump_end = &&__VARIANT_END;
    VARIANT_undo(P1);
  }
  else if (TYPE_is_object(type))
    *PC |= T_OBJECT;
  else if (type)
    *PC |= type;
  else
    goto __ERROR;

  if (TYPE_is_object(type))
    goto __OBJECT;
  else
    goto *jump[type];

__BOOLEAN:

  P1->_integer.value = P1->_integer.value ? 0 : (-1);
  goto *jump_end;

__INTEGER:

  P1->_integer.value = ~P1->_integer.value;
  goto *jump_end;

__LONG:
__FLOAT:
__DATE:
  goto __ERROR;

__STRING:
__OBJECT:
__NULL:

  test = VALUE_is_null(P1);
  RELEASE(P1);

  P1->_integer.value =  test ? (-1) : 0;
  P1->type = T_BOOLEAN;
  goto *jump_end;

__ERROR:

  THROW(E_TYPE, "Number, String or Object", TYPE_get_name(type));

__VARIANT_END:

  VALUE_conv(P1, T_VARIANT);

__END:
  return;
}
