package Frm2Form;

use strict;

### Variables

# Strings to translate (vb format => gb format)
my %trans = (
		'\r'            => '',
		'VERSION (.+)'  => '# Gambas Form File 1.0',
		'VB\.(.+)\s+(.+)' => '$2 $1',
		'Client(\w+)'   => '$1',
		'Begin\b'         => '{',
		'End\b'           => '}',
		'BorderStyle'   => 'Border',
		'Caption'       => 'Text',
		'Command'       => 'Button',
		'CommandButton' => 'Button',
		'ButtonButton'  => 'Button',
		'Label'         => 'TextLabel',
		'\"(.+)\"'	=> '("$1")',
		'VScrollBar'    => 'Scrollbar',
		'HScrollBar'    => 'Scrollbar'
);

# Twips properties that must be converted to pixels
my @twips = qw (Top Left Width Height);

# Strings we don't know how to translate
my @nontrans = qw (
			LinkTopic MaxButton MinButton
ScaleHeight ScaleMode
			ScaleWidth ShowInTaskbar TabIndex
Picture
			StartUpPosition Alignment BackStyle
);

### Subs

sub Translate_line {
  # Returns translated line

  my $input = shift;

  # Return if non translatable
  foreach my $nontrans (@nontrans) {
    return if $input =~ /$nontrans/;
  }

  # Translate
  foreach my $re (keys %trans) {
    my $regexp = "\$input =~ s/$re/$trans{$re}/g";
    eval ($regexp);
  } 

  # Convert twips
  foreach my $t (@twips) {
    if ($input =~ /$t\s+\=\s+(\d+)/) {
      my $old_val = $1;
      my $new_val = int($old_val * 10 / 144);
      $input =~ s/$old_val/$new_val/g;
    }
  }

  return $input;
}

###

sub Translate {
  # Returns translated line by line

  my $output;
  while (my $line = shift) {
    last if $line =~ /Attribute/;
    $output .= &Translate_line($line);
  }

  # Last touches
  {
    local $/;
    # Remove BeginProperty...EndProperty entire region
    $output =~ s/BeginProperty.+?EndProperty//gs;
  }

  return $output;
}

1;
