//
// $Source: /cvsroot/gambit/gambit/sources/gui/efgshow.h,v $
// $Date: 2003/09/23 20:15:40 $
// $Revision: 1.49.2.7 $
//
// DESCRIPTION:
// Interface to class representing extensive form viewing window
//
// This file is part of Gambit
// Copyright (c) 2002, The Gambit Project
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef EFGSHOW_H
#define EFGSHOW_H

#include "wx/listctrl.h"
#include "wx/printdlg.h"
#include "wx/notebook.h"

#include "gambit.h"
#include "efgconst.h"
#include "nash/behavsol.h"

class EfgProfileList;
class EfgNavigateWindow;
class EfgOutcomeWindow;
class EfgSupportWindow;
class TreeWindow;

const int idEFG_SOLUTION_LIST = 900;

class EfgShow : public wxFrame {
private:
  efgGame &m_efg;
  TreeWindow *m_treeWindow;
  Node *m_cursor, *m_copyNode, *m_cutNode;

  int m_currentProfile;
  gList<BehavSolution> m_profiles;

  EFSupport *m_currentSupport;
  gList<EFSupport *> m_supports;

  EfgProfileList *m_profileTable;
  wxString m_filename;
  wxFrame *m_solutionWindow, *m_infoWindow;

  wxNotebook *m_infoNotebook;
  EfgNavigateWindow *m_navigateWindow;
  EfgOutcomeWindow *m_outcomeWindow;
  EfgSupportWindow *m_supportWindow;

  wxPageSetupData m_pageSetupData;
  wxPrintData m_printData;

  void MakeMenus(void);
  void MakeToolbar(void);
  
  // Event handlers
  void OnCloseWindow(wxCloseEvent &);
  void OnFocus(wxFocusEvent &);

  // Menu event handlers
  void OnFileNew(wxCommandEvent &);
  void OnFileOpen(wxCommandEvent &);
  void OnFileSave(wxCommandEvent &);
  void OnFileExportBMP(wxCommandEvent &);
  void OnFileExportJPEG(wxCommandEvent &);
  void OnFileExportPNG(wxCommandEvent &);
  void OnFileExportPS(wxCommandEvent &);

  void OnFilePageSetup(wxCommandEvent &);
  void OnFilePrintPreview(wxCommandEvent &);
  void OnFilePrint(wxCommandEvent &);
  void OnFileExit(wxCommandEvent &);
  void OnFileMRUFile(wxCommandEvent &);

  void OnEditCut(wxCommandEvent &);
  void OnEditCopy(wxCommandEvent &);
  void OnEditPaste(wxCommandEvent &);
  
  void OnEditInsert(wxCommandEvent &);
  void OnEditDelete(wxCommandEvent &);
  void OnEditReveal(wxCommandEvent &);

  void OnEditToggleSubgame(wxCommandEvent &);
  void OnEditMarkSubgameTree(wxCommandEvent &);
  void OnEditUnmarkSubgameTree(wxCommandEvent &);

  void OnEditMove(wxCommandEvent &);
  void OnEditGame(wxCommandEvent &);

  void OnViewProfiles(wxCommandEvent &);
  void OnViewCursor(wxCommandEvent &);
  void OnViewOutcomes(wxCommandEvent &);
  void OnViewSupports(wxCommandEvent &);
  void OnViewZoomIn(wxCommandEvent &);
  void OnViewZoomOut(wxCommandEvent &);
  void OnViewSupportReachable(wxCommandEvent &);

  void OnFormatDisplayLayout(wxCommandEvent &);
  void OnFormatDisplayLegend(wxCommandEvent &);
  void OnFormatDisplayColors(wxCommandEvent &);
  void OnFormatDisplayDecimals(wxCommandEvent &);
  void OnFormatFontsAboveNode(wxCommandEvent &);
  void OnFormatFontsBelowNode(wxCommandEvent &);
  void OnFormatFontsAfterNode(wxCommandEvent &);
  void OnFormatFontsAboveBranch(wxCommandEvent &);
  void OnFormatFontsBelowBranch(wxCommandEvent &);

  void OnToolsDominance(wxCommandEvent &);
  void OnToolsEquilibrium(wxCommandEvent &);
  void OnToolsQre(wxCommandEvent &);
  void OnToolsNormalReduced(wxCommandEvent &);
  void OnToolsNormalAgent(wxCommandEvent &);

  void OnHelpAbout(wxCommandEvent &);

  void OnSupportDuplicate(wxCommandEvent &);
  void OnSupportDelete(wxCommandEvent &);

  void OnProfilesNew(wxCommandEvent &);
  void OnProfilesDuplicate(wxCommandEvent &);
  void OnProfilesDelete(wxCommandEvent &);
  void OnProfilesDeleteAll(wxCommandEvent &);
  void OnProfilesProperties(wxCommandEvent &);
  void OnProfilesReport(wxCommandEvent &);
  void OnProfileSelected(wxListEvent &);

  void OnInfoNotebookPage(wxNotebookEvent &);

public:
  // CONSTRUCTOR AND DESTRUCTOR
  EfgShow(efgGame &p_efg, wxWindow *p_parent);
  virtual ~EfgShow();

  // PROFILE ACCESS AND MANIPULATION
  void AddProfile(const BehavSolution &, bool map);
  void RemoveProfile(int);
  void RemoveProfiles(void);
  void ChangeProfile(int);
  int CurrentProfile(void) const { return m_currentProfile; }
  const BehavSolution &GetCurrentProfile(void) const;
  const gList<BehavSolution> &Profiles(void) const { return m_profiles; }
  gText UniqueProfileName(void) const;

  // SUPPORT ACCESS AND MANIPULATION
  EFSupport *GetSupport(void);
  const gList<EFSupport *> &Supports(void) const { return m_supports; }
  void SetSupportNumber(int p_number);
  gText UniqueSupportName(void) const;
  void OnSupportsEdited(void);

  gText GetRealizProb(const Node *) const;
  gText GetBeliefProb(const Node *) const;
  gText GetNodeValue(const Node *) const;
  gText GetInfosetProb(const Node *) const;
  gText GetInfosetValue(const Node *) const;
  gText GetActionValue(const Node *, int act) const;
  gText GetActionProb(const Node *, int act) const;
  gNumber ActionProb(const Node *n, int br) const;

  efgGame *Game(void) { return &m_efg; }

  void UpdateMenus(void);
  int NumDecimals(void) const;

  void OnOutcomesEdited(void);
  gText UniqueOutcomeName(void) const;

  void SetFilename(const wxString &s);
  const wxString &Filename(void) const { return m_filename; }

  void SetCursor(Node *m_node);
  Node *Cursor(void) const { return m_cursor; }
  Node *CopyNode(void) const { return m_copyNode; }
  Node *CutNode(void) const { return m_cutNode; }

  void OnEditNode(wxCommandEvent &);
  void OnTreeChanged(bool, bool);

  DECLARE_EVENT_TABLE()
};

#endif // EFGSHOW_H

