//
// $Source: /cvsroot/gambit/gambit/sources/gui/Attic/nfgprofile.cc,v $
// $Date: 2004/08/17 17:53:51 $
// $Revision: 1.4.2.17 $
//
// DESCRIPTION:
// Normal form mixed profile window
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "wx/wxprec.h"
#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif  // WX_PRECOMP
#include "nfgprofile.h"
#include "nfgconst.h"

//-------------------------------------------------------------------------
//                  class NfgProfileList: Member functions
//-------------------------------------------------------------------------

BEGIN_EVENT_TABLE(NfgProfileList, wxListCtrl)
  EVT_RIGHT_DOWN(NfgProfileList::OnRightClick)
END_EVENT_TABLE()

NfgProfileList::NfgProfileList(NfgShow *p_nfgShow, wxWindow *p_parent)
  : wxListCtrl(p_parent, idNFG_SOLUTION_LIST, wxDefaultPosition,
	       wxSize(400, 200), wxLC_REPORT | wxLC_SINGLE_SEL),
    m_parent(p_nfgShow)
{
  m_menu = new wxMenu(_("Profiles"));
  m_menu->Append(NFG_PROFILES_NEW, _("New profile"), 
		 _("Create a new profile"));
  m_menu->Append(NFG_PROFILES_DUPLICATE, _("Duplicate profile"),
		 _("Duplicate this profile"));
  m_menu->Append(NFG_PROFILES_DELETE, _("Delete profile"), 
		 _("Delete this profile"));
  m_menu->Append(NFG_PROFILES_DELETE_ALL, _("Delete all profiles"),
		 _("Delete all profiles"));
  m_menu->Append(NFG_PROFILES_PROPERTIES, _("Properties"),
		 _("View and edit properties of this profile"));
  m_menu->Append(NFG_PROFILES_REPORT, _("Report"),
		 _("Generate a report with information on profiles"));

  UpdateValues();
}

NfgProfileList::~NfgProfileList()
{ }

void NfgProfileList::UpdateValues(void)
{
  ClearAll();
  InsertColumn(0, _("Name"));
  InsertColumn(1, _("Creator"));
  InsertColumn(2, _("Nash"));
  InsertColumn(3, _("Perfect"));
  InsertColumn(4, _("Liap Value"));
  InsertColumn(5, _("Qre Lambda"));
  
  const Nfg &nfg = m_parent->Game();
  int maxColumn = 5;

  for (int pl = 1; pl <= nfg.NumPlayers(); pl++) {
    NFPlayer *player = nfg.Players()[pl];
    for (int st = 1; st <= player->NumStrats(); st++) {
      InsertColumn(++maxColumn,
		   wxString::Format(_T("%d:%d"), pl, st));
    }
  }

  for (int i = 1; i <= m_parent->Profiles().Length(); i++) {
    const MixedSolution &profile = m_parent->Profiles()[i];
    InsertItem(i - 1, 
	       wxString::Format(_T("%s"), (char *) profile.GetName()));
    SetItem(i - 1, 1, 
	    wxString::Format(_T("%s"), (char *) profile.Creator()));
    SetItem(i - 1, 2, 
	    wxString::Format(_T("%s"), (char *) ToText(profile.IsNash())));
    try {
      SetItem(i - 1, 3, 
	      wxString::Format(_T("%s"), 
			       (char *) ToText(profile.IsPerfect(false))));
    }
    catch (...) {
      SetItem(i - 1, 3, _T("DK"));
    }
    SetItem(i - 1, 4, 
	    wxString::Format(_T("%s"), (char *) ToText(profile.LiapValue())));
    if (profile.Creator() == "Qre[NFG]") {
      SetItem(i - 1, 5, 
	      wxString::Format(_T("%s"), (char *) ToText(profile.QreLambda())));
    }
    else {
      SetItem(i - 1, 5, _T("--"));
    }

    int column = 5;
    for (int pl = 1; pl <= nfg.NumPlayers(); pl++) {
      NFPlayer *player = nfg.Players()[pl];
      for (int st = 1; st <= player->NumStrats(); st++) {
	SetItem(i - 1, ++column,
		wxString::Format(_T("%s"), 
				 (char *) ToText(profile(player->Strategies()[st]))));
      }
    }    
  }

  if (m_parent->Profiles().Length() > 0) {
    wxListItem item;
    item.m_mask = wxLIST_MASK_STATE;
    item.m_itemId = m_parent->CurrentProfile() - 1;
    item.m_state = wxLIST_STATE_SELECTED;
    item.m_stateMask = wxLIST_STATE_SELECTED;
    SetItem(item);
  }
}

void NfgProfileList::OnRightClick(wxMouseEvent &p_event)
{
  m_menu->Enable(NFG_PROFILES_DUPLICATE, m_parent->CurrentProfile() > 0);
  m_menu->Enable(NFG_PROFILES_DELETE, m_parent->CurrentProfile() > 0);
  m_menu->Enable(NFG_PROFILES_PROPERTIES, m_parent->CurrentProfile() > 0);
  m_menu->Enable(NFG_PROFILES_REPORT, m_parent->CurrentProfile() > 0);
  PopupMenu(m_menu, p_event.m_x, p_event.m_y);
}

wxString NfgProfileList::GetReport(void) const
{
  wxString report;
  const gList<MixedSolution> &profiles = m_parent->Profiles();
  const Nfg &nfg = m_parent->Game();

  report += wxString::Format(_("Mixed strategy profiles on game '%s' [%s]\n\n"),
			     (const char *) nfg.GetTitle(),
			     m_parent->Filename().c_str());

  report += wxString::Format(_("Number of profiles: %d\n"), profiles.Length());

  for (int i = 1; i <= profiles.Length(); i += 4) {
    report += _T("\n----------\n\n");

    report += _T("          ");
    for (int j = 0; j < 4 && i + j <= profiles.Length(); j++) {
      report += wxString::Format(_T("%-15s "), 
				 (const char *) profiles[i+j].GetName());
    }
    report += _T("\n");

    report += _T("          ");
    for (int j = 0; j < 4 && i + j <= profiles.Length(); j++) {
      report += _T("--------------- "); 
    }
    report += _T("\n");

    report += _T("Creator:  ");
    for (int j = 0; j < 4 && i + j <= profiles.Length(); j++) {
      report += wxString::Format(_T("%-15s "),
				 (const char *) profiles[i+j].Creator());
    }
    report += _T("\n");

    report += _T("Nash?     ");
    for (int j = 0; j < 4 && i + j <= profiles.Length(); j++) {
      report += wxString::Format(_T("%-15s "),
				 (const char *) ToText(profiles[i+j].IsNash()));
    }
    report += _T("\n");

    report += _T("Perfect?  ");
    for (int j = 0; j < 4 && i + j <= profiles.Length(); j++) {
      try {
	report += wxString::Format(_T("%-15s "),
				   (const char *) ToText(profiles[i+j].IsPerfect(false)));
      }
      catch (...) {
	report += wxString::Format(_T("%-15s "), _T("DK"));
      }
    }
    report += _T("\n");

    report += _T("Liap:     ");
    for (int j = 0; j < 4 && i + j <= profiles.Length(); j++) {
      report += wxString::Format(_T("%-15s "),
				 (const char *) ToText(profiles[i+j].LiapValue()));
    }
    report += _T("\n\n");

    for (int pl = 1; pl <= nfg.NumPlayers(); pl++) {
      NFPlayer *player = nfg.Players()[pl];
      report += wxString::Format(_T("%s\n"), (const char *) player->GetName());

      for (int st = 1; st <= player->NumStrats(); st++) {
	report += wxString::Format(_T("%2d: %-6s"), st,
				   (const char *) player->Strategies()[st]->Name());

	for (int j = 0; j < 4 && i + j <= profiles.Length(); j++) {
	  report += wxString::Format(_T("%-15s "), 
				     (const char *) ToText((*profiles[i+j].Profile())(pl, st)));
	}
	report += _T("\n");
      }

      report += _T("\n");
    }
  }

  return report;
}

