//
// $Source: /cvsroot/gambit/gambit/sources/math/gsmatrix.cc,v $
// $Date: 2003/12/12 20:17:31 $
// $Revision: 1.5.2.1 $
//
// DESCRIPTION:
// Instantiation of common square matrix types
//
// This file is part of Gambit
// Copyright (c) 2002, The Gambit Project
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "gsmatrix.imp"
#include "rational.h"
#include "double.h"

gMatrixSingular::~gMatrixSingular() { }

gText gMatrixSingular::Description(void) const
{
  return "Attempted to invert a singular matrix";
}

template class gSquareMatrix<double>;
template class gSquareMatrix<gDouble>;
template class gSquareMatrix<gRational>;

template gOutput & operator<< (gOutput&, const gSquareMatrix<double>&);
template gOutput & operator<< (gOutput&, const gSquareMatrix<gDouble>&);
template gOutput & operator<< (gOutput&, const gSquareMatrix<gRational>&);

