/**
 * File:          $RCSfile: png_io.h,v $
 * Module:        PNG format image file I/O functions
 * Part of:       Gandalf Library
 *
 * Revision:      $Revision: 1.11 $
 * Last edited:   $Date: 2002/12/06 17:48:50 $
 * Author:        $Author: pm $
 * Copyright:     (c) 2000 Imagineer Software Limited
 *
 * Notes:         Works with the libpng & lz libraries
 */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _GAN_IMAGE_PNG_IO_H
#define _GAN_IMAGE_PNG_IO_H

#include <stdio.h>
#include <gandalf/common/misc_defs.h>
#include <gandalf/image/image_defs.h>

#ifdef __cplusplus
extern "C" {
#endif

/* only compile if you have PNG */
#ifdef HAVE_PNG

/* Prototypes for public functions in png_io.c */
Gan_Image* gan_read_png_image_stream ( FILE *infile, Gan_Image *image,
                                       double gam );
Gan_Image* gan_read_png_image ( const char *filename, Gan_Image *image,
                                double gam );
Gan_Bool gan_write_png_image_stream ( FILE *outfile, Gan_Image *image,
                                      double gam );
Gan_Bool gan_write_png_image ( const char *filename, Gan_Image *image,
                               double gam );

#endif /* #ifdef HAVE_PNG */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef _GAN_IMAGE_PNG_IO_H */
