.\" Automatically generated by Pod::Man v1.34, Pod::Parser v1.13
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "ganglia 3"
.TH ganglia 3 "Thu Nov  6 10:19:57 PST 2003" "2.5.5" "ganglia"
.SH "Name"
.IX Header "Name"
\&\fBganglia\fR \- distributed monitoring system
.SH "Version"
.IX Header "Version"
\&\fBganglia\fR 2.5.5
.PP
The latest version of this software and document will always be found at 
http://ganglia.sourceforge.net/
.SH "Synopsis"
.IX Header "Synopsis"
.Vb 6
\&     ______                  ___
\&    / ____/___ _____  ____ _/ (_)___ _
\&   / / __/ __ `/ __ \e/ __ `/ / / __ `/
\&  / /_/ / /_/ / / / / /_/ / / / /_/ /
\&  \e____/\e__,_/_/ /_/\e__, /_/_/\e__,_/
\&                   /____/ Distributed Monitoring System
.Ve
.PP
Ganglia is a scalable distributed monitoring system for high-performance computing systems 
such as clusters and Grids. It is based on a hierarchical design targeted at federations of 
clusters. It relies on a multicast-based listen/announce protocol to monitor state within 
clusters and uses a tree of point-to-point connections amongst representative cluster nodes 
to federate clusters and aggregate their state. It leverages widely used technologies such as 
\&\s-1XML\s0 for data representation, \s-1XDR\s0 for compact, portable data transport, and RRDtool for data 
storage and visualization. It uses carefully engineered data structures and algorithms to 
achieve very low per-node overheads and high concurrency. The implementation is robust, has 
been ported to an extensive set of operating systems and processor architectures, and is 
currently in use on over 500 clusters around the world. It has been used to link clusters 
across university campuses and around the world and can scale to handle clusters with 2000 nodes.
.PP
The ganglia system is comprised of two unique daemons, a PHP-based web frontend and a few other
small utility programs.
.IP "\fBGanglia Monitoring Daemon (gmond)\fR" 4
.IX Item "Ganglia Monitoring Daemon (gmond)"
Gmond is a multi-threaded daemon which runs on each cluster node you want to monitor. 
Installation is easy. You don't have to have a common \s-1NFS\s0 filesystem or a database backend, 
install special accounts, maintain configuration files or other annoying hassles. Gmond is 
its own redundant, distributed database.
.Sp
Gmond has four main responsibilities: monitor changes in host state, multicast relevant changes, 
listen to the state of all other ganglia nodes via a multicast channel and answer requests for 
an \s-1XML\s0 description of the cluster state. 
.Sp
Each gmond transmits in information in two different ways: multicasting host state in external data 
representation (\s-1XDR\s0) format or sending \s-1XML\s0 over a \s-1TCP\s0 connection.
.IP "\fBGanglia Meta Daemon (gmetad)\fR" 4
.IX Item "Ganglia Meta Daemon (gmetad)"
Federation in Ganglia is achieved using a tree of point-to-point
connections amongst representative cluster nodes to aggregate the
state of multiple clusters.  At each node in the tree, a Ganglia Meta
Daemon (\f(CW\*(C`gmetad\*(C'\fR) periodically polls a collection of child data
sources, parses the collected \s-1XML\s0, saves all numeric, volatile metrics
to round-robin databases and exports
the aggregated \s-1XML\s0 over a \s-1TCP\s0 sockets to clients.  Data sources may be either
\&\f(CW\*(C`gmond\*(C'\fR daemons, representing specific clusters, or other
\&\f(CW\*(C`gmetad\*(C'\fR daemons, representing sets of clusters. Data sources
use source \s-1IP\s0 addresses for access control and can be specified using
multiple \s-1IP\s0 addresses for failover. The latter capability is natural
for aggregating data from clusters since each \f(CW\*(C`gmond\*(C'\fR daemon
contains the entire state of its cluster.
.IP "\fBGanglia \s-1PHP\s0 Web Frontend\fR" 4
.IX Item "Ganglia PHP Web Frontend"
The Ganglia web frontend provides a view of the gathered information 
via real-time dynamic web pages. Most importantly, it displays Ganglia 
data in a meaningful way for system administrators and computer users. 
Although the web frontend to ganglia started as a simple \s-1HTML\s0 view of the 
\&\s-1XML\s0 tree, it has evolved into a system that keeps a colorful history of 
all collected data.
.Sp
The Ganglia web frontend caters to system administrators and users. For 
example, one can view the \s-1CPU\s0 utilization over the past hour, day, week, 
month, or year. The web frontend shows similar graphs for Memory usage, 
disk usage, network statistics, number of running processes, and all other 
Ganglia metrics.
.Sp
The web frontend depends on the existence of the \f(CW\*(C`gmetad\*(C'\fR which provides it 
with data from several Ganglia sources. Specifically, the web frontend will 
open the local port 8651 (by default) and expects to receive a Ganglia \s-1XML\s0 tree. 
The web pages themselves are highly dynamic; any change to the Ganglia data appears 
immediately on the site. This behavior leads to a very responsive site, but requires 
that the full \s-1XML\s0 tree be parsed on every page access. Therefore, the Ganglia web 
frontend should run on a fairly powerful, dedicated machine if it presents a large 
amount of data. 
.Sp
The Ganglia web frontend is written in the \s-1PHP\s0 scripting language, and uses graphs 
generated by \f(CW\*(C`gmetad\*(C'\fR to display history information. It has been tested on many 
flavours of Unix (primarily Linux) with the Apache webserver and the \s-1PHP\s0 4.1 module.
.SH "Installation"
.IX Header "Installation"
The latest version of all ganglia software can always be downloaded from 
http://ganglia.sourceforge.net/downloads.php
.PP
Ganglia runs on Linux (i386, ia64, sparc, alpha, powerpc, m68k, mips, arm, hppa, s390), 
Solaris, FreeBSD, \s-1AIX\s0, \s-1IRIX\s0, Tru64, \s-1HPUX\s0, MacOS X and Windows (cygwin beta) making it as 
portable as it is scalable.
.Sh "Monitoring Core Installation"
.IX Subsection "Monitoring Core Installation"
If you use the Linux RPMs provided on the ganglia web site, you can skip 
to the end of this section.
.PP
Ganglia uses the \s-1GNU\s0 autoconf so compilation and installation of the monitoring core is basically
.PP
.Vb 3
\&  % ./configure
\&  % make
\&  % make install
.Ve
.PP
but there are some issues that you need to take a look at first.
.IP "\fBKernel multicast support\fR" 4
.IX Item "Kernel multicast support"
Currently ganglia will only run on machines with multicast support.  The
vast majority of machines have multicast support by default.  If you have
problems with ganglia this is a core issue.  Later versions of ganglia will not
have the multicast requirement.
.IP "\fBGmetad is not installed by default\fR" 4
.IX Item "Gmetad is not installed by default"
Since \f(CW\*(C`gmetad\*(C'\fR relies on the Round-Robin Database Tool ( see http://www.rrdtool.com/ )
it will not be compiled unless you explicit request it by using a \fB\-\-with\-gmetad\fR flag.
.Sp
.Vb 1
\&  % ./configure --with-gmetad
.Ve
.Sp
The configure script will fail if it cannot find the rrdtool library and header files.
By default, it expects to find them at /usr/include/rrd.h and /usr/lib/librrd.a.  If 
you installed them in different locations then you need to add the following configure
flags
.Sp
.Vb 2
\&  % ./configure CFLAGS="-I/rrd/header/path" CPPFLAGS="-I/rrd/header/path" \e
\&     LDFLAGS="-L/rrd/library/path" --with-gmetad
.Ve
.Sp
of course, you need to substitute \f(CW\*(C`/rrd/header/path\*(C'\fR and \f(CW\*(C`/rrd/library/path\*(C'\fR with the
real location of the rrd tool header file and library respectively.
.IP "\fB\s-1AIX\s0 should not be compiled with shared libraries\fR" 4
.IX Item "AIX should not be compiled with shared libraries"
You must add the \f(CW\*(C`\-\-disable\-shared\*(C'\fR and \f(CW\*(C`\-\-enable\-static\*(C'\fR configure flags if you running on \s-1AIX\s0
.Sp
.Vb 1
\&  % ./configure --disable-shared --enable-static
.Ve
.IP "\fB\s-1GEXEC\s0 confusion\fR" 4
.IX Item "GEXEC confusion"
\&\s-1GEXEC\s0 is a scalable cluster remote execution system which provides fast, \s-1RSA\s0 authenticated 
remote execution of parallel and distributed jobs. It provides transparent forwarding of 
stdin, stdout, stderr, and signals to and from remote processes, provides local environment 
propagation, and is designed to be robust and to scale to systems over 1000 nodes. Internally, 
\&\s-1GEXEC\s0 operates by building an n\-ary tree of \s-1TCP\s0 sockets and threads between gexec daemons and 
propagating control information up and down the tree. By using hierarchical control, \s-1GEXEC\s0 
distributes both the work and resource usage associated with massive amounts of parallelism 
across multiple nodes, thereby eliminating problems associated with single node resource limits 
(e.g., limits on the number of file descriptors on front-end nodes). 
(from http://www.theether.org/gexec )
.Sp
\&\f(CW\*(C`gexec\*(C'\fR is a great cluster execution tool but integrating it with ganglia is very clumsy to
say the least.  \s-1GEXEC\s0 can run standalone without access to a ganglia \f(CW\*(C`gmond\*(C'\fR.  In standalone
mode gexec will use the hosts listed in your \s-1GEXEC_SVRS\s0 variable to run on.  For example,
say I want to run \f(CW\*(C`hostname\*(C'\fR on three machines in my cluster: \f(CW\*(C`host1\*(C'\fR, \f(CW\*(C`host2\*(C'\fR and \f(CW\*(C`host3\*(C'\fR.
I use the following command line.
.Sp
.Vb 1
\&  % GEXEC_SVRS="host1 host2 host3" gexec -n 3 hostname
.Ve
.Sp
and gexec would build an n\-ary tree (binary tree by default) of \s-1TCP\s0 sockets to those machines
and run the command \f(CW\*(C`hostname\*(C'\fR
.Sp
As an added feature, you can have \f(CW\*(C`gexec\*(C'\fR pull a host list from a locally running gmond and
use that as the host list instead of \s-1GEXEC_SVRS\s0.  The list is load balanced and \f(CW\*(C`gexec\*(C'\fR will
start the job on the \fIn\fR least-loaded machines.
.Sp
For example..
.Sp
.Vb 1
\&  % gexec -n 5 hostname
.Ve
.Sp
will run the command \f(CW\*(C`hostname\*(C'\fR on the five least-loaded machines in a cluster. 
.Sp
To turn on the \f(CW\*(C`gexec\*(C'\fR feature in ganglia you must configure ganglia with the \f(CW\*(C`\-\-enable\-gexec\*(C'\fR
flag
.Sp
.Vb 1
\&  % ./configure --enable-gexec
.Ve
.Sp
Enabling \f(CW\*(C`gexec\*(C'\fR means that by default any host running gmond will send a special multicast
message announcing that gexec is installed on it and open for requests.
.Sp
Now the question is, what if I don't want gexec to run on every host in my cluster?  For
example, you may not want to have \f(CW\*(C`gexec\*(C'\fR run jobs on your cluster frontend nodes.
.Sp
You simply add the following line to your \f(CW\*(C`gmond\*(C'\fR configuration file (\f(CW\*(C`/etc/gmond.conf\*(C'\fR by
default)
.Sp
.Vb 1
\&  no_gexec on
.Ve
.Sp
Simple huh?  I know the configuration file option, \f(CW\*(C`no_gexec\*(C'\fR, seems crazy (and it is).  Why
have an option that says \*(L"yes to no gexec\*(R"?  The early versions of gmond didn't use a configuration
file but instead commandline options.  One of the commandline options was simply \f(CW\*(C`\-\-no\-gexec\*(C'\fR
and the default was to announce gexec as on.
.PP
Once you have successfully run
.PP
.Vb 3
\&  % ./configure
\&  % make
\&  % make install
.Ve
.PP
you should find the following files installed in \f(CW\*(C`/usr\*(C'\fR (by default).
.PP
.Vb 4
\&  /usr/bin/gstat
\&  /usr/bin/gmetric
\&  /usr/sbin/gmond
\&  /usr/sbin/gmetad
.Ve
.PP
If you installed ganglia using RPMs then these files will be installed when you install
the \s-1RPM\s0.  The \s-1RPM\s0 is installed simply by running
.PP
.Vb 1
\&  % rpm -Uvh ganglia-monitor-core-2.5.5.tar.gz
.Ve
.PP
Once you have the necessary binaries installed, you can test your installation by running
.PP
.Vb 1
\&   % ./gmond
.Ve
.PP
This will start the ganglia monitoring daemon.  You should then be able to run
.PP
.Vb 1
\&   % telnet localhost 8649
.Ve
.PP
And get an \s-1XML\s0 description of the state of your machine (and any other hosts running gmond
at the time).
.PP
If you are installing by source on Linux, scripts are provided to start \f(CW\*(C`gmetad\*(C'\fR and \f(CW\*(C`gmond\*(C'\fR
at system startup.  They are easy to install from the source root.
.PP
.Vb 6
\&   % cp ./gmond/gmond.init /etc/rc.d/init.d/gmond
\&   % chkconfig --add gmond
\&   % chkconfig --list gmond
\&     gmond              0:off   1:off   2:on    3:on    4:on    5:on    6:off
\&   % /etc/rc.d/init.d/gmond start
\&     Starting GANGLIA gmond:                                    [  OK  ]
.Ve
.PP
Repeat this step with gmetad.
.Sh "\s-1PHP\s0 Web Frontend Installation"
.IX Subsection "PHP Web Frontend Installation"
.IP "1." 4
Unzip the webfrontend distribution in your website tree. This is often under the directory 
\&\f(CW\*(C`/var/www/html\*(C'\fR, however look for the variable \f(CW\*(C`DocumentRoot\*(C'\fR in your Apache configuration 
files to be sure. All the \s-1PHP\s0 script files use relative URLs in their links, so you may 
place the \f(CW\*(C`gmetad\-webfrontend/\*(C'\fR directory anywhere convenient. I like to unzip *tar.gz 
files with one tar command:
.Sp
.Vb 2
\&  % cd /var/www/html
\&  % tar xvzf gmetad-webfrontend-2.5.0.tar.gz
.Ve
.IP "2." 4
Ensure your webserver understands how to process \s-1PHP\s0 script files. Currently, the 
web frontend contains certain php language that requires \s-1PHP\s0 version 4 or greater. 
Processing \s-1PHP\s0 script files usually requires a webserver module, such as the 
\&\f(CW\*(C`mod_php\*(C'\fR for the popular Apache webserver. In RedHat Linux, the \s-1RPM\s0 package that 
provides this module is called simply \*(L"php\*(R".
.Sp
For Apache, \f(CW\*(C`mod_php\*(C'\fR module must be enabled. The following lines should appear 
somewhere in Apache's *conf files. This example applies to RedHat and Mandrake 
Linux. The actual filenames may vary on your system. If you installed the php 
module using an \s-1RPM\s0 package, this work will have been done automatically.
.Sp
.Vb 4
\&  <IfDefine HAVE_PHP4>
\&  LoadModule php4_module    extramodules/libphp4.so
\&  AddModule mod_php4.c
\&  </IfDefine>
.Ve
.Sp
.Vb 2
\&  AddType  application/x-httpd-php         .php .php4 .php3 .phtml
\&  AddType  application/x-httpd-php-source  .phps
.Ve
.IP "3." 4
The webfrontend requires the existance of the gmetad package on the webserver. 
Follow the installation instructions on the gmetad page. Specifically, the webfrontend 
requires the rrdtool and the \f(CW\*(C`rrds/\*(C'\fR directory from gmetad. If you are a power user, 
you may use \s-1NFS\s0 to simulate the local existance of the rrds.
.IP "4." 4
Test your installation. Visit the \s-1URL:\s0
.Sp
.Vb 1
\&  http://localhost/gmetad-webfrontend/
.Ve
.Sp
With a web\-browser, where localhost is the address of your webserver.
.PP
Installation of the web frontend is simplified on Linux by using rpm.
.PP
.Vb 3
\&  % rpm -Uvh gmetad-webfrontend-2.5.5-1.i386.rpm
\&  Preparing...                ########################################### [100%]
\&     1:gmetad-webfrontend     ########################################### [100%]
.Ve
.SH "Configuration"
.IX Header "Configuration"
.Sh "Gmond Configuration"
.IX Subsection "Gmond Configuration"
While the default options for gmond will work for most clusters, gmond is very 
flexible and can be customize with the configuration file: \f(CW\*(C`/etc/gmond.conf\*(C'\fR.
.PP
\&\f(CW\*(C`/etc/gmond.conf\*(C'\fR is not required as its absence will only cause gmond to start 
in a default configuration. Here is a sample of a gmond.conf configuration file
with comment to help you configure gmond
.PP
.Vb 113
\&   # $Id: ganglia.pod,v 1.2 2003/11/06 04:51:11 massie Exp $
\&   # This is the configuration file for the Ganglia Monitor Daemon (gmond)
\&   # Documentation can be found at http://ganglia.sourceforge.net/docs/
\&   #
\&   # To change a value from it's default simply uncomment the line
\&   # and alter the value
\&   #####################
\&   #
\&   # The name of the cluster this node is a part of
\&   # default: "unspecified"
\&   # name  "My Cluster"
\&   #
\&   # The owner of this cluster. Represents an administrative
\&   # domain. The pair name/owner should be unique for all clusters
\&   # in the world.
\&   # default: "unspecified"
\&   # owner "My Organization"
\&   #
\&   # The latitude and longitude GPS coordinates of this cluster on earth.
\&   # Specified to 1 mile accuracy with two decimal places per axis in Decimal
\&   # DMS format: "N61.18 W130.50".
\&   # default: "unspecified"
\&   # latlong "N32.87 W117.22"
\&   #
\&   # The URL for more information on the Cluster. Intended to give purpose,
\&   # owner, administration, and account details for this cluster.
\&   # default: "unspecified"
\&   # url "http://www.mycluster.edu/"
\&   #
\&   # The location of this host in the cluster. Given as a 3D coordinate:
\&   # "Rack,Rank,Plane" that corresponds to a Euclidean coordinate "x,y,z".
\&   # default: "unspecified"
\&   # location "0,0,0"
\&   #
\&   # The multicast channel for gmond to send/receive data on
\&   # default: 239.2.11.71
\&   # mcast_channel 239.2.11.71
\&   #
\&   # The multicast port for gmond to send/receive data on
\&   # default: 8649
\&   # mcast_port    8649
\&   #
\&   # The multicast interface for gmond to send/receive data on
\&   # default: the kernel decides based on routing configuration
\&   # mcast_if  eth1
\&   #
\&   # The multicast Time-To-Live (TTL) for outgoing messages
\&   # default: 1
\&   # mcast_ttl  1
\&   #
\&   # The number of threads listening to multicast traffic
\&   # default: 2
\&   # mcast_threads 2
\&   #
\&   # Which port should gmond listen for XML requests on
\&   # default: 8649
\&   # xml_port     8649
\&   #
\&   # The number of threads answering XML requests
\&   # default: 2
\&   # xml_threads   2
\&   #
\&   # Hosts ASIDE from "127.0.0.1"/localhost and those multicasting
\&   # on the same multicast channel which you will share your XML
\&   # data with.  Multiple hosts are allowed on multiple lines.
\&   # Can be specified with either hostnames or IP addresses.
\&   # default: none
\&   # trusted_hosts 1.1.1.1 1.1.1.2 1.1.1.3 \e
\&   # 2.3.2.3 3.4.3.4 5.6.5.6
\&   #
\&   # The number of nodes in your cluster.  This value is used in the
\&   # creation of the cluster hash.
\&   # default: 1024
\&   # num_nodes  1024
\&   #
\&   # The number of custom metrics this gmond will be storing.  This
\&   # value is used in the creation of the host custom_metrics hash.
\&   # default: 16
\&   # num_custom_metrics 16
\&   #
\&   # Run gmond in "mute" mode.  Gmond will only listen to the multicast
\&   # channel but will not send any data on the channel.
\&   # default: off
\&   # mute on
\&   #
\&   # Run gmond in "deaf" mode.  Gmond will only send data on the multicast
\&   # channel but will not listen/store any data from the channel.
\&   # default: off
\&   # deaf on
\&   #
\&   # Run gmond in "debug" mode.  Gmond will not background.  Debug messages
\&   # are sent to stdout.  Value from 0-100.  The higher the number the more
\&   # detailed debugging information will be sent.
\&   # default: 0
\&   # debug_level 10
\&   #
\&   # If you don't want gmond to setuid, set this to "on"
\&   # default: off
\&   # no_setuid  on
\&   #
\&   # Which user should gmond run as?
\&   # default: nobody
\&   # setuid     nobody
\&   #
\&   # If you do not want this host to appear in the gexec host list, set
\&   # this value to "on"
\&   # default: off
\&   # no_gexec   on
\&   #
\&   # If you want any host which connects to the gmond XML to receive
\&   # data, then set this value to "on"
\&   # default: off
\&   # all_trusted on
.Ve
.PP
If you want to customize the operation of gmond, simply edit this file and save it to 
\&\f(CW\*(C`/etc/gmond.conf\*(C'\fR. You can create multiple gmond configurations by writing the 
configuration file to a different file, say \f(CW\*(C`/etc/gmond_test.conf\*(C'\fR, and the using the 
\&\f(CW\*(C`\-\-conf\*(C'\fR option of gmond to specify which configuration file to use.
.PP
.Vb 1
\&  % ./gmond --conf=/etc/gmond_test.conf
.Ve
.PP
would start gmond with the settings in /etc/gmond_test.conf
.Sh "Gmetad Configuration"
.IX Subsection "Gmetad Configuration"
The behavior of the Ganglia Meta Daemon is completely controlled by a single configuration 
file which is by default \f(CW\*(C`/etc/gmetad.conf\*(C'\fR. For gmetad to do anything useful you much 
specify at least one \f(CW\*(C`data_source\*(C'\fR in the configuration. The format of the data_source 
line is as follows
.PP
.Vb 2
\&  data_source "Cluster A" 127.0.0.1  1.2.3.4:8655  1.2.3.5:8625
\&  data_source "Cluster B" 1.2.4.4:8655
.Ve
.PP
In this example, there are two unique data sources: \*(L"Cluster A\*(R" and \*(L"Cluster B\*(R". The 
Cluster A data source has three redundant sources. If gmetad cannot pull the data 
from the first source, it will continue trying the other sources in order.
.PP
If you do not specify a port number, gmetad will assume the default ganglia port which
is 8649 (U*N*I*X on a phone key pad)
.PP
Here is a sample gmetad configuration file with comments
.PP
.Vb 35
\&   # This is an example of a Ganglia Meta Daemon configuration file
\&   #                http://ganglia.sourceforge.net/
\&   #
\&   #-------------------------------------------------------------------------------
\&   # Setting the debug_level to 1 will keep daemon in the forground and
\&   # show only error messages. Setting this value higher than 1 will make 
\&   # gmetad output debugging information and stay in the foreground.
\&   # default: 0
\&   # debug_level 10
\&   #
\&   #-------------------------------------------------------------------------------
\&   # What to monitor. The most important section of this file. 
\&   #
\&   # The data_source tag specifies either a cluster or a grid to
\&   # monitor. If we detect the source is a cluster, we will maintain a complete
\&   # set of RRD databases for it, which can be used to create historical 
\&   # graphs of the metrics. If the source is a grid (it comes from another gmetad),
\&   # we will only maintain summary RRDs for it.
\&   #
\&   # Format: 
\&   # data_source "my cluster" [polling interval] address1:port addreses2:port ...
\&   # 
\&   # The keyword 'data_source' must immediately be followed by a unique
\&   # string which identifies the source, then an optional polling interval in 
\&   # seconds. The source will be polled at this interval on average. 
\&   # If the polling interval is omitted, 15sec is asssumed. 
\&   #
\&   # A list of machines which service the data source follows, in the 
\&   # format ip:port, or name:port. If a port is not specified then 8649
\&   # (the default gmond port) is assumed.
\&   # default: There is no default value
\&   #
\&   # data_source "my cluster" 10 localhost  my.machine.edu:8649  1.2.3.5:8655
\&   # data_source "my grid" 50 1.3.4.7:8655 grid.org:8651 grid-backup.org:8651
\&   # data_source "another source" 1.3.4.7:8655  1.3.4.8
.Ve
.PP
.Vb 1
\&   data_source "my cluster" localhost
.Ve
.PP
.Vb 66
\&   #
\&   #-------------------------------------------------------------------------------
\&   # Scalability mode. If on, we summarize over downstream grids, and respect
\&   # authority tags. If off, we take on 2.5.0-era behavior: we do not wrap our output
\&   # in <GRID></GRID> tags, we ignore all <GRID> tags we see, and always assume
\&   # we are the "authority" on data source feeds. This approach does not scale to
\&   # large groups of clusters, but is provided for backwards compatibility.
\&   # default: on
\&   # scalable off
\&   #
\&   #-------------------------------------------------------------------------------
\&   # The name of this Grid. All the data sources above will be wrapped in a GRID
\&   # tag with this name.
\&   # default: Unspecified
\&   # gridname "MyGrid"
\&   #
\&   #-------------------------------------------------------------------------------
\&   # The authority URL for this grid. Used by other gmetads to locate graphs
\&   # for our data sources. Generally points to a ganglia/
\&   # website on this machine.
\&   # default: "http://hostname/ganglia/",
\&   #   where hostname is the name of this machine, as defined by gethostname().
\&   # authority "http://mycluster.org/newprefix/"
\&   #
\&   #-------------------------------------------------------------------------------
\&   # List of machines this gmetad will share XML with. Localhost
\&   # is always trusted. 
\&   # default: There is no default value
\&   # trusted_hosts 127.0.0.1 169.229.50.165 my.gmetad.org
\&   #
\&   #-------------------------------------------------------------------------------
\&   # If you want any host which connects to the gmetad XML to receive
\&   # data, then set this value to "on"
\&   # default: off
\&   # all_trusted on
\&   #
\&   #-------------------------------------------------------------------------------
\&   # If you don't want gmetad to setuid then set this to off
\&   # default: on
\&   # setuid off
\&   #
\&   #-------------------------------------------------------------------------------
\&   # User gmetad will setuid to (defaults to "nobody")
\&   # default: "nobody"
\&   # setuid_username "nobody"
\&   #
\&   #-------------------------------------------------------------------------------
\&   # The port gmetad will answer requests for XML
\&   # default: 8651
\&   # xml_port 8651
\&   #
\&   #-------------------------------------------------------------------------------
\&   # The port gmetad will answer queries for XML. This facility allows
\&   # simple subtree and summation views of the XML tree.
\&   # default: 8652
\&   # interactive_port 8652
\&   #
\&   #-------------------------------------------------------------------------------
\&   # The number of threads answering XML requests
\&   # default: 4
\&   # server_threads 10
\&   #
\&   #-------------------------------------------------------------------------------
\&   # Where gmetad stores its round-robin databases
\&   # default: "/var/lib/ganglia/rrds"
\&   # rrd_rootdir "/some/other/place"
.Ve
.PP
\&\f(CW\*(C`gmetad\*(C'\fR has a \f(CW\*(C`\-\-conf\*(C'\fR option to allow you to specify alternate configuration files
.PP
.Vb 1
\&  % ./gmetad -conf=/tmp/my_custom_config.conf
.Ve
.Sh "\s-1PHP\s0 Web Frontend Configuration"
.IX Subsection "PHP Web Frontend Configuration"
Most configuration parameters reside in the \f(CW\*(C`gmetad\-webfrontend/conf.php\*(C'\fR file. Here you 
may alter the template, gmetad location, RRDtool location, and set the default time range 
and metrics for graphs.
.PP
The static portions of the Ganglia website are themable. This means you can alter elements 
such as section lables, some links, and images to suit your individual tastes and environment. 
The \f(CW\*(C`template_name\*(C'\fR variable names a directory containing the current theme. Ganglia uses 
TemplatePower to implement themes. A user-defined skin must conform to the template interface 
as defined by the default theme. Essentially, the variable names and \s-1START/END\s0 blocks in a 
custom theme must remain the same as the default, but all other \s-1HTML\s0 elements may be changed.
.PP
Other configuration variables in \f(CW\*(C`conf.php\*(C'\fR specify the location of gmetad's files, and where 
to find the rrdtool program. These locations need only be changed if you do not run gmetad on 
the webserver. Otherwise the default locations should work fine. The \f(CW\*(C`default_range\*(C'\fR variable 
specifies what range of time to show on the graphs by default, with possible values of hour, 
day, week, month, year. The \f(CW\*(C`default_metric\*(C'\fR parameter specifies which metric to show on 
the cluster view page by default.
.SH "Commandline Tools"
.IX Header "Commandline Tools"
There are two commandline tools that work with \f(CW\*(C`gmond\*(C'\fR to add custom metrics and
query the current state of a cluster: \f(CW\*(C`gmetric\*(C'\fR and \f(CW\*(C`gstat\*(C'\fR respectively.
.Sh "Gmetric"
.IX Subsection "Gmetric"
The \fBGanglia Metric Tool (gmetric)\fR allows you to easily monitor any arbitrary 
host metrics that you like expanding on the core metrics that gmond measures by default.
.PP
If you want help with the gmetric sytax, simply use the \*(L"help\*(R" commandline option
.PP
.Vb 2
\&  % gmetric --help
\&    gmetric 2.5.5
.Ve
.PP
.Vb 4
\&   Purpose:
\&     The Ganglia Metric Client (gmetric) announces a metric
\&     value to all Ganglia Monitoring Daemons (gmonds) that are listening
\&     on the cluster multicast channel.
.Ve
.PP
.Vb 14
\&   Usage: gmetric [OPTIONS]...
\&      -h         --help                  Print help and exit
\&      -V         --version               Print version and exit
\&      -nSTRING   --name=STRING           Name of the metric
\&      -vSTRING   --value=STRING          Value of the metric
\&      -tSTRING   --type=STRING           Either string|int8|uint8|int16|uint16|int32|uint32|float|double
\&      -uSTRING   --units=STRING          Unit of measure for the value e.g. Kilobytes, Celcius
\&      -sSTRING   --slope=STRING          Either zero|positive|negative|both (default='both')
\&      -xINT      --tmax=INT              The maximum time in seconds between gmetric calls (default=60)
\&      -dINT      --dmax=INT              The lifetime in seconds of this metric (default=0)
\&      -cSTRING   --mcast_channel=STRING  Multicast channel to send/receive on (default='239.2.11.71')
\&      -pINT      --mcast_port=INT        Multicast port to send/receive on (default=8649)
\&      -iSTRING   --mcast_if=STRING       Network interface to multicast on e.g. 'eth1' (default='kernel decides') 
\&      -lINT      --mcast_ttl=INT         Multicast Time-To-Live (TTL) (default=1)
.Ve
.PP
The gmetric tool formats a special multicast message and sends it to all gmonds that are listening.
.PP
All metrics in ganglia have a name, value, type and optionally units. For example, say I wanted 
to measure the temperature of my \s-1CPU\s0 (something gmond doesn't do by default) then I could 
multicast this metric with name=\*(L"temperature\*(R", value=\*(L"63\*(R", type=\*(L"int16\*(R" and units=\*(L"Celcius\*(R".
.PP
Assume I have a program called \f(CW\*(C`cputemp\*(C'\fR which outputs in text the temperature of the \s-1CPU\s0
.PP
.Vb 2
\&  % cputemp
\&  63
.Ve
.PP
I could easily send this data to all listening gmonds by running
.PP
.Vb 1
\&  % gmetric --name temperature --value `cputemp` --type int16 --units Celcius
.Ve
.PP
Check the exit value of gmetric to see if it successfully sent the data: 0 on success and \-1 on failure.
.PP
To constantly sample this temperature metric, you just need too add this command to your cron table.
.Sh "Gstat"
.IX Subsection "Gstat"
The Ganglia Cluster Status Tool (gstat) is a commandline utility that allows you to get status 
report for your cluster. 
.PP
To get help with the commandline options, simply pass \f(CW\*(C`gstat\*(C'\fR the \f(CW\*(C`\-\-help\*(C'\fR option
.PP
.Vb 2
\&  % gstat --help
\&  gstat 2.5.5
.Ve
.PP
.Vb 4
\&  Purpose:
\&    The Ganglia Status Client (gstat) connects with a
\&    Ganglia Monitoring Daemon (gmond) and output a load-balanced list
\&    of cluster hosts
.Ve
.PP
.Vb 10
\&  Usage: gstat [OPTIONS]...
\&     -h         --help             Print help and exit
\&     -V         --version          Print version and exit
\&     -a         --all              List all hosts.  Not just hosts running gexec (default=off)
\&     -d         --dead             Print only the hosts which are dead (default=off)
\&     -m         --mpifile          Print a load-balanced mpifile (default=off)
\&     -1         --single_line      Print host and information all on one line (default=off)
\&     -l         --list             Print ONLY the host list (default=off)
\&     -iSTRING   --gmond_ip=STRING  Specify the ip address of the gmond to query (default='127.0.0.1')
\&     -pINT      --gmond_port=INT   Specify the gmond port to query (default=8649)
.Ve
.SH "Troubleshooting (FAQ)"
.IX Header "Troubleshooting (FAQ)"
.IP "\fBSolaris, \s-1IRIX\s0, Tru64\fR" 4
.IX Item "Solaris, IRIX, Tru64"
Here is an email from Steve Wagner about the state of the ganglia on Solaris, 
\&\s-1IRIX\s0 and Tru64. Steve is to thank for porting ganglia to Solaris and Tru64. He also 
helped with the \s-1IRIX\s0 port.
.Sp
.Vb 1
\&   State of the IRIX port:
.Ve
.Sp
.Vb 9
\&   *  CPU percentage stuff hasn't improved despite my efforts.  I fear there
\&      may be a flaw in the way I'm summing counters for all the CPUs.
\&   *  Auto-detection of network interfaces apparently segfaults.
\&   *  Memory and load reporting appear to be running properly.
\&   *  CPU speed is not being reported properly on multi-proc machines.
\&   *  Total/running processes are not reported.
\&   *  gmetad untested.
\&   *  Monitoring core apparently stable in foreground, background being tested
\&   (had a segfault earlier).
.Ve
.Sp
.Vb 1
\&   State of the Tru64 port:
.Ve
.Sp
.Vb 5
\&   *  CPU percentage stuff here works perfectly.
\&   *  Memory and swap usage stats are suspected to be inaccurate.
\&   *  Total/running processes are not reported.
\&   *  gmetad untested.
\&   *  Monitoring core apparently stable in foreground and background.
.Ve
.Sp
.Vb 10
\&   State of the Solaris port:
\&   *  CPU percentages are slightly off, but correct enough for trending
\&      purposes.
\&   *  Load, ncpus, CPU speed, breads/writes, lreads/writes, phreads/writes,
\&      and rcache/wcache are all accurate.
\&   *  Memory/swap statistics are suspiciously flat, but local stats bear
\&      this out (and they *are* being updated) so I haven't investigated
\&      further.
\&   *  Total processes are counted, but not running ones.
\&   *  gmetad appears stable
.Ve
.Sp
.Vb 4
\&   Anyway, all three ports I've been messing with are usable and fairly
\&   stable.  Although there are areas for improvement I think we really can't
\&   keep hogging all this good stuff - what I'm looking at is ready for
\&   release.
.Ve
.IP "\fBDebian Users\fR" 4
.IX Item "Debian Users"
Here is an email message from Preston Smith for Debian users
.Sp
.Vb 6
\& Debian packages for Debian 3.0 (woody) are available at
\&  http://www.physics.purdue.edu/~psmith/ganglia
\& (i386, sparc, and powerpc are there presently, more architectures will
\&  appear when I get them built.)
\& Packages for "unstable" (sid) will be available in the main Debian
\&  archive soon.
.Ve
.Sp
.Vb 2
\& Also, a CVS note: I checked in the debian/ directory used to create
\& debian packages.
.Ve
.IP "\fBMultihomed Machines\fR" 4
.IX Item "Multihomed Machines"
Here is an email that Matt Massie sent to a user having problems with
multihomed machines
.Sp
.Vb 2
\&   i need to add a section in the documentation talking about this since it 
\&   seems to be a common question.
.Ve
.Sp
.Vb 1
\&   when you use...
.Ve
.Sp
.Vb 1
\&   mcast_if eth1
.Ve
.Sp
.Vb 4
\&   .. in /etc/gmond.conf that tells gmond to send its data out the "eth1"
\&   network interface but that doesn't necessarily mean that the source
\&   address of the packets will match the "eth1" interface.  to make sure that
\&   data sent out eth1 has the correct source address run the following...
.Ve
.Sp
.Vb 1
\&   % route add -host 239.2.11.71 dev eth1
.Ve
.Sp
.Vb 1
\&   ... before starting gmond.  that should do the trick for you.
.Ve
.Sp
.Vb 1
\&   -matt
.Ve
.Sp
.Vb 44
\&   > I have seen some post related to some issues
\&   > with gmond + multicast running on a dual nic
\&   > frontend.
\&   > 
\&   > Currently I am experiencing a weird behavior
\&   > 
\&   > I have the following setup:
\&   > 
\&   >   -----------------------
\&   >   | web server + gmetad |
\&   >   -----------------------
\&   >              |
\&   >              |
\&   >              |
\&   >     ----------------------
\&   >     |   eth0 A.B.C.112   |
\&   >     |                    |
\&   >     |  Frontend + gmond  |
\&   >     |                    |
\&   >     | eth1 192.168.100.1 |
\&   >     ----------------------
\&   >              |
\&   >              |
\&   > 
\&   >        26 nodes each
\&   >           gmond
\&   > 
\&   > In the frontend /etc/gmond.conf I have the
\&   > following statement: mcast_if  eth1
\&   > 
\&   > The 26 nodes are correctly reported. 
\&   > 
\&   > However the Frontend is never reported.
\&   > 
\&   > I am running iptables on the Frontend, and I am seing
\&   > things like:
\&   > 
\&   > INPUT packet died: IN=eth1 OUT= MAC= SRC=A.B.C.112 DST=239.2.11.71 
\&   > LEN=36 TOS=0x00 PREC=0x00 TTL=1 ID=53740 DF PROTO=UDP SPT=41608 DPT=8649
\&   > LEN=16 
\&   > 
\&   > I would have expected the source to be 192.168.100.1 with mcast_if eth1
\&   > 
\&   > Any idea ?
.Ve
.IP "\fBCisco Catalyst Switches\fR" 4
.IX Item "Cisco Catalyst Switches"
Perhaps information regarding gmond on networks set up through cisco
catalyst switches should be mentioned in the ganglia documentation. I think
by default multicast traffic on the catalyst will flood all devices unless
configured properly. Here is a relavent snipet from a message forum, with a
link to cisco document.
.Sp
If what you are trying to do, is minimizing the impact on your network due
to a multicast application, this link may describe what you want to do:
http://www.cisco.com/warp/public/473/38.html
.Sp
We set up our switches according to this after a consultant came in and
installed an application multicasting several hundred packets per second.
This made the network functional again.
.SH "Getting Support"
.IX Header "Getting Support"
.Vb 4
\&  The tired and thirsty prospector threw himself down at the edge of the 
\&  watering hole and started to drink. But then he looked around and saw 
\&  skulls and bones everywhere. "Uh-oh," he thought. "This watering hole 
\&  is reserved for skeletons." --Jack Handey
.Ve
.PP
There are three mailing lists available to you: \f(CW\*(C`ganglia\-general\*(C'\fR, \f(CW\*(C`ganglia\-developers\*(C'\fR and 
\&\f(CW\*(C`ganglia\-announce\*(C'\fR.  You can join these lists or read their archives by 
visiting https://sourceforge.net/mail/?group_id=43021
.PP
When you need help please follow these steps until your problem is resolved.
.IP "1." 4
completely read the documentation
.IP "2." 4
check the \f(CW\*(C`ganglia\-general\*(C'\fR archive to see if other people have had the same problem
.IP "3." 4
post your support request to the \f(CW\*(C`ganglia\-general\*(C'\fR mailing list
.IP "4." 4
check the \f(CW\*(C`ganglia\-developers\*(C'\fR archive
.IP "5." 4
post your question to the \f(CW\*(C`ganglia\-developers\*(C'\fR list
.PP
please send all bugs, patches, and feature requests to the \f(CW\*(C`ganglia\-developers\*(C'\fR list 
after you have checked the \f(CW\*(C`ganglia\-developers\*(C'\fR archive to see if the question has 
already been asked and answered.
.SH "Copyright"
.IX Header "Copyright"
.Vb 1
\&  Copyright (C) 2002,2003 University of California, Berkeley
.Ve
.PP
The ganglia source tree incorporated great source code from other projects as well.
.PP
.Vb 6
\&  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
\&  Copyright (C) 1999,2000,2001,2002 Lukas Schroeder <lukas@azzit.de>,
\&   and others.
\&  Copyright (C) 1991, 1992, 1996, 1998, 1999 Free Software Foundation, Inc.
\&  Copyright (C) 2000  David Helder
\&  Copyright (C) 2000  Andrew Lanoix
.Ve
.SH "Authors"
.IX Header "Authors"
.Vb 1
\&  Matt Massie <massie@CS.Berkeley.EDU>
.Ve
.PP
and the \fBGanglia Development Team\fR...
.PP
.Vb 14
\& Bas van der Vlies      basv               Developer    basv at users.sourceforge.net 
\& Neil T. Spring         bluehal            Developer    bluehal at users.sourceforge.net
\& Brooks Davis           brooks_en_davis    Developer    brooks_en_davis at users.sourceforge.net
\& Eric Fraser            fraze              Developer    fraze at users.sourceforge.net 
\& greg bruno             gregbruno          Developer    gregbruno at users.sourceforge.net
\& Jeff Layton            laytonjb        Developer       laytonjb at users.sourceforge.net       
\& Doc Schneider          maddocbuddha    Developer       maddocbuddha at users.sourceforge.net 
\& Mason Katz             masonkatz       Developer       masonkatz at users.sourceforge.net      
\& Mike Howard            mhoward         Developer       mhoward at users.sourceforge.net        
\& Oliver Mössinger      olivpass        Developer       olivpass at users.sourceforge.net       
\& Preston Smith          pmsmith         Developer       pmsmith at users.sourceforge.net        
\& Federico David Sacerdoti sacerdoti     Developer       sacerdoti at users.sourceforge.net      
\& Tim Cera               timcera         Developer       timcera at users.sourceforge.net        
\& Mathew Benson          wintermute11    Developer       wintermute11 at users.sourceforge.net
.Ve
.SH "Contributors"
.IX Header "Contributors"
There have been dozens of contributors who have provided patches and helpful bug reports.  
We need to list them here later.
