#
# $Id: ganglia.spec.in,v 1.13 2003/11/07 19:56:50 massie Exp $
#
# ganglia.spec.  Generated from ganglia.spec.in by configure.
#
Summary: Ganglia Cluster Toolkit http://ganglia.sourceforge.net/
Name: ganglia-monitor-core
Version: 2.5.7
Release: 1 
Copyright: BSD
Vendor: Ganglia Development Team <ganglia-developers@lists.sourceforge.net>
Group: System Environment/Base
Source: %{name}-%{version}.tar.gz
Buildroot: /tmp/%{name}-%{version}-buildroot
Prefix: /usr

%description
Ganglia is a scalable, real-time monitoring and execution environment
with all execution requests and statistics expressed in an open
well-defined XML format.


%package gmetad
Summary: Ganglia Meta daemon http://ganglia.sourceforge.net/
Group: System Environment/Base
Obsoletes: ganglia-monitor-core

%description gmetad
Ganglia is a scalable, real-time monitoring and execution environment
with all execution requests and statistics expressed in an open
well-defined XML format.

This gmetad daemon can aggregate monitoring data from several clusters
to form a monitoring grid. It also keeps metric history using the RRD tool.


%package gmond
Summary: Ganglia Monitor daemon http://ganglia.sourceforge.net/
Group: System Environment/Base
Obsoletes: ganglia-monitor-core

%description gmond
Ganglia is a scalable, real-time monitoring and execution environment
with all execution requests and statistics expressed in an open
well-defined XML format.

This gmond daemon provides the ganglia service within a single cluster or
Multicast domain.


%package lib
Summary: Ganglia Toolkit Library http://ganglia.sourceforge.net/
Group: System Environment/Base

%description lib
The Ganglia Monitoring Core library provides a set of functions that programmers
can use to build scalable cluster or grid applications

##
## PREP
##

%prep 
%setup

##
## BUILD
##
%build
./configure --with-gmetad --prefix=/usr
make

##
## PRE
##
%pre

##
## POST GMETA
##
%post gmetad
/sbin/chkconfig --add gmetad

if [ "$1" == "1" ]; then
   # Installing new package - start gmond
   /etc/rc.d/init.d/gmetad start
elif [ "$1" > "1" ]; then
   # Upgrading ganglia package - restart gmond
   /etc/rc.d/init.d/gmetad restart
fi


##
## POST GMON
##
%post gmond
/sbin/chkconfig --add gmond

if [ "$1" == "1" ]; then
   # Installing new package - start gmond
   /etc/rc.d/init.d/gmond start
elif [ "$1" > "1" ]; then
   # Upgrading ganglia package - restart gmond
   /etc/rc.d/init.d/gmond restart
fi


##
## PREUN GMETA
##
%preun gmetad
if [ "$1" = 0 ]
then
   /etc/rc.d/init.d/gmetad stop
   /sbin/chkconfig --del gmetad
fi

##
## PREUN GMON
##
%preun gmond
if [ "$1" = 0 ]
then
   /etc/rc.d/init.d/gmond stop
   /sbin/chkconfig --del gmond
fi

##
## INSTALL
##
%install
%__mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
%__mkdir -p $RPM_BUILD_ROOT/usr/include/ganglia
%__mkdir -p $RPM_BUILD_ROOT/var/lib/ganglia/rrds
%__cp -f %{_builddir}/%{name}-%{version}/gmond/gmond.init $RPM_BUILD_ROOT/etc/rc.d/init.d/gmond
%__cp -f %{_builddir}/%{name}-%{version}/gmetad/gmetad.init $RPM_BUILD_ROOT/etc/rc.d/init.d/gmetad
%__cp -f %{_builddir}/%{name}-%{version}/gmond/gmond.conf $RPM_BUILD_ROOT/etc/gmond.conf
%__cp -f %{_builddir}/%{name}-%{version}/gmetad/gmetad.conf $RPM_BUILD_ROOT/etc/gmetad.conf
%__make install prefix=$RPM_BUILD_ROOT/usr

##
## FILES GMETA
##
%files gmetad
%defattr(-,root,root)
%attr(0755,nobody,nobody)/var/lib/ganglia/rrds
/usr/sbin/gmetad
/etc/rc.d/init.d/gmetad
%config(noreplace) /etc/gmetad.conf

##
## FILES GMON
##
%files gmond
%defattr(-,root,root)
%attr(0500,root,root)/usr/bin/gmetric
%attr(0555,root,root)/usr/bin/gstat
/usr/sbin/gmond
/etc/rc.d/init.d/gmond
%config(noreplace) /etc/gmond.conf

%files lib
/usr/include/ganglia.h
/usr/include/ganglia
/usr/lib/libganglia*

##
## CLEAN
##
%clean
%__rm -rf $RPM_BUILD_ROOT

##
## CHANGELOG
##
%changelog
* Mon Oct 14 2002 Federico Sacerdoti <fds@sdsc.edu>
- Split package into -gmetad and -gmond subpackages for clarity,
  and separation of purpose/functionality.
* Thu Sep 19 2002 Federico Sacerdoti <fds@sdsc.edu>
- Added config files, made /var/lib/ganglia for RRD storage.
* Mon Mar 11 2002 Matt Massie <massie@cs.berkeley.edu>
- Added support for libganglia, added Prefix: for RPM relocation
* Wed Feb 27 2002 Matt Massie <massie@cs.berkeley.edu>
- Merge gmetric and gmond together into one RPM.  Fix some small bugs.
* Fri Nov  2 2001 Matt Massie <massie@cs.berkeley.edu>
- initial release
