import sys
import os
import gobject
import gtk

import apt
import apt.cache

from gapti.GladeWindow import GladeWindow

class SoftwarePackageWindow(GladeWindow):
    
    def __init__(self, path, domain=None):
        """Base class for Dialogs whose controls are loaded from Glade definitions.
           Does most of the work of loading the Glade file and reparenting the
           widgets."""
        root = 'package_selection_window'
        GladeWindow.__init__(self, path, root, domain)
        
        self.configure_package_treeview()
        
    def configure_package_treeview(self):
        # Initialize the TreeStore used to hold package information.
        self.package_treestore = gtk.TreeStore('gboolean', str, str, str)
        self.package_treeview.set_model(self.package_treestore)
        
        # Two columns.
        instCol = gtk.TreeViewColumn('')
        descCol = gtk.TreeViewColumn('Package')
        sizeCol = gtk.TreeViewColumn('Size')
        self.package_treeview.append_column(instCol)
        self.package_treeview.append_column(descCol)
        self.package_treeview.append_column(sizeCol)
        
        # Renderers.
        instCell = gtk.CellRendererToggle()
        descCell = gtk.CellRendererText()
        sizeCell = gtk.CellRendererText()
        instCol.pack_start(instCell, False)
        descCol.pack_start(descCell, False)
        sizeCol.pack_start(sizeCell, False)
        
        # Hook up columns to store.
        instCol.add_attribute(instCell, 'active', 0)
        descCol.add_attribute(descCell, 'text', 1)
        sizeCol.add_attribute(sizeCell, 'text', 2)
        
        # Various properties of the TreeView.
        self.package_treeview.set_expander_column(descCol)
        
        instCell.connect('toggled', self.package_inst_toggled)
        
    def package_inst_toggled(self, cell, path):
        iter = self.package_treestore.get_iter(path)
        inst = self.package_treestore.get_value(iter, 0)
        self.package_treestore.set_value(iter, 0, not inst)
        return
        
    def set_packages(self, packages):
        """Binds the package treeview to the specified packages."""
        cache = apt.Cache()
        pkgs = []
        for pkg in packages:
            pkgs.append(cache[pkg])
            
        # At this point we have a list of top-level packages. These go on the
        # TreeView and are not unselectable. For each one, we start a recursive
        # function on each of it's Recommends.
        added_pkgs = {}
        for pkg in pkgs:
            inst = True
            desc = pkg.summary
            size = pkg.packageSize
            name = pkg.name
            data = [inst, desc, size, name]
            row = self.package_treestore.append(None, data)
            added_pkgs[name] = pkg
            self.add_package_children(cache, pkg, row, 'Recommends', added_pkgs)
            self.add_package_children(cache, pkg, row, 'Suggests', added_pkgs)
            
        self.package_treeview.expand_all()
            
    def add_package_children(self, cache, pkg, row, key, added_pkgs):
        candver = cache._depcache.GetCandidateVer(pkg._pkg)
        if candver == None:
            return
        dependslist = candver.DependsList
        if dependslist.has_key(key):
            for depVerList in dependslist[key]:
                for dep in depVerList:
                    if cache.has_key(dep.TargetPkg.Name):
                        if pkg.name != dep.TargetPkg.Name and dep.TargetPkg.Name not in added_pkgs:
                            pkg = cache[dep.TargetPkg.Name]
                            if key == 'Recommends':
                                inst = True
                            else:
                                inst = False
                            desc = pkg.summary
                            size = pkg.packageSize
                            name = pkg.name
                            data = [inst, desc, size, name]
                            row2 = self.package_treestore.append(row, data)
                            added_pkgs[name] = pkg
                            self.add_package_children(cache, pkg, row2, 'Recommends', added_pkgs)
                            self.add_package_children(cache, pkg, row2, 'Suggests', added_pkgs)
                            
    def get_package_selections(self):
        pkgs = []
        self.package_treestore.foreach(self.package_treestore_sum, pkgs)
        return pkgs
    
    def package_treestore_sum(self, model, path, iter, user_data):
        name = model.get_value(iter, 3)
        inst = model.get_value(iter, 0)
        if inst == True:
            user_data.append(name)
        return False
    
gobject.type_register(SoftwarePackageWindow)
