/* This is a cut-down version of UNP64 with only the bare minimum
 * needed to decompress a number of Commodore 64 adventure games.
 * It is distributed under the zlib License by kind permission of
 * the original authors Magnus Lind and iAN CooG.
 */

/*
UNP64 - generic Commodore 64 prg unpacker
(C) 2008-2022 iAN CooG/HVSC Crew^C64Intros
original source and idea: testrun.c, taken from exo20b7

Follows original disclaimer
*/

/*
 * Copyright (c) 2002 - 2023 Magnus Lind.
 *
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 * claim that you wrote the original software. If you use this software
 * in a product, an acknowledgment in the product documentation would be
 * appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 */

/*
 C++ version based on code adapted to ScummVM by Avijeet Maurya
 */

#include "unp64.h"

namespace Unp64 {

void scnAbuzeCrunch(UnpStr *unp);
void scnActionPacker(UnpStr *unp);
void scnByteBoiler(UnpStr *unp);
void scnCaution(UnpStr *unp);
void scnCCS(UnpStr *unp);
void scnCruel(UnpStr *unp);
void scnECA(UnpStr *unp);
void scnExpert(UnpStr *unp);
void scnExomizer(UnpStr *unp);
void scnFinalSuperComp(UnpStr *unp);
void scnIntros(UnpStr *unp);
void scnMasterCompressor(UnpStr *unp);
void scnMegabyte(UnpStr *unp);
void scnMrCross(UnpStr *unp);
void scnMrZ(UnpStr *unp);
void scnPuCrunch(UnpStr *unp);
void scnSection8(UnpStr *unp);
void scnTBCMultiComp(UnpStr *unp);
void scnTCScrunch(UnpStr *unp);
void scnTimeCruncher(UnpStr *unp);
void scnXTC(UnpStr *unp);

Scnptr g_scanFunc[] = {
	scnAbuzeCrunch,
	scnByteBoiler,
	scnECA,
	scnExpert,
	scnFinalSuperComp,
	scnIntros,
	scnCruel,
	scnPuCrunch,
	scnMasterCompressor,
	scnMrCross,
	scnMrZ,
	scnTCScrunch,
	scnTBCMultiComp,
    scnTimeCruncher,
	scnXTC,
	scnCCS,
	scnMegabyte,
	scnSection8,
	scnCaution,
	scnActionPacker,
	scnExomizer
};

void scanners(UnpStr *unp) {
	int x, y;
	y = sizeof(g_scanFunc) / sizeof(*g_scanFunc);
	for (x = 0; x < y; x++) {
		(g_scanFunc[x])(unp);
		if (unp->_idFlag)
			break;
	}
}

} // End of namespace Unp64
