/* Copyright (C) 2000 Damir Zucic */

/*=============================================================================

				pattern.c

Purpose:
	Execute pattern command:  define the residue pattern. Residue
	pattern is relatively short, but more flexible than sequence.
	More than one residue may be specified at the given position.
	The length of pattern is fixed, i.e. deletions and insertions
	are not allowed. Asterisk may be used to allow any residue at
	the given position.

Input:
	(1) Pointer to MolComplexS structure.
	(2) The number of macromolecular complexes.
	(3) Pointer to RuntimeS structure.
	(4) Pointer to the string with command parameters.

Output:
	(1) Pattern stored to the pattern buffer.
	(2) Return value.

Return value:
	(1) Positive (command) code on success.
	(2) Negative (error) code on failure.

Notes:
	(1) The pattern is expected in three letters code. One letter
	    code may be missinterpreted  as valid three letters code.

========includes:============================================================*/

#include <stdio.h>

#include <string.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include "defines.h"
#include "commands.h"
#include "typedefs.h"

/*======function prototypes:=================================================*/



/*======execute pattern command:=============================================*/

int Pattern_ (MolComplexS *mol_complexSP, int mol_complexesN,
	      RuntimeS *runtimeSP, char *stringP)
{

/*@@*/ /* Not implemented yet! */

/*@@*/ /* RuntimeS  allready has  reserved storage  for patterns: */
/*@@*/ /* pattern_buffer_size, pattern_length, *patternP, namesNA */

/* Return the command code: */
return COMMAND_PATTERN;
}

/*===========================================================================*/


