/* sqlqueryres.h
 *
 * Copyright (C) 1999,2000,2001 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __SQL_QUERY_RES__
#define __SQL_QUERY_RES__

#include <gtk/gtksignal.h>
#include <gtk/gtkobject.h>
#include <GDA.h>
#include <gda-connection.h>
#include <gda-recordset.h>

#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */

#define SQL_QUERY_RES(obj)          GTK_CHECK_CAST (obj, sql_query_res_get_type(), SqlQueryRes)
#define SQL_QUERY_RES_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_query_res_get_type (), SqlQueryResClass)
#define IS_SQL_QUERY_RES(obj)       GTK_CHECK_TYPE (obj, sql_query_res_get_type ())


	typedef struct _Sqlqueryres SqlQueryRes;
	typedef struct _SqlqueryresClass SqlQueryResClass;

	/* struct for the object's data */
	struct _Sqlqueryres
	{
		GtkObject object;

		GdaRecordset *recset;
		gint current_row;
		guint nbtuples;
		GString *query;	/* FIXME: is it really used? */
	};

	/* struct for the object's class */
	struct _SqlqueryresClass
	{
		GtkObjectClass parent_class;

		void (*dummy) (SqlQueryRes * qres);	/* unused */
	};

	/* generic widget's functions */
	guint sql_query_res_get_type (void);
	GtkObject *sql_query_res_new (GdaRecordset * res);
	void sql_query_res_free (SqlQueryRes * qres);

	/* other functions for this object */
	gint sql_query_res_get_nbtuples (SqlQueryRes * qres);
	gint sql_query_res_get_nbcols (SqlQueryRes * qres);
	/* rows in [1..N] and cols in [0..N-1] */
	/* gchar* IS allocated! */
	gchar *sql_query_res_get_item (SqlQueryRes * qres,
				       guint row, guint col);
	GdaField *sql_query_res_get_gdafield (SqlQueryRes * qres,
					      guint row, guint col);

	/* convenience function, mem allocated or NULL */
	gchar *sql_query_res_stringify (GdaField * field);
	gchar *sql_query_res_get_col_name (SqlQueryRes * qres, gint col);
	void sql_query_res_dump (SqlQueryRes * qres);


	/* creates a GSList with each node pointing to a string which appears
	   in the tabular.
	   the created list will have to be freed, as well as its strings contents.
	   WARNING: only one dimension tabulars allowed! */
	GSList *sql_query_res_convert_tabular_to_list (gchar * tab);

#ifdef __cplusplus
}
#endif				/* __cplusplus */

#endif
