;;;
;;; gauche.vm.insn - VM instruction introspection
;;; (This file is generated automatically; DO NOT EDIT)
;;;  
;;;   Copyright (c) 2004-2005 Shiro Kawai, All rights reserved.
;;;   
;;;   Redistribution and use in source and binary forms, with or without
;;;   modification, are permitted provided that the following conditions
;;;   are met:
;;;   
;;;   1. Redistributions of source code must retain the above copyright
;;;      notice, this list of conditions and the following disclaimer.
;;;  
;;;   2. Redistributions in binary form must reproduce the above copyright
;;;      notice, this list of conditions and the following disclaimer in the
;;;      documentation and/or other materials provided with the distribution.
;;;  
;;;   3. Neither the name of the authors nor the names of its contributors
;;;      may be used to endorse or promote products derived from this
;;;      software without specific prior written permission.
;;;  
;;;   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
;;;   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
;;;   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
;;;   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
;;;   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
;;;   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
;;;   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
;;;   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
;;;   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;;   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;;   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;;;  
;;;  $Id: insn.scm.src,v 1.3 2005/08/23 04:33:56 shirok Exp $
;;;

(define-module gauche.vm.insn
  (use util.match)
  (export <vm-insn-info>
          vm-find-insn-info
          vm-build-insn)
  )
(select-module gauche.vm.insn)

(define-class <vm-insn-info> ()
  ((name   :init-keyword :name)           ; name of insn (symbol)
   (code   :init-keyword :code)           ; code of insn (integer)
   (num-params :init-keyword :num-params) ; # of parameters
   (operand-type :init-keyword :operand-type) ; operand type
   (combined :init-keyword :combined)     ; combined insns
   
   (all-insns :allocation :class          ; alist of all instructions,
              :init-value '())            ;   keyed by name.
   ))

(define-method initialize ((self <vm-insn-info>) initargs)
  (next-method)
  (push! (ref self 'all-insns)
         (cons (ref self 'name) self)))

;; opcode mnemonic -> <vm-insn-info>
(define (vm-find-insn-info mnemonic)
  (cond ((assq mnemonic (class-slot-ref <vm-insn-info> 'all-insns)) => cdr)
        (else (error "No such VM instruction:" mnemonic))))

;; INSN is a list of opcode and parameters, e.g. (PUSH) or (LREF 3 2)
;; Returns an exact integer of encoded VM instruction code.
;; NB: This must match the macro definitions in src/gauche/vm.h !!!
(define (vm-build-insn insn)
  (match insn
    (((? symbol? opcode) . params)
     (let1 info (vm-find-insn-info opcode)
       (match params
         (()
          (unless (= (ref info 'num-params) 0)
            (errorf "VM instruction ~a takes no parameters, but got ~s"
                    opcode insn))
          (ref info 'code))
         ((arg0)
          (unless (= (ref info 'num-params) 1)
            (errorf "VM instruction ~a takes one parameter, but got ~s"
                    opcode insn))
          (logior (ash (logand arg0 #xffffff) 8)
                  (ref info 'code)))
         ((arg0 arg1)
          (unless (= (ref info 'num-params) 2)
            (errorf "VM instruction ~a takes two parameters, but got ~s"
                    opcode insn))
          (logior (ash (logand arg1 #x3ff) 18)
                  (ash (logand arg0 #x3ff) 8)
                  (ref info 'code)))
         (else (error "vm-build-insn: bad insn:" insn)))))
    (else
     (error "vm-build-insn: bad insn:" insn))))

;; #x000  NOP
(make <vm-insn-info> :name 'NOP :code 0
  :num-params 0 :operand-type 'none
  :combined '())

;; #x001  CONST
(make <vm-insn-info> :name 'CONST :code 1
  :num-params 0 :operand-type 'obj
  :combined '())

;; #x002  CONSTI
(make <vm-insn-info> :name 'CONSTI :code 2
  :num-params 1 :operand-type 'none
  :combined '())

;; #x003  CONSTN
(make <vm-insn-info> :name 'CONSTN :code 3
  :num-params 0 :operand-type 'none
  :combined '())

;; #x004  CONSTF
(make <vm-insn-info> :name 'CONSTF :code 4
  :num-params 0 :operand-type 'none
  :combined '())

;; #x005  CONSTU
(make <vm-insn-info> :name 'CONSTU :code 5
  :num-params 0 :operand-type 'none
  :combined '())

;; #x006  CONST-PUSH
(make <vm-insn-info> :name 'CONST-PUSH :code 6
  :num-params 0 :operand-type 'obj
  :combined '(CONST PUSH))

;; #x007  CONSTI-PUSH
(make <vm-insn-info> :name 'CONSTI-PUSH :code 7
  :num-params 1 :operand-type 'none
  :combined '(CONSTI PUSH))

;; #x008  CONSTN-PUSH
(make <vm-insn-info> :name 'CONSTN-PUSH :code 8
  :num-params 0 :operand-type 'none
  :combined '(CONSTN PUSH))

;; #x009  CONSTF-PUSH
(make <vm-insn-info> :name 'CONSTF-PUSH :code 9
  :num-params 0 :operand-type 'none
  :combined '(CONSTF PUSH))

;; #x00a  CONST-RET
(make <vm-insn-info> :name 'CONST-RET :code 10
  :num-params 0 :operand-type 'obj
  :combined '(CONST RET))

;; #x00b  CONSTF-RET
(make <vm-insn-info> :name 'CONSTF-RET :code 11
  :num-params 0 :operand-type 'none
  :combined '(CONSTF RET))

;; #x00c  CONSTU-RET
(make <vm-insn-info> :name 'CONSTU-RET :code 12
  :num-params 0 :operand-type 'none
  :combined '(CONSTU RET))

;; #x00d  PUSH
(make <vm-insn-info> :name 'PUSH :code 13
  :num-params 0 :operand-type 'none
  :combined '())

;; #x00e  PRE-CALL
(make <vm-insn-info> :name 'PRE-CALL :code 14
  :num-params 1 :operand-type 'addr
  :combined '())

;; #x00f  PUSH-PRE-CALL
(make <vm-insn-info> :name 'PUSH-PRE-CALL :code 15
  :num-params 1 :operand-type 'addr
  :combined '(PUSH PRE-CALL))

;; #x010  CHECK-STACK
(make <vm-insn-info> :name 'CHECK-STACK :code 16
  :num-params 1 :operand-type 'none
  :combined '())

;; #x011  CALL
(make <vm-insn-info> :name 'CALL :code 17
  :num-params 1 :operand-type 'none
  :combined '())

;; #x012  TAIL-CALL
(make <vm-insn-info> :name 'TAIL-CALL :code 18
  :num-params 1 :operand-type 'none
  :combined '())

;; #x013  JUMP
(make <vm-insn-info> :name 'JUMP :code 19
  :num-params 0 :operand-type 'addr
  :combined '())

;; #x014  RET
(make <vm-insn-info> :name 'RET :code 20
  :num-params 0 :operand-type 'none
  :combined '())

;; #x015  DEFINE
(make <vm-insn-info> :name 'DEFINE :code 21
  :num-params 1 :operand-type 'obj
  :combined '())

;; #x016  CLOSURE
(make <vm-insn-info> :name 'CLOSURE :code 22
  :num-params 0 :operand-type 'code
  :combined '())

;; #x017  LOCAL-ENV
(make <vm-insn-info> :name 'LOCAL-ENV :code 23
  :num-params 1 :operand-type 'none
  :combined '())

;; #x018  PUSH-LOCAL-ENV
(make <vm-insn-info> :name 'PUSH-LOCAL-ENV :code 24
  :num-params 1 :operand-type 'none
  :combined '(PUSH LOCAL-ENV))

;; #x019  LOCAL-ENV-CLOSURES
(make <vm-insn-info> :name 'LOCAL-ENV-CLOSURES :code 25
  :num-params 1 :operand-type 'codes
  :combined '())

;; #x01a  POP-LOCAL-ENV
(make <vm-insn-info> :name 'POP-LOCAL-ENV :code 26
  :num-params 0 :operand-type 'none
  :combined '())

;; #x01b  LOCAL-ENV-JUMP
(make <vm-insn-info> :name 'LOCAL-ENV-JUMP :code 27
  :num-params 1 :operand-type 'addr
  :combined '())

;; #x01c  LOCAL-ENV-CALL
(make <vm-insn-info> :name 'LOCAL-ENV-CALL :code 28
  :num-params 1 :operand-type 'none
  :combined '())

;; #x01d  LOCAL-ENV-TAIL-CALL
(make <vm-insn-info> :name 'LOCAL-ENV-TAIL-CALL :code 29
  :num-params 1 :operand-type 'none
  :combined '())

;; #x01e  BF
(make <vm-insn-info> :name 'BF :code 30
  :num-params 0 :operand-type 'addr
  :combined '())

;; #x01f  BT
(make <vm-insn-info> :name 'BT :code 31
  :num-params 0 :operand-type 'addr
  :combined '())

;; #x020  BNEQ
(make <vm-insn-info> :name 'BNEQ :code 32
  :num-params 0 :operand-type 'addr
  :combined '())

;; #x021  BNEQV
(make <vm-insn-info> :name 'BNEQV :code 33
  :num-params 0 :operand-type 'addr
  :combined '())

;; #x022  BNNULL
(make <vm-insn-info> :name 'BNNULL :code 34
  :num-params 0 :operand-type 'addr
  :combined '())

;; #x023  BNUMNE
(make <vm-insn-info> :name 'BNUMNE :code 35
  :num-params 0 :operand-type 'addr
  :combined '())

;; #x024  BNLT
(make <vm-insn-info> :name 'BNLT :code 36
  :num-params 0 :operand-type 'addr
  :combined '())

;; #x025  BNLE
(make <vm-insn-info> :name 'BNLE :code 37
  :num-params 0 :operand-type 'addr
  :combined '())

;; #x026  BNGT
(make <vm-insn-info> :name 'BNGT :code 38
  :num-params 0 :operand-type 'addr
  :combined '())

;; #x027  BNGE
(make <vm-insn-info> :name 'BNGE :code 39
  :num-params 0 :operand-type 'addr
  :combined '())

;; #x028  BNUMNEI
(make <vm-insn-info> :name 'BNUMNEI :code 40
  :num-params 1 :operand-type 'addr
  :combined '())

;; #x029  BNEQC
(make <vm-insn-info> :name 'BNEQC :code 41
  :num-params 0 :operand-type 'obj+addr
  :combined '())

;; #x02a  BNEQVC
(make <vm-insn-info> :name 'BNEQVC :code 42
  :num-params 0 :operand-type 'obj+addr
  :combined '())

;; #x02b  RF
(make <vm-insn-info> :name 'RF :code 43
  :num-params 0 :operand-type 'none
  :combined '())

;; #x02c  RT
(make <vm-insn-info> :name 'RT :code 44
  :num-params 0 :operand-type 'none
  :combined '())

;; #x02d  RNEQ
(make <vm-insn-info> :name 'RNEQ :code 45
  :num-params 0 :operand-type 'none
  :combined '())

;; #x02e  RNEQV
(make <vm-insn-info> :name 'RNEQV :code 46
  :num-params 0 :operand-type 'none
  :combined '())

;; #x02f  RNNULL
(make <vm-insn-info> :name 'RNNULL :code 47
  :num-params 0 :operand-type 'none
  :combined '())

;; #x030  RECEIVE
(make <vm-insn-info> :name 'RECEIVE :code 48
  :num-params 2 :operand-type 'addr
  :combined '())

;; #x031  TAIL-RECEIVE
(make <vm-insn-info> :name 'TAIL-RECEIVE :code 49
  :num-params 2 :operand-type 'none
  :combined '())

;; #x032  LSET
(make <vm-insn-info> :name 'LSET :code 50
  :num-params 2 :operand-type 'none
  :combined '())

;; #x033  LSET0
(make <vm-insn-info> :name 'LSET0 :code 51
  :num-params 0 :operand-type 'none
  :combined '())

;; #x034  LSET1
(make <vm-insn-info> :name 'LSET1 :code 52
  :num-params 0 :operand-type 'none
  :combined '())

;; #x035  LSET2
(make <vm-insn-info> :name 'LSET2 :code 53
  :num-params 0 :operand-type 'none
  :combined '())

;; #x036  LSET3
(make <vm-insn-info> :name 'LSET3 :code 54
  :num-params 0 :operand-type 'none
  :combined '())

;; #x037  LSET4
(make <vm-insn-info> :name 'LSET4 :code 55
  :num-params 0 :operand-type 'none
  :combined '())

;; #x038  GSET
(make <vm-insn-info> :name 'GSET :code 56
  :num-params 0 :operand-type 'obj
  :combined '())

;; #x039  LREF
(make <vm-insn-info> :name 'LREF :code 57
  :num-params 2 :operand-type 'none
  :combined '())

;; #x03a  LREF0
(make <vm-insn-info> :name 'LREF0 :code 58
  :num-params 0 :operand-type 'none
  :combined '())

;; #x03b  LREF1
(make <vm-insn-info> :name 'LREF1 :code 59
  :num-params 0 :operand-type 'none
  :combined '())

;; #x03c  LREF2
(make <vm-insn-info> :name 'LREF2 :code 60
  :num-params 0 :operand-type 'none
  :combined '())

;; #x03d  LREF3
(make <vm-insn-info> :name 'LREF3 :code 61
  :num-params 0 :operand-type 'none
  :combined '())

;; #x03e  LREF10
(make <vm-insn-info> :name 'LREF10 :code 62
  :num-params 0 :operand-type 'none
  :combined '())

;; #x03f  LREF11
(make <vm-insn-info> :name 'LREF11 :code 63
  :num-params 0 :operand-type 'none
  :combined '())

;; #x040  LREF12
(make <vm-insn-info> :name 'LREF12 :code 64
  :num-params 0 :operand-type 'none
  :combined '())

;; #x041  LREF20
(make <vm-insn-info> :name 'LREF20 :code 65
  :num-params 0 :operand-type 'none
  :combined '())

;; #x042  LREF21
(make <vm-insn-info> :name 'LREF21 :code 66
  :num-params 0 :operand-type 'none
  :combined '())

;; #x043  LREF30
(make <vm-insn-info> :name 'LREF30 :code 67
  :num-params 0 :operand-type 'none
  :combined '())

;; #x044  LREF4
(make <vm-insn-info> :name 'LREF4 :code 68
  :num-params 0 :operand-type 'none
  :combined '())

;; #x045  LREF13
(make <vm-insn-info> :name 'LREF13 :code 69
  :num-params 0 :operand-type 'none
  :combined '())

;; #x046  LREF14
(make <vm-insn-info> :name 'LREF14 :code 70
  :num-params 0 :operand-type 'none
  :combined '())

;; #x047  LREF-PUSH
(make <vm-insn-info> :name 'LREF-PUSH :code 71
  :num-params 2 :operand-type 'none
  :combined '(LREF PUSH))

;; #x048  LREF0-PUSH
(make <vm-insn-info> :name 'LREF0-PUSH :code 72
  :num-params 0 :operand-type 'none
  :combined '(LREF0 PUSH))

;; #x049  LREF1-PUSH
(make <vm-insn-info> :name 'LREF1-PUSH :code 73
  :num-params 0 :operand-type 'none
  :combined '(LREF1 PUSH))

;; #x04a  LREF2-PUSH
(make <vm-insn-info> :name 'LREF2-PUSH :code 74
  :num-params 0 :operand-type 'none
  :combined '(LREF2 PUSH))

;; #x04b  LREF3-PUSH
(make <vm-insn-info> :name 'LREF3-PUSH :code 75
  :num-params 0 :operand-type 'none
  :combined '(LREF3 PUSH))

;; #x04c  LREF10-PUSH
(make <vm-insn-info> :name 'LREF10-PUSH :code 76
  :num-params 0 :operand-type 'none
  :combined '(LREF10 PUSH))

;; #x04d  LREF11-PUSH
(make <vm-insn-info> :name 'LREF11-PUSH :code 77
  :num-params 0 :operand-type 'none
  :combined '(LREF11 PUSH))

;; #x04e  LREF12-PUSH
(make <vm-insn-info> :name 'LREF12-PUSH :code 78
  :num-params 0 :operand-type 'none
  :combined '(LREF12 PUSH))

;; #x04f  LREF20-PUSH
(make <vm-insn-info> :name 'LREF20-PUSH :code 79
  :num-params 0 :operand-type 'none
  :combined '(LREF20 PUSH))

;; #x050  LREF21-PUSH
(make <vm-insn-info> :name 'LREF21-PUSH :code 80
  :num-params 0 :operand-type 'none
  :combined '(LREF21 PUSH))

;; #x051  LREF30-PUSH
(make <vm-insn-info> :name 'LREF30-PUSH :code 81
  :num-params 0 :operand-type 'none
  :combined '(LREF30 PUSH))

;; #x052  LREF4-PUSH
(make <vm-insn-info> :name 'LREF4-PUSH :code 82
  :num-params 0 :operand-type 'none
  :combined '())

;; #x053  LREF13-PUSH
(make <vm-insn-info> :name 'LREF13-PUSH :code 83
  :num-params 0 :operand-type 'none
  :combined '())

;; #x054  LREF14-PUSH
(make <vm-insn-info> :name 'LREF14-PUSH :code 84
  :num-params 0 :operand-type 'none
  :combined '())

;; #x055  GREF
(make <vm-insn-info> :name 'GREF :code 85
  :num-params 0 :operand-type 'obj
  :combined '())

;; #x056  GREF-PUSH
(make <vm-insn-info> :name 'GREF-PUSH :code 86
  :num-params 0 :operand-type 'obj
  :combined '(GREF PUSH))

;; #x057  GREF-CALL
(make <vm-insn-info> :name 'GREF-CALL :code 87
  :num-params 1 :operand-type 'obj
  :combined '(GREF CALL))

;; #x058  GREF-TAIL-CALL
(make <vm-insn-info> :name 'GREF-TAIL-CALL :code 88
  :num-params 1 :operand-type 'obj
  :combined '(GREF TAIL-CALL))

;; #x059  PUSH-GREF
(make <vm-insn-info> :name 'PUSH-GREF :code 89
  :num-params 0 :operand-type 'obj
  :combined '(PUSH GREF))

;; #x05a  PUSH-GREF-CALL
(make <vm-insn-info> :name 'PUSH-GREF-CALL :code 90
  :num-params 1 :operand-type 'obj
  :combined '(PUSH GREF CALL))

;; #x05b  PUSH-GREF-TAIL-CALL
(make <vm-insn-info> :name 'PUSH-GREF-TAIL-CALL :code 91
  :num-params 1 :operand-type 'obj
  :combined '(PUSH GREF TAIL-CALL))

;; #x05c  LREF0-PUSH-GREF
(make <vm-insn-info> :name 'LREF0-PUSH-GREF :code 92
  :num-params 0 :operand-type 'obj
  :combined '(LREF0 PUSH GREF))

;; #x05d  LREF0-PUSH-GREF-CALL
(make <vm-insn-info> :name 'LREF0-PUSH-GREF-CALL :code 93
  :num-params 1 :operand-type 'obj
  :combined '(LREF0 PUSH GREF CALL))

;; #x05e  LREF0-PUSH-GREF-TAIL-CALL
(make <vm-insn-info> :name 'LREF0-PUSH-GREF-TAIL-CALL :code 94
  :num-params 1 :operand-type 'obj
  :combined '(LREF0 PUSH GREF TAIL-CALL))

;; #x05f  PROMISE
(make <vm-insn-info> :name 'PROMISE :code 95
  :num-params 0 :operand-type 'none
  :combined '())

;; #x060  CONST-APPLY
(make <vm-insn-info> :name 'CONST-APPLY :code 96
  :num-params 1 :operand-type 'obj
  :combined '())

;; #x061  CONS
(make <vm-insn-info> :name 'CONS :code 97
  :num-params 0 :operand-type 'none
  :combined '())

;; #x062  CONS-PUSH
(make <vm-insn-info> :name 'CONS-PUSH :code 98
  :num-params 0 :operand-type 'none
  :combined '(CONS PUSH))

;; #x063  CAR
(make <vm-insn-info> :name 'CAR :code 99
  :num-params 0 :operand-type 'none
  :combined '())

;; #x064  CAR-PUSH
(make <vm-insn-info> :name 'CAR-PUSH :code 100
  :num-params 0 :operand-type 'none
  :combined '(CAR PUSH))

;; #x065  CDR
(make <vm-insn-info> :name 'CDR :code 101
  :num-params 0 :operand-type 'none
  :combined '())

;; #x066  CDR-PUSH
(make <vm-insn-info> :name 'CDR-PUSH :code 102
  :num-params 0 :operand-type 'none
  :combined '(CDR PUSH))

;; #x067  CAAR
(make <vm-insn-info> :name 'CAAR :code 103
  :num-params 0 :operand-type 'none
  :combined '())

;; #x068  CAAR-PUSH
(make <vm-insn-info> :name 'CAAR-PUSH :code 104
  :num-params 0 :operand-type 'none
  :combined '(CAAR PUSH))

;; #x069  CADR
(make <vm-insn-info> :name 'CADR :code 105
  :num-params 0 :operand-type 'none
  :combined '())

;; #x06a  CADR-PUSH
(make <vm-insn-info> :name 'CADR-PUSH :code 106
  :num-params 0 :operand-type 'none
  :combined '(CADR PUSH))

;; #x06b  CDAR
(make <vm-insn-info> :name 'CDAR :code 107
  :num-params 0 :operand-type 'none
  :combined '())

;; #x06c  CDAR-PUSH
(make <vm-insn-info> :name 'CDAR-PUSH :code 108
  :num-params 0 :operand-type 'none
  :combined '(CDAR PUSH))

;; #x06d  CDDR
(make <vm-insn-info> :name 'CDDR :code 109
  :num-params 0 :operand-type 'none
  :combined '())

;; #x06e  CDDR-PUSH
(make <vm-insn-info> :name 'CDDR-PUSH :code 110
  :num-params 0 :operand-type 'none
  :combined '(CDDR PUSH))

;; #x06f  LIST
(make <vm-insn-info> :name 'LIST :code 111
  :num-params 1 :operand-type 'none
  :combined '())

;; #x070  LIST-STAR
(make <vm-insn-info> :name 'LIST-STAR :code 112
  :num-params 1 :operand-type 'none
  :combined '())

;; #x071  LENGTH
(make <vm-insn-info> :name 'LENGTH :code 113
  :num-params 0 :operand-type 'none
  :combined '())

;; #x072  MEMQ
(make <vm-insn-info> :name 'MEMQ :code 114
  :num-params 0 :operand-type 'none
  :combined '())

;; #x073  MEMV
(make <vm-insn-info> :name 'MEMV :code 115
  :num-params 0 :operand-type 'none
  :combined '())

;; #x074  ASSQ
(make <vm-insn-info> :name 'ASSQ :code 116
  :num-params 0 :operand-type 'none
  :combined '())

;; #x075  ASSV
(make <vm-insn-info> :name 'ASSV :code 117
  :num-params 0 :operand-type 'none
  :combined '())

;; #x076  EQ
(make <vm-insn-info> :name 'EQ :code 118
  :num-params 0 :operand-type 'none
  :combined '())

;; #x077  EQV
(make <vm-insn-info> :name 'EQV :code 119
  :num-params 0 :operand-type 'none
  :combined '())

;; #x078  APPEND
(make <vm-insn-info> :name 'APPEND :code 120
  :num-params 1 :operand-type 'none
  :combined '())

;; #x079  NOT
(make <vm-insn-info> :name 'NOT :code 121
  :num-params 0 :operand-type 'none
  :combined '())

;; #x07a  REVERSE
(make <vm-insn-info> :name 'REVERSE :code 122
  :num-params 0 :operand-type 'none
  :combined '())

;; #x07b  APPLY
(make <vm-insn-info> :name 'APPLY :code 123
  :num-params 1 :operand-type 'none
  :combined '())

;; #x07c  TAIL-APPLY
(make <vm-insn-info> :name 'TAIL-APPLY :code 124
  :num-params 1 :operand-type 'none
  :combined '())

;; #x07d  IS-A
(make <vm-insn-info> :name 'IS-A :code 125
  :num-params 0 :operand-type 'none
  :combined '())

;; #x07e  NULLP
(make <vm-insn-info> :name 'NULLP :code 126
  :num-params 0 :operand-type 'none
  :combined '())

;; #x07f  PAIRP
(make <vm-insn-info> :name 'PAIRP :code 127
  :num-params 0 :operand-type 'none
  :combined '())

;; #x080  CHARP
(make <vm-insn-info> :name 'CHARP :code 128
  :num-params 0 :operand-type 'none
  :combined '())

;; #x081  EOFP
(make <vm-insn-info> :name 'EOFP :code 129
  :num-params 0 :operand-type 'none
  :combined '())

;; #x082  STRINGP
(make <vm-insn-info> :name 'STRINGP :code 130
  :num-params 0 :operand-type 'none
  :combined '())

;; #x083  SYMBOLP
(make <vm-insn-info> :name 'SYMBOLP :code 131
  :num-params 0 :operand-type 'none
  :combined '())

;; #x084  VECTORP
(make <vm-insn-info> :name 'VECTORP :code 132
  :num-params 0 :operand-type 'none
  :combined '())

;; #x085  IDENTIFIERP
(make <vm-insn-info> :name 'IDENTIFIERP :code 133
  :num-params 0 :operand-type 'none
  :combined '())

;; #x086  SETTER
(make <vm-insn-info> :name 'SETTER :code 134
  :num-params 0 :operand-type 'none
  :combined '())

;; #x087  VALUES
(make <vm-insn-info> :name 'VALUES :code 135
  :num-params 1 :operand-type 'none
  :combined '())

;; #x088  VEC
(make <vm-insn-info> :name 'VEC :code 136
  :num-params 1 :operand-type 'none
  :combined '())

;; #x089  LIST2VEC
(make <vm-insn-info> :name 'LIST2VEC :code 137
  :num-params 0 :operand-type 'none
  :combined '())

;; #x08a  APP-VEC
(make <vm-insn-info> :name 'APP-VEC :code 138
  :num-params 1 :operand-type 'none
  :combined '())

;; #x08b  VEC-LEN
(make <vm-insn-info> :name 'VEC-LEN :code 139
  :num-params 0 :operand-type 'none
  :combined '())

;; #x08c  VEC-REF
(make <vm-insn-info> :name 'VEC-REF :code 140
  :num-params 0 :operand-type 'none
  :combined '())

;; #x08d  VEC-SET
(make <vm-insn-info> :name 'VEC-SET :code 141
  :num-params 0 :operand-type 'none
  :combined '())

;; #x08e  VEC-REFI
(make <vm-insn-info> :name 'VEC-REFI :code 142
  :num-params 1 :operand-type 'none
  :combined '())

;; #x08f  VEC-SETI
(make <vm-insn-info> :name 'VEC-SETI :code 143
  :num-params 1 :operand-type 'none
  :combined '())

;; #x090  NUMEQ2
(make <vm-insn-info> :name 'NUMEQ2 :code 144
  :num-params 0 :operand-type 'none
  :combined '())

;; #x091  NUMLT2
(make <vm-insn-info> :name 'NUMLT2 :code 145
  :num-params 0 :operand-type 'none
  :combined '())

;; #x092  NUMLE2
(make <vm-insn-info> :name 'NUMLE2 :code 146
  :num-params 0 :operand-type 'none
  :combined '())

;; #x093  NUMGT2
(make <vm-insn-info> :name 'NUMGT2 :code 147
  :num-params 0 :operand-type 'none
  :combined '())

;; #x094  NUMGE2
(make <vm-insn-info> :name 'NUMGE2 :code 148
  :num-params 0 :operand-type 'none
  :combined '())

;; #x095  NUMADD2
(make <vm-insn-info> :name 'NUMADD2 :code 149
  :num-params 0 :operand-type 'none
  :combined '())

;; #x096  NUMSUB2
(make <vm-insn-info> :name 'NUMSUB2 :code 150
  :num-params 0 :operand-type 'none
  :combined '())

;; #x097  NUMMUL2
(make <vm-insn-info> :name 'NUMMUL2 :code 151
  :num-params 0 :operand-type 'none
  :combined '())

;; #x098  NUMDIV2
(make <vm-insn-info> :name 'NUMDIV2 :code 152
  :num-params 0 :operand-type 'none
  :combined '())

;; #x099  NEGATE
(make <vm-insn-info> :name 'NEGATE :code 153
  :num-params 0 :operand-type 'none
  :combined '())

;; #x09a  NUMIADD2
(make <vm-insn-info> :name 'NUMIADD2 :code 154
  :num-params 0 :operand-type 'none
  :combined '())

;; #x09b  NUMISUB2
(make <vm-insn-info> :name 'NUMISUB2 :code 155
  :num-params 0 :operand-type 'none
  :combined '())

;; #x09c  NUMIMUL2
(make <vm-insn-info> :name 'NUMIMUL2 :code 156
  :num-params 0 :operand-type 'none
  :combined '())

;; #x09d  NUMIDIV2
(make <vm-insn-info> :name 'NUMIDIV2 :code 157
  :num-params 0 :operand-type 'none
  :combined '())

;; #x09e  NUMADDI
(make <vm-insn-info> :name 'NUMADDI :code 158
  :num-params 1 :operand-type 'none
  :combined '())

;; #x09f  NUMSUBI
(make <vm-insn-info> :name 'NUMSUBI :code 159
  :num-params 1 :operand-type 'none
  :combined '())

;; #x0a0  READ-CHAR
(make <vm-insn-info> :name 'READ-CHAR :code 160
  :num-params 1 :operand-type 'none
  :combined '())

;; #x0a1  PEEK-CHAR
(make <vm-insn-info> :name 'PEEK-CHAR :code 161
  :num-params 1 :operand-type 'none
  :combined '())

;; #x0a2  WRITE-CHAR
(make <vm-insn-info> :name 'WRITE-CHAR :code 162
  :num-params 1 :operand-type 'none
  :combined '())

;; #x0a3  CURIN
(make <vm-insn-info> :name 'CURIN :code 163
  :num-params 0 :operand-type 'none
  :combined '())

;; #x0a4  CUROUT
(make <vm-insn-info> :name 'CUROUT :code 164
  :num-params 0 :operand-type 'none
  :combined '())

;; #x0a5  CURERR
(make <vm-insn-info> :name 'CURERR :code 165
  :num-params 0 :operand-type 'none
  :combined '())

;; #x0a6  SLOT-REF
(make <vm-insn-info> :name 'SLOT-REF :code 166
  :num-params 0 :operand-type 'none
  :combined '())

;; #x0a7  SLOT-SET
(make <vm-insn-info> :name 'SLOT-SET :code 167
  :num-params 0 :operand-type 'none
  :combined '())

;; #x0a8  SLOT-REFC
(make <vm-insn-info> :name 'SLOT-REFC :code 168
  :num-params 0 :operand-type 'obj
  :combined '())

;; #x0a9  SLOT-SETC
(make <vm-insn-info> :name 'SLOT-SETC :code 169
  :num-params 0 :operand-type 'obj
  :combined '())

;; #x0aa  RECEIVE-ALL
(make <vm-insn-info> :name 'RECEIVE-ALL :code 170
  :num-params 0 :operand-type 'addr
  :combined '())

;; #x0ab  TAIL-RECEIVE-ALL
(make <vm-insn-info> :name 'TAIL-RECEIVE-ALL :code 171
  :num-params 0 :operand-type 'none
  :combined '())

;; #x0ac  VALUES-N
(make <vm-insn-info> :name 'VALUES-N :code 172
  :num-params 0 :operand-type 'none
  :combined '())

;; #x0ad  PUSH-HANDLERS
(make <vm-insn-info> :name 'PUSH-HANDLERS :code 173
  :num-params 0 :operand-type 'none
  :combined '())

;; #x0ae  POP-HANDLERS
(make <vm-insn-info> :name 'POP-HANDLERS :code 174
  :num-params 0 :operand-type 'none
  :combined '())

(provide "gauche/vm/insn")
