#include "gauche.h"

static const char* script = "\n"
"#\n"
"# Makefile.in for Gauche/src\n"
"#  $Id: Makefile.in,v 1.150 2005/11/04 04:26:44 shirok Exp $\n"
"#\n"
"\n"
"# prelude ---------------------------------------------\n"
"\n"
".PHONY: all test check pre-package install uninstall \\\n"
"	clean distclean maintainer-clean install-check\n"
"\n"
".SUFFIXES:\n"
".SUFFIXES: .S .c .o .obj .s .stub .in .exe\n"
"\n"
".c.obj:\n"
"	$(COMPILE) -c `cygpath -w $<`\n"
"\n"
".c.o:\n"
"	$(COMPILE) -c $<\n"
"\n"
".s.o:\n"
"	$(COMPILE) -c $<\n"
"\n"
".S.o:\n"
"	$(COMPILE) -c $<\n"
"\n"
".stub.c:\n"
"	$(HOSTGOSH) ./genstub -D LIBGAUCHE_BODY $<\n"
"\n"
"SHELL       = @SHELL@\n"
"prefix      = @prefix@\n"
"exec_prefix = @exec_prefix@\n"
"bindir      = @bindir@\n"
"libdir      = @libdir@\n"
"srcdir      = @srcdir@\n"
"VPATH       = $(srcdir)\n"
"top_builddir = @top_builddir@\n"
"top_srcdir   = @top_srcdir@\n"
"\n"
"# These may be overridden by make invocators\n"
"DESTDIR  =\n"
"CC       = @CC@\n"
"AR       = @AR@\n"
"LIBS     = @LIBS@\n"
"CFLAGS   = @CFLAGS@ @SHLIB_SO_CFLAGS@\n"
"CPPFLAGS = @CPPFLAGS@\n"
"LDFLAGS  = @LDFLAGS@\n"
"\n"
"\n"
"# These are set by configure\n"
"DEFS     = @DEFS@\n"
"OPTFLAGS = @OPTFLAGS@\n"
"INCLUDES = -I$(srcdir) -I$(srcdir)/../gc/include @LOCAL_INC@\n"
"RANLIB   = @RANLIB@\n"
"OBJEXT   = @OBJEXT@\n"
"EXEEXT   = @EXEEXT@\n"
"SOEXT    = @SHLIB_DYLIB_SUFFIX@\n"
"LINK_HELPER = @LINK_HELPER@\n"
"RPATH_TMP  = @RPATH_TMP@\n"
"RPATH_REAL = @RPATH_REAL@\n"
"SONAME_FLAG = @SONAME_FLAG@\n"
"MAKEVERSLINK = @MAKEVERSLINK@\n"
"\n"
"# Main definition of compilation commands\n"
"COMPILE   = $(CC) $(DEFS) $(INCLUDES) $(CPPFLAGS) $(CFLAGS) $(OPTFLAGS)\n"
"MKINSTDIR = $(top_srcdir)/mkinstalldirs\n"
"CCLD      = $(LINK_HELPER) $(CC)\n"
"LINK      = TARGETLIB=`pwd` $(CCLD) $(CFLAGS) $(RPATH_TMP) -L. $(LDFLAGS)\n"
"RELINK    = TARGETLIB=$(TARGETLIB) $(CCLD) $(CFLAGS) $(RPATH_REAL) -L. $(LDFLAGS)\n"
"INSTALL   = @INSTALL@\n"
"POSTBUILD = TARGETLIB=`pwd` $(MAKEVERSLINK) libgauche.$(SOEXT)\n"
"POSTINSTALL = TARGETLIB=\"$(TARGETLIB)\" DESTDIR=\"$(DESTDIR)\" $(MAKEVERSLINK) libgauche.$(SOEXT)\n"
"\n"
"# HOSTGOSH is the gosh command used to generate some of the source files.\n"
"# We need to 'preload' some libraries from the host's environment, for\n"
"# they are compiled DSO as of 0.8.6 and the ones in the build tree can\n"
"# be incompatible with the host gosh.\n"
"# (NB: HOSTGOSH is used at creating tarball, so the builder from tarball\n"
"#  doesn't need to call it).\n"
"HOSTGOSH  = gosh -usrfi-1 -usrfi-13 -ufile.util -uutil.match -I$(top_srcdir)/src -I$(top_srcdir)/lib\n"
"\n"
"LIB_INSTALL_DIR  = @libdir@\n"
"BIN_INSTALL_DIR  = @bindir@\n"
"DATA_INSTALL_DIR = @datadir@\n"
"\n"
"GAUCHE_DATA_DIR = @datadir@/gauche\n"
"GAUCHE_ARCH_DIR = @libdir@/gauche\n"
"\n"
"HEADER_INSTALL_DIR    = $(GAUCHE_ARCH_DIR)/@GAUCHE_VERSION@/include\n"
"SCM_INSTALL_DIR       = $(GAUCHE_DATA_DIR)/@GAUCHE_VERSION@/lib\n"
"ARCH_INSTALL_DIR      = $(GAUCHE_ARCH_DIR)/@GAUCHE_VERSION@/@target@\n"
"SITE_SCM_DIR          = $(GAUCHE_DATA_DIR)/site/lib\n"
"SITE_ARCH_DIR         = $(GAUCHE_ARCH_DIR)/site/@GAUCHE_VERSION@/@target@\n"
"ARCH = @target@\n"
"\n"
"# targetlib is given when we relink the final version of gosh to embed\n"
"# the path to libgauche.  Usually it is LIB_INSTALL_DIR, but under\n"
"# certain circumstances (e.g. MacOSX framework build) it may be overridden.\n"
"TARGETLIB=$(LIB_INSTALL_DIR)\n"
"\n"
"INSTALL_HEADERS = gauche.h \\\n"
"	../gc/include/gc.h \\\n"
"	../gc/include/gc_config_macros.h \\\n"
"	../gc/include/gc_pthread_redirects.h\n"
"INSTALL_SUBHEADERS = gauche/config.h                                  \\\n"
"	 	     gauche/vm.h gauche/code.h gauche/vminsn.h        \\\n"
"                     gauche/char_euc_jp.h gauche/char_utf_8.h         \\\n"
"                     gauche/char_sjis.h gauche/char_none.h            \\\n"
"                     gauche/extend.h gauche/int64.h gauche/scmconst.h \\\n"
"                     gauche/class.h gauche/exception.h                \\\n"
"                     gauche/builtin-syms.h                            \\\n"
"                     gauche/pthread.h gauche/uthread.h gauche/arch.h  \\\n"
"	             gauche/mingw-compat.h\n"
"INSTALL_LIBS = libgauche.$(SOEXT)\n"
"INSTALL_BINS = gosh$(EXEEXT)           \\\n"
"	       gauche-config$(EXEEXT)  \\\n"
"               gauche-install$(EXEEXT) \\\n"
"	       gauche-package$(EXEEXT) \\\n"
"	       gauche-cesconv$(EXEEXT)\n"
"INSTALL_SCMS = gauche-init.scm genstub cesconv\n"
"\n"
"GENERATED_SCRIPTS = gauche-install gauche-package gauche-cesconv\n"
"\n"
"PRIVATE_HEADERS = gauche/arith.h \n"
"\n"
"# MinGW specific\n"
"INSTALL_MINGWHEADERS = gauche/mingw-compat.h\n"
"\n"
"# build -----------------------------------------------\n"
"\n"
"GCLIB = ../gc/libgc.la\n"
"\n"
"gosh_SOURCES = main.c\n"
"gosh_OBJECTS = main.$(OBJEXT)\n"
"gosh_LDADD   = -lgauche\n"
"gosh_LDFLAGS = @SHLIB_MAIN_LDFLAGS@\n"
"\n"
"libgauche_LIBRARY = libgauche.$(SOEXT)\n"
"libgauche_OBJECTS = \\\n"
"        core.$(OBJEXT) vm.$(OBJEXT) compaux.$(OBJEXT) macro.$(OBJEXT) \\\n"
"	code.$(OBJEXT) error.$(OBJEXT) class.$(OBJEXT) prof.$(OBJEXT) \\\n"
"	boolean.$(OBJEXT) char.$(OBJEXT) string.$(OBJEXT) list.$(OBJEXT) \\\n"
"	port.$(OBJEXT) hash.$(OBJEXT) write.$(OBJEXT) read.$(OBJEXT) \\\n"
"	vector.$(OBJEXT) weak.$(OBJEXT) symbol.$(OBJEXT) keyword.$(OBJEXT) \\\n"
"	compare.$(OBJEXT) regexp.$(OBJEXT) signal.$(OBJEXT) \\\n"
"	parameter.$(OBJEXT) module.$(OBJEXT) proc.$(OBJEXT) \\\n"
"	number.$(OBJEXT) bignum.$(OBJEXT) load.$(OBJEXT) paths.$(OBJEXT) \\\n"
"	promise.$(OBJEXT) repl.$(OBJEXT) autoloads.$(OBJEXT) \\\n"
"	system.$(OBJEXT) stdlib.$(OBJEXT) extlib.$(OBJEXT) exclib.$(OBJEXT) \\\n"
"	syslib.$(OBJEXT) moplib.$(OBJEXT) intlib.$(OBJEXT) compile.$(OBJEXT) \\\n"
"	scmlib.$(OBJEXT) objlib.$(OBJEXT)\n"
"libgauche_LDFLAGS = $(SONAME_FLAG) @SHLIB_DYLIB_LDFLAGS@\n"
"\n"
"HEADERS = gauche.h $(INSTALL_SUBHEADERS) $(PRIVATE_HEADERS)\n"
"\n"
"OBJECTS = $(libgauche_OBJECTS) $(gosh_OBJECTS)\n"
"\n"
"all : libgauche.$(SOEXT) $(INSTALL_BINS) $(GENERATED_SCRIPTS)\n"
"\n"
"gosh$(EXEEXT) : libgauche.$(SOEXT) $(gosh_OBJECTS) \n"
"	@rm -f gosh$(EXEEXT)\n"
"	$(LINK) $(gosh_LDFLAGS) -o gosh$(EXEEXT) $(gosh_OBJECTS) $(gosh_LDADD) $(LIBS)\n"
"\n"
"relink :\n"
"	$(RELINK) $(libgauche_LDFLAGS) libgauche.$(SOEXT) $(libgauche_OBJECTS) ../gc/*.lo $(LIBS)\n"
"	$(RELINK) $(gosh_LDFLAGS) -o gosh$(EXEEXT)  $(gosh_OBJECTS) $(gosh_LDADD) $(LIBS)\n"
"\n"
"$(OBJECTS) : $(HEADERS)\n"
"\n"
"stdlib.c : stdlib.stub genstub \n"
"extlib.c : extlib.stub genstub\n"
"exclib.c : exclib.stub genstub\n"
"syslib.c : syslib.stub genstub\n"
"moplib.c : moplib.stub genstub\n"
"intlib.c : intlib.stub genstub\n"
"\n"
"autoloads.c : autoloads.scm\n"
"	$(HOSTGOSH) ./autoloads.scm\n"
"\n"
"builtin-syms.c gauche/builtin-syms.h : builtin-syms.scm\n"
"	$(HOSTGOSH) ./builtin-syms.scm\n"
"\n"
"vminsn.c gauche/vminsn.h : vminsn.scm geninsn\n"
"	$(HOSTGOSH) ./geninsn\n"
"\n"
"compile.c : compile.scm gencomp vminsn.scm\n"
"	$(HOSTGOSH) ./gencomp compile.scm\n"
"\n"
"scmlib.c : scmlib.scm gencomp vminsn.scm\n"
"	$(HOSTGOSH) ./gencomp scmlib.scm\n"
"\n"
"objlib.c : objlib.scm gencomp vminsn.scm\n"
"	$(HOSTGOSH) ./gencomp objlib.scm\n"
"\n"
"symbol.$(OBJEXT) : builtin-syms.c\n"
"\n"
"port.$(OBJEXT) : port.c portapi.c\n"
"\n"
"vm.$(OBJEXT) : vminsn.c vmstat.c\n"
"\n"
"load.$(OBJEXT) : dl_dlopen.c dl_dummy.c dl_win.c dl_darwin.c\n"
"\n"
"paths.$(OBJEXT) : getdir_win.c getdir_dummy.c getdir_darwin.c\n"
"\n"
"libgauche.$(SOEXT) : $(libgauche_OBJECTS) $(GCLIB)\n"
"	$(LINK) $(libgauche_LDFLAGS) libgauche.$(SOEXT) $(libgauche_OBJECTS) ../gc/*.lo $(LIBS)\n"
"	$(POSTBUILD)\n"
"\n"
"gauche-config$(EXEEXT) : gauche-config.$(OBJEXT)\n"
"	$(LINK) -o gauche-config$(EXEEXT) gauche-config.$(OBJEXT) $(LIBS)\n"
"\n"
"gauche-config.c gauche/arch.h : genconfig\n"
"	$(SHELL) ./genconfig\n"
"\n"
"gauche-install : gauche-install.in\n"
"	@rm -f gauche-install\n"
"	echo \"#!$(BIN_INSTALL_DIR)/gosh\" > gauche-install && \\\n"
"	cat gauche-install.in >> gauche-install\n"
"	@chmod -w gauche-install\n"
"\n"
"gauche-package : gauche-package.in\n"
"	@rm -f gauche-package\n"
"	echo \"#!$(BIN_INSTALL_DIR)/gosh\" > gauche-package && \\\n"
"	cat gauche-package.in >> gauche-package\n"
"	@chmod -w gauche-package\n"
"\n"
"gauche-cesconv : gauche-cesconv.in\n"
"	@rm -f gauche-cesconv\n"
"	echo \"#!$(BIN_INSTALL_DIR)/gosh\" > gauche-cesconv && \\\n"
"	cat gauche-cesconv.in >> gauche-cesconv\n"
"	@chmod -w gauche-cesconv\n"
"\n"
"# tests -----------------------------------------------\n"
"TESTFILES = `cat ../test/TESTS`\n"
"\n"
"check : test\n"
"\n"
"test : gosh$(EXEEXT) test-vmstack$(EXEEXT) test-arith$(EXEEXT)\n"
"	@rm -f test.log\n"
"	./test-vmstack >> test.log\n"
"	./test-arith >> test.log\n"
"	@for testfile in $(TESTFILES); do \\\n"
"	  ./gosh -ftest -I../test $$testfile >> test.log; \\\n"
"	done\n"
"	@./gosh -ftest -e \"(define *case-fold* #f)\" ../test/symcase.scm >> test.log\n"
"	@./gosh -ftest -fcase-fold -e \"(define *case-fold* #t)\" ../test/symcase.scm >> test.log\n"
"	@echo \"See test.log for details.\"\n"
"\n"
"test-vmstack$(EXEEXT) : test-vmstack.$(OBJEXT) libgauche.$(SOEXT)\n"
"	$(LINK)	-o test-vmstack$(EXEEXT) test-vmstack.$(OBJEXT) $(gosh_LDADD) $(LIBS)\n"
"\n"
"test-arith$(EXEEXT) : test-arith.$(OBJEXT) libgauche.$(SOEXT)\n"
"	$(LINK)	-o test-arith$(EXEEXT) test-arith.$(OBJEXT) $(gosh_LDADD) $(LIBS)\n"
"\n"
"test-arith.$(OBJEXT) : gauche/arith.h\n"
"\n"
"install-check :\n"
"	@rm -rf test.log\n"
"	@for f in `cat ../test/TESTS`; do \\\n"
"	  ${bindir}/gosh ../test/$$f; \\\n"
"	done\n"
"\n"
"# clean ------------------------------------------------\n"
"GENERATED = stdlib.c extlib.c exclib.c syslib.c moplib.c intlib.c scmlib.c \\\n"
"	    objlib.c compile.c autoloads.c builtin-syms.c \\\n"
"	    gauche/builtin-syms.h vminsn.c gauche/vminsn.h\n"
"CONFIG_GENERATED = Makefile genconfig gauche/config.h\n"
"\n"
"clean :\n"
"	rm -rf core core.[0-9]* gosh$(EXEEXT) gauche-config$(EXEEXT) \\\n"
"	       test-vmstack$(EXEEXT) test-arith$(EXEEXT)   \\\n"
"	       $(GENERATED_SCRIPTS) gauche-config.c \\\n"
"	       libgauche.$(SOEXT)* *.$(OBJEXT) *~ *.a *.t *.def *.exp *.exe \\\n"
"	       test.log test.dir so_locations gauche/*~ gauche/arch.h\n"
"\n"
"distclean : clean\n"
"	rm -f $(CONFIG_GENERATED)\n"
"\n"
"maintainer-clean : clean\n"
"	rm -f $(CONFIG_GENERATED) $(GENERATED)\n"
"\n"
"# install ----------------------------------------------\n"
"\n"
"INSTALL_DIRS = $(DESTDIR)$(HEADER_INSTALL_DIR) \\\n"
"	       $(DESTDIR)$(HEADER_INSTALL_DIR)/gauche \\\n"
"	       $(DESTDIR)$(SCM_INSTALL_DIR) \\\n"
"	       $(DESTDIR)$(ARCH_INSTALL_DIR) \\\n"
"	       $(DESTDIR)$(BIN_INSTALL_DIR) \\\n"
"	       $(DESTDIR)$(SITE_SCM_DIR) \\\n"
"	       $(DESTDIR)$(SITE_ARCH_DIR)\n"
"\n"
"install : all relink\n"
"	$(MKINSTDIR) $(INSTALL_DIRS)\n"
"	$(INSTALL) -m 444 $(INSTALL_HEADERS) $(DESTDIR)$(HEADER_INSTALL_DIR)\n"
"	$(INSTALL) -m 444 $(INSTALL_SUBHEADERS) $(DESTDIR)$(HEADER_INSTALL_DIR)/gauche\n"
"	$(INSTALL)        $(INSTALL_LIBS) $(DESTDIR)$(LIB_INSTALL_DIR)\n"
"	$(INSTALL)        $(INSTALL_LIBS) $(DESTDIR)$(ARCH_INSTALL_DIR)\n"
"	$(INSTALL) -m 555 $(INSTALL_BINS) $(DESTDIR)$(BIN_INSTALL_DIR)\n"
"	$(INSTALL) -m 555 $(INSTALL_BINS) $(DESTDIR)$(ARCH_INSTALL_DIR)\n"
"	$(INSTALL) -m 444 $(INSTALL_SCMS) $(DESTDIR)$(SCM_INSTALL_DIR)\n"
"	@case `./gauche-config --arch` in *-cygwin*|*-mingw*) \\\n"
"	  $(INSTALL) $(INSTALL_LIBS) $(DESTDIR)$(BIN_INSTALL_DIR);;\\\n"
"	esac\n"
"	$(POSTINSTALL)\n"
"\n"
"uninstall :\n"
"	for f in $(INSTALL_BINS); do rm -f $(BIN_INSTALL_DIR)/$$f; done\n"
"	for f in $(INSTALL_LIBS); do rm -f $(LIB_INSTALL_DIR)/$$f; done\n"
"	rm -rf $(GAUCHE_ARCH_DIR)/@GAUCHE_VERSION@ $(GAUCHE_DATA_DIR)/@GAUCHE_VERSION@ $(GAUCHE_ARCH_DIR)/site/@GAUCHE_VERSION@\n"
"\n"
"pre-package : $(GENERATED)\n"
"\n"
"# MinGW specific stuff --------------------------------\n"
".in$(EXEEXT):\n"
"	$(SHELL) mingw-exify $< > $<.c\n"
"	$(COMPILE) -c -o $<.o $<.c\n"
"	$(LINK) $(gosh_LDFLAGS) -o $@ $<.o $(gosh_LDADD) $(LIBS)\n"
"\n"
"install-mingw:\n"
"	$(INSTALL) -m 444 $(INSTALL_MINGWHEADERS) $(DESTDIR)$(HEADER_INSTALL_DIR)/gauche\n"
"\n"
;

int main(int argc, char **argv)
{
    int i;
    ScmObj h = SCM_NIL, t = SCM_NIL;
    ScmObj progstr, progport, mainproc;
    ScmModule *usermod;

    Scm_Init(GAUCHE_SIGNATURE);
    Scm_Load("gauche-init.scm", 0);
    for (i=0; i<argc; i++) {
        SCM_APPEND1(h, t, SCM_MAKE_STR(argv[i]));
    }
    usermod = Scm_UserModule();
    SCM_DEFINE(usermod, "*argv*", SCM_CDR(h));
    SCM_DEFINE(usermod, "*program-name*", SCM_CAR(h));
    progstr = SCM_MAKE_STR(script);
    progport = Scm_MakeInputStringPort(SCM_STRING(progstr), TRUE);
    Scm_LoadFromPort(SCM_PORT(progport), 0);
    mainproc = Scm_SymbolValue(usermod, SCM_SYMBOL(SCM_INTERN("main")));
    if (SCM_PROCEDUREP(mainproc)) {
        ScmObj r = Scm_Apply(mainproc, SCM_LIST1(h));
        if (SCM_INTP(r)) Scm_Exit(SCM_INT_VALUE(r));
        else Scm_Exit(70);
    }
    Scm_Exit(0);
}
