import os
import sys

from Tkinter import *
from plot import Gnuplot
from tempfile import mkstemp

def GeoOpt(root,screen,logfile,numpts,gnuplotexec):

    screen.write("Starting GeoOpt.py\n")

    numpts=int(numpts)

    screenoutput,gnuplotenergy,gnuplotdev=logfile.getGeoOpt()

    screen.write(screenoutput)

    if len(gnuplotenergy)>=numpts+2: # If there are two points to plot
        
        tmpfile_a_des,tmpfile_a=mkstemp()

        # For windows gnuplot we need to replace the backslashes with forward slashes
        # (especially if your name is noelo'~1, because then you need the double quotation marks)
        newname=""
        for x in tmpfile_a:
            a=x
            if x=="\\":
                a='/'
            newname+=a
        
        gnuplotfile=open(tmpfile_a,"w")
        gnuplotdata=gnuplotenergy[numpts:]
        for i in range(len(gnuplotdata)):
            gnuplotfile.write(str(i)+"\t"+gnuplotdata[i]+"\n")
        gnuplotfile.close()
        
        line="set xlabel 'Optimisation Step'\nset ylabel 'Energy'\n"
        line=line+'plot "'+newname+'" using 1:2 notitle with lines, "'+newname+'" using 1:2 notitle\n'

        Gnuplot(root,gnuplotexec,line,"Geometry optimisation")

        os.close(tmpfile_a_des)
        os.remove(tmpfile_a)
        
        if len(gnuplotdev)>=numpts+2:
            tmpfile_b_des,tmpfile_b=mkstemp()
            # For windows gnuplot we need to replace the backslashes with forward slashes
            # (especially if your name is noelo'~1, because then you need the double quotation marks)
            newname=""
            for x in tmpfile_b:
                a=x
                if x=="\\":
                    a='/'
                newname+=a
            
            gnuplotfile=open(tmpfile_b,"w")
            gnuplotdata=gnuplotdev[numpts:]
            for i in range(len(gnuplotdata)):
                gnuplotfile.write(str(i)+"\t"+gnuplotdata[i]+"\n")
            gnuplotfile.close()
            
            line="set yrange [0:]\nset xlabel 'Optimisation Step'\nset ylabel 'Deviation from targets'\n"
            line=line+'plot "'+newname+'" using 1:2 notitle with lines, "'+newname+'" using 1:2 notitle\n'            
            Gnuplot(root,gnuplotexec,line,"Geometry optimisation")

            os.close(tmpfile_b_des)
            os.remove(tmpfile_b)

    else:
        screen.write("I need at least two points to plot\n")
        

    screen.write("Finishing GeoOpt.py\n")



# The start
if __name__=="__main__": # SCF.py is being run (not imported)
    root=Tk()
    GeoOpt(root,sys.stdout,"input/P0P_b.out",5)
    mainloop()
