import os
import gausssum.utils

from plot import DisplayPlot
from gnupy import Gnuplot
from folder import folder

def Vibfreq(root,screen,logfile,start,end,numpts,FWHM,typeofscale,scalefactor,gnuplotexec):

    def dofreqs(name,act):

        screen.write("\n************* Doing the "+name+" *****************\n")
        filename=name+"Spectrum.txt"

        freq = logfile.vibfreqs.copy() # Copy so that it won't be changed by the routine
        if hasattr(logfile, "vibsyms"):
            vibsyms = logfile.vibsyms
        else:
            vibsyms = ['?'] * len(freq)

        # Handle the scaling of the frequencies
        scale=[]
        for i in range(len(freq)):
            scale.append(scalefactor)
        if typeofscale=="Gen":
            screen.write("Going to scale with a scaling factor of "+str(scalefactor)+"\n")
            general=True
        else:
            screen.write("Going to use individual scaling factors\n")
            screen.write("Looking for scaling factors in "+filename+"...")
            try:
                inputfile=open(os.path.join(gaussdir,filename),"r")
            except IOError:
                screen.write("not found\nGoing to use general scale factor of "+str(scalefactor)+" instead\n")
                general=True
            else:
                screen.write("found\n")
                general=False
                line=inputfile.readline(); line=inputfile.readline()
                i=0
                line=inputfile.readline().split('\t')
                while len(line)>2 and line[4]!='': # Read in the individual scaling factors
                    sf=line[7]
                    if sf=='':
                        sf=scalefactor
                    else:
                        sf=float(sf)
                    scale[i]=sf
                    i=i+1
                    line=inputfile.readline().split('\t')
           
        for i in range(len(freq)): # Scale the freqs
            freq[i] = freq[i]*scale[i]
        
        # Convolute the spectrum
        spectrum = gausssum.utils.Spectrum(start,end,numpts,
                                           [zip(freq,act)],
                                           FWHM,gausssum.utils.lorentzian)

        outputfile = open(os.path.join(gaussdir,filename),"w")
        screen.write("Writing scaled spectrum to "+filename+"\n")
        outputfile.write("Spectrum\t\t\tNormal Modes\n")
        outputfile.write("Freq (cm-1)\t"+name+" act\t\tMode\tLabel\tFreq (cm-1)\t"+name+" act\t")
        outputfile.write("Scaling factors\tUnscaled freq\n")
        width = end-start
        for x in range(0,numpts):
            if spectrum.spectrum[x,0]<1e-20:
                spectrum.spectrum[x,0] = 0.
            realx = width*(x+1)/numpts+start
            outputfile.write(str(realx)+"\t"+str(spectrum.spectrum[x,0]))
            if x<len(freq): # Write the activities (assumes more pts to plot than freqs - fix this)
                outputfile.write("\t\t"+str(x+1)+"\t"+vibsyms[x]+"\t"+str(freq[x])+"\t"+str(act[x]))
                outputfile.write("\t"+str(scale[x])+"\t"+str(logfile.vibfreqs[x]))
            outputfile.write("\n")
        outputfile.close()

        # Draw using Gnuplot
        screen.write("Plotting with Gnuplot\n")
        g = Gnuplot(gnuplotexec)
        
        if name=="IR":
            g.commands("set xlabel 'Frequency (cm-1)'",
                       "set ylabel 'IR activity'",
                       "set yrange [*:*] reverse",
                       "set xrange [*:*] reverse",
                       "set key bottom")
        else:
            g.commands("set xlabel 'Frequency (cm-1)'",
                       "set ylabel 'Raman activity'")

        if general==True:
            title = "%s spectrum scaled by %f" % (name, scalefactor)
        else:
            title = "%s spectrum scaled by individual scaling factors" % name

        g.data(zip(spectrum.xvalues,spectrum.spectrum[:,0]),"title '%s' with lines" % title)
        DisplayPlot(root,g,"%s Spectrum" % name)
        

    ############## START OF MAIN FUNCTION #############
        
    screen.write("Starting to analyse the vibrational frequencies\n")

    # Create a new output folder if necessary (returns the location of it in any case)
    gaussdir=folder(screen,logfile)

    if hasattr(logfile,"vibirs"):
        dofreqs("IR",logfile.vibirs)

    if hasattr(logfile,"vibramans"):
        dofreqs("Raman",logfile.vibramans)

    screen.write("Finished\n")
    
    return True
        
    ############## END OF MAIN FUNCTION #############
