import unittest
from utils import refresh_gui, init_gazpacho
import gtk

app, project = init_gazpacho()

from gazpacho import command

class GtkTableTest(unittest.TestCase):
        
    def test01Creation(self):
        global app, project
        app.palette.select_widget('Gtk+ Base', 'GtkWindow')
        refresh_gui()
        gwidget = project.get_widget_by_name('window1')
        app.palette.select_widget('Gtk+ Base', 'GtkTable')
        placeholder = gwidget.gtk_widget.get_child()
        cm = app.get_command_manager()
        cm.create(app.add_class, placeholder, None, interactive=False)
        refresh_gui()
        gwidget = project.get_widget_by_name('table1')
        self.assertEqual(gtk.Table, type(gwidget.gtk_widget))

    def test02Property(self):
        global app, project
        gwidget = project.get_widget_by_name('table1')
        prop = gwidget.get_glade_property('n-rows')
        cm = app.get_command_manager()
        cm.set_property(prop, 3)
        refresh_gui()
        self.assertEqual(gwidget.gtk_widget.get_property('n-rows'), 3)
        prop = gwidget.get_glade_property('n-columns')
        cm.set_property(prop, 3)
        refresh_gui()
        self.assertEqual(gwidget.gtk_widget.get_property('n-columns'), 3)

    def test03AddChildren(self):
        global app, project
        gwidget = project.get_widget_by_name('table1')
        i = 1
        cm = app.get_command_manager()
        for placeholder in gwidget.gtk_widget.get_children():
            app.palette.select_widget('Gtk+ Base', 'GtkButton')
            cm.create(app.add_class, placeholder, None)
            button = project.get_widget_by_name('button%d' % i)
            prop = button.get_glade_property('label')
            cm.set_property(prop, 'Button %d' % i)
            refresh_gui()
            i += 1

        for child in gwidget.gtk_widget.get_children():
            self.assertEqual(gtk.Button, type(child))
            
    def test03Saving(self):
        global project
        project.save(__file__+'.glade')
        refresh_gui()
        
    def test04Loading(self):
        global app
        app.open_project(__file__+'.glade')
        refresh_gui()
        
if __name__ == '__main__':
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(GtkTableTest))
    unittest.TextTestRunner(verbosity=2).run(suite)
