# Copyright (C) 2005 by SICEm S.L. and Async Open Source
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import gobject
import gtk

from gazpacho.loader.custom import adapter_registry, \
     ComboBoxAdapter as LoaderAdaptor
from gazpacho.properties import prop_registry, CustomProperty, StringType
from gazpacho.widgetadaptor import WidgetAdaptor

class ComboBox(gtk.ComboBox):
    pass
gobject.type_register(ComboBox)

class ComboBoxAdaptor(WidgetAdaptor):
    type = ComboBox
    name = 'GtkComboBox'
    def pre_create(self, context, combo, interactive=True):
        model = gtk.ListStore(gobject.TYPE_STRING)
        combo.set_model(model)

    def fill_empty(self, context, widget):
        pass

class ComboBoxEntryAdaptor(WidgetAdaptor):
    pass

class ComboBoxLoader(LoaderAdaptor):
    object_type = ComboBox
adapter_registry.register_adapter(ComboBoxLoader)

# GtkComboBox

# XXX: This is too complex, fix properties API
#      TransparentProperty doesn't work, why?
class Items(CustomProperty, StringType):
    label = 'Items'
    default = ''
    def __init__(self, widget):
        # XXX: Adapter should be accessible in all properties
        self._adapter = adapter_registry.get_adapter(widget.gtk_widget, None)
        super(Items, self).__init__(widget)

    def load(self):
        model = self._object.get_model()
        if not model:
            # Hack warning, only needed for GtkComboBoxEntry
            model = gtk.ListStore(str)
            self._object.set_model(model)
        self._value = '\n'.join([row[0] for row in model])
        self._initial = self.default
        
    def get(self):
        return self._value
    
    def set(self, value):
        self._value = value
        self._adapter.prop_set_items(self._object, value)
prop_registry.override_property('GtkComboBox::items', Items)
        
# These properties are buggy in GTK+ 2.4
prop_registry.override_simple('GtkComboBox::column-span-column', editable=False)
prop_registry.override_simple('GtkComboBox::row-span-column', editable=False)

# GtkComboBoxEntry
prop_registry.override_simple('GtkComboBoxEntry::text-column', default=0)

