/* GBINDADMIN, a GTK+ frontend for ISC BIND
 * Copyright C 2005, 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "populate_resource_treeview.h"
#include "reread_conf.h"
#include "allocate.h"
#include "reverse_address.h"
#include "commands.h"

extern char CHROOT_PATH_BUF[1024];

extern char global_domain_name[1024];
extern char global_domain_address[1024];
extern char global_domain_type[1024];



void add_resource(struct w *widgets)
{
    FILE *fwd_fp, *rev_fp;
    G_CONST_RETURN gchar *hostname, *address;
    gint active_index;
    gchar *record=NULL;
    gchar *forward_zone_file, *reverse_zone_file;
    gchar *info;


    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->add_resource_type_combo));
    hostname = gtk_entry_get_text(GTK_ENTRY(widgets->add_resource_hostname_entry));
    address = gtk_entry_get_text(GTK_ENTRY(widgets->add_resource_address_entry));

    if( strlen(hostname) < 3 )
    {
	info = g_strdup_printf(_("The hostname is too short, the resource was not added.\n"));
	show_info(info);
	g_free(info);
	return;
    }
    if( strlen(address) < 1 ) /* Mailserver priority can be one char */
    {
	info = g_strdup_printf(_("The IP-address or hostname is too short, the resource was not added.\n"));
	show_info(info);
	g_free(info);
	return;
    }

    forward_zone_file = g_strdup_printf("%s/etc/sites/%s/forward.zone", CHROOT_PATH_BUF, global_domain_name);
    reverse_zone_file = g_strdup_printf("%s/etc/sites/%s/reverse.zone", CHROOT_PATH_BUF, global_domain_name);

    /* Open the forward zone for this site */
    if((fwd_fp=fopen(forward_zone_file, "a"))==NULL)
    {
        printf("Resource not added. Could not find the forward zone here: %s\n", forward_zone_file);
        return;
    }
    /* Open the reverse zone for this site */
    if((rev_fp=fopen(reverse_zone_file, "a"))==NULL)
    {
        printf("Resource not added. Could not find the reverse zone here: %s\n", reverse_zone_file);
	fclose(fwd_fp);
        return;
    }
    

    /* Add the record type as specified by the combo box */
    if( active_index <= 0 )
    {
	/* Add an NS record and an A record to the forward zone and a PTR record in the reverse zone */
	record = g_strdup_printf("\n\t\tNS\t%s.\n", hostname);
	fputs(record, fwd_fp);

	record = g_strdup_printf("\n%s.\tA\t%s\n", hostname, address);
	fputs(record, fwd_fp);

	record = g_strdup_printf("\n\tIN\tNS\t%s.\n", hostname);
	fputs(record, rev_fp);

	record = g_strdup_printf("\n%s\tIN\tPTR\t%s.\n", address, hostname);
	fputs(record, rev_fp);
    }
    else
    if( active_index == 1 )
    {
	/* Add an MX record in the forward zone (and _NO_ PTR record in the reverse zone??) */
	record = g_strdup_printf("\n\tIN\tMX\t%s\t%s.\n", address, hostname);
	fputs(record, fwd_fp);
    }
    else
    if( active_index == 2 )
    {
	/* Add an IPv4 A record to the forward zone and a PTR in the reverse zone */
	record = g_strdup_printf("\n%s.\tIN\tA\t%s\n", hostname, address);
	fputs(record, fwd_fp);

	printf("Adding a PTR record to the reverse zone\n");
	record = g_strdup_printf("\n%s\tIN\tPTR\t%s.\n", address, hostname);
	fputs(record, rev_fp);
    }
    else
    if( active_index == 3 )
    {
	/* Add an IPv6 AAAA record to the forward zone and a PTR in the reverse zone */
	record = g_strdup_printf("\n%s.\tIN\tAAAA\t%s\n", hostname, address);
	fputs(record, fwd_fp);

	record = g_strdup_printf("\n%s\tIN\tPTR\t%s.\n", address, hostname);
	fputs(record, rev_fp);
    }
    else
    if( active_index == 4 )
    {
	/* Add a CNAME record to the forward zone */
	record = g_strdup_printf("\n%s.\tIN\tCNAME\t%s.\n", address, hostname);
	fputs(record, fwd_fp);
    }


    fclose(fwd_fp);
    fclose(rev_fp);
    g_free(record);
    populate_resource_treeview(widgets);
}
