#!/usr/bin/perl

use strict;
use warnings;

use Dpkg::Control::Info;

my $bd_value = "";

for(@ARGV)
{
    my $control = Dpkg::Control::Info->new($_);
    my $fields = $control->get_source();

    $bd_value .= $fields->{"Build-Depends"} if defined $fields->{"Build-Depends"};
    if (defined $fields->{"Build-Depends-Indep"}) {
	$bd_value .= ", ";
	$bd_value .=  $fields->{"Build-Depends-Indep"};
    }
    $bd_value .= ", ";
}
chop $bd_value;
chop $bd_value;

# those two are kernel deps but we do not build kernel
# and they conflict with libelf0g-dev which we need for gcc
$bd_value =~ s/lib(dw|elf)-dev, //g;

$bd_value =~ s/\n//g;
$bd_value =~ s/,,/,/g;

# split may need more complex rule to cover ' ,' ',,,,,' etc
my %deps = map {$_ => 1 } split(',[[:space:]]', $bd_value);
print join(', ', sort keys %deps);
