package GCExport::GCExportHTML;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCExport::GCExportBase;

{
    package GCExport::GCExporterHTML;


    use File::Copy;
    use File::Basename;
    use base qw(GCExport::GCExportBaseClass);


    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        
	$self->{previousLetter} = ' ';	
	
        bless ($self, $class);
        return $self;
    }

    sub getName
    {
        my $self = shift;
        
        return "HTML";
    }
        
    sub getOptions
    {
        my $self = shift;
	
	$self->{modelsDir} = $ENV{GCF_SHARE_DIR}.'/html_models';
        $self->{modelsDir} = '"'.$self->{modelsDir}.'"' if ($^O =~ /win32/i) && ($self->{modelsDir} =~ / /);

        $self->{modelsFiles} = '';

        my @tmp_filenames;

        foreach (glob $self->{modelsDir}.'/*')
        {
            next if $_ =~ /\/CVS$/;
            (my $mod = basename($_)) =~ s/_/ /g;
            $self->{modelsFiles} .= $mod.',';
        }
        
        return [
	{
                name => 'withJs',
                type => 'checkBox',
                label => 'ExportHTMLWithJS',
                default => '1'
            },
	
	
	{
                name => 'fileExport',
                type => 'list',
                label => 'ExportHTMLFileTemplate',
                default => 'Tian',
                valuesList => $self->{modelsFiles} 
            },
                      
            {
                name => 'title',
                type => 'shortText',
                label => 'ExportHTMLTitle',
                default => 'Movies list'
            },
	    
	    	{
                name => 'height_img',
                type => 'number',
                label => 'ExportHTMLHeightimg',
                default => 160,
                min => 100,
                max => 250,
            },   
                        
        ]
    }
    
    sub wantsFieldsSelection
    {
        return 0;
    }
    
    sub wantsImagesSelection
    {
        return 1;
    }
    
    
    
    sub preProcess
    {
        my $self =  shift;
	
        $self->{options}->{fileExport} =~ s/ /_/;
	
        if ($self->{options}->{fileExport} ne 'Tian')
        {
            my $model;
            my $file = $self->{modelsDir}."/".$self->{options}->{fileExport};
            $file =~ s/"//g;
            #"

			open FILE, $file;
			$model = do { local $/; <FILE> };
			close FILE;
	
            $model =~ m{
                \[HEADER\]\n?(.*?)\n?\[\/HEADER\].*?
                \[ITEM\]\n?(.*?)\n?\[\/ITEM\].*?
                \[FOOTER\]\n?(.*?)\n?\[\/FOOTER\]
            }xms;
            $self->{header} = $1;
            $self->{item} = $2;
            $self->{footer} = $3;
        }
	}

    sub getHeader
    {
        my ($self, $number) = @_;
	
        if ($self->{options}->{fileExport} ne 'Tian')
        {
            my $result = $self->{header};
	
            $self->{savednumber} = $number;
            $result =~ s/\$\$PAGETITLE\$\$/$self->{options}->{title}/g;
            $result =~ s/\$\$NUMBER\$\$/$number/g;
            return $result."\n";
        }
        else
        {
	
            my $result = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
      "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
<head>
 <title>'.$self->{options}->{title}.'</title>
 <meta http-equiv="Content-Type" content="text/html; charset="iso-8859-1" />
';

            if ($self->{options}->{withJs})
            {
                $result .= '
 <script type="text/javascript">
expandTooltip="Afficher les informations du film";
collapseTooltip="Masquer les informations du film";
function prn(s)
{
 document.write(s)
}
function getE(id)
{
 return document.getElementById(id)
}
function expcolAll(dir,rowNum)
{
 for(x=0;x < rowNum;x++) {
  try {
   getE(\'movie\'+x).style.display=dir
   if(dir=="none") getE(\'switch\'+x).innerHTML="+"
   else getE(\'switch\'+x).innerHTML="&ndash;"
  }
  catch(err) { }
 }
}
function toggleDisplay(id,swt)
{
 if((getE(id).style.display=="")||(getE(id).style.display=="none")) {
  getE(id).style.display="block"
  getE(swt).innerHTML="&ndash;"
  getE(swt).title=collapseTooltip
 } else {
  getE(id).style.display="none"
  getE(swt).innerHTML="+"
  getE(swt).title=expandTooltip
 }
 return false
}
function writeExpandControl(elementId,collapse)
{
 prn("<a href=\"#\" class=\"movie-expand\" id=\"switch"+elementId+"\" onclick=\"return toggleDisplay(\'movie"+elementId+"\',\'switch"+elementId+"\');\" title=\""+((collapse) ? expandTooltip : collapseTooltip)+"\">"+((collapse) ? "+" : "&ndash;")+"</a>")
}
function searchMovies(text)
{
 //text=getE("searchText").value
 getE("collapseAll").click()
 alldt=document.getElementsByTagName("dt")
 alldd=document.getElementsByTagName("dd")
 nb=alldt.length
 re=new RegExp(text,"i")
 for(i=0;i<nb;i++) {
  s1=alldt[i].getElementsByTagName("a")[1].innerHTML
  s2=alldd[i].innerHTML
  res=0
  if(getE("searchType").value=="all") res=(re.test(s1)||re.test(s2))
  else res=re.test(s1)
  if(res) st="block"
  else st="none"
  alldt[i].style.display=st
  alldd[i].style.display=st
 }
}
 </script>
';
            }
            $result.='
 <style type="text/css">
   body {
   background:#f7f8ff;
  }
  h1 {
   font-weight:bold;
   font-size:160%;
   text-align:center;
   margin-bottom:1em;
  }
  #top {
   color:#624a66 ! important;
   background:transparent ! important;
  }
  form {
   text-align:center;
   border:1px solid #c0c0c0;
   background:#e2e2df;
   margin:0 3em;
   padding:0.5em;
  }
  input,select {
   border:2px solid #aaaaaa;
   background:purple;
   color:white;
   margin:0 0.5em;
  }
  input:focus, input.submit:hover {
   background:#f3e3f9;
   color:black;
  }
  input.submit {
   cursor:pointer;
  }
  #links {
   margin-top:0.5em;
   text-align:center;
   font-size:120%;
   color:#aaaaaa;
  }
  img {
   float:left;
   margin:0 1em 1em 1em;
  }
  dt {
   color:#aaaaaa;
   font-size:120%;
   margin:0em 0.5em;
   clear:both;
  }
  dd {
   margin:0.5em 2em 1em;
   border-left:1px solid #2e3766;
   border-bottom:1px solid #2e3766;
  }
  table {
   font-size:90%;
   margin:0 1em;
   border:1px solid black;
   width:60%;
  }
  th {
   font-weight:bold;
   text-align:left;
   width:25%;
  }
  .tr1 {
   background:#d4cce0;
  }
  .tr2 {
   background:#c0b9cc;
  }
  a {
   color:#2e3766;
   background:transparent;
   text-decoration:none;
  }
  a:hover, a:focus {
   background-color:#e8e8ef;
  }
  .topl {
   color:#aaaaaa;
   font-size:90%;
  }
  .movie-expand {
   width:1em;
   text-align:center;
   font-size:120%;
   float:left;
   margin:0.2em;
  }
  p {
   background:white;
   border:2px solid purple;
   clear:left;
   margin:1em 2em;
   padding:0.5em;
  }
  .dispo {
   color:#00ff0c;
   background:transparent;
   text-decoration:none;
  }
  .nondispo {
   color:#ff0000;
   background:transparent;
   text-decoration:none;
  }
 </style>
</head>
<body>
 <h1><a id="top">'.$self->{options}->{title}.'</a></h1>
';
            if ($self->{options}->{withJs})
            {
                $result .= '
 <form onsubmit="searchMovies(getE(\'searchText\').value); return false">
  <input type="text" id="searchText" title="'.$self->{options}->{lang}->{ExportHTMLinputTitle}.'" />
  <select id="searchType">
   <option value="title">'.$self->{options}->{lang}->{ExportHTMLlistSearchTypeValue1}.'</option>
   <option value="all">'.$self->{options}->{lang}->{ExportHTMLlistSearchTypeValue2}.'</option>
  </select>
  <input type="button" class="submit" value="'.$self->{options}->{lang}->{ExportHTMLsearchbutton}.'" title="'.$self->{options}->{lang}->{ExportHTMLsearchbuttonTitle}.'" onclick="searchMovies(getE(\'searchText\').value)" />
  <input type="button" class="submit" value="'.$self->{options}->{lang}->{ExportHTMLallbutton}.'" title="'.$self->{options}->{lang}->{ExportHTMLallbuttonTitle}.'" onclick="searchMovies(\'\')" />
  <br />
  <br />
  <input  type="button" class="submit" value="'.$self->{options}->{lang}->{ExportHTMLviewinfos}.'" onclick="expcolAll(\'block\',\''.$number.'\')" title="'.$self->{options}->{lang}->{ExportHTMLviewinfosTitle}.'" />
  <input  type="button" id="collapseAll" class="submit" value="'.$self->{options}->{lang}->{ExportHTMLhideinfos}.'" onclick="expcolAll(\'none\',\''.$number.'\')" title="'.$self->{options}->{lang}->{ExportHTMLhideinfosTitle}.'" />
 </form>
';
            }
            $self->{letters} = ();
            my $links = '<div id="links">| ';
            my $letter = '';
            foreach $letter('_','A'..'Z')
            {
              $links .= $letter.' | ';
            }

            $result .= $links.'</div>
 <dl>
';
            return $result;
        }
    }

    sub getFooter
    {
        my ($self, $movie) = @_;
        if ($self->{options}->{fileExport} ne 'Tian')
        {
            #my $self = shift;
            my $number = $self->{savednumber};
            my $result = $self->{footer};
            $result =~ s/\$\$PAGETITLE\$\$/$self->{options}->{title}/g;
            $result =~ s/\$\$NUMBER\$\$/$number/g;
            $result =~ s/\$\$ExportHTMLnote\$\$/$self->{options}->{lang}->{ExportHTMLnote}/g;
            return $result."\n";
        }
        else
        {
            my $result = '</dl>
	<div id="note" align="center"><p>'.$self->{options}->{lang}->{ExportHTMLnote}.' </p></div>
</body>
</html>
';
            return $result;
        }
    }

    sub getItem
    {
    my ($self, $movie, $idx) = @_;
    my $number;
    	if ($self->{options}->{fileExport} ne 'Tian') {
		

			my $number = $self->{savednumber};
			my $result = $self->{item};
			$result =~ s/\$\$MOVIETITLE\$\$/$movie->{title}/g;
			$result =~ s/\$\$DATE\$\$/$movie->{date}/g;
			$result =~ s/\$\$TIME\$\$/$movie->{time}/g;
			$result =~ s/\$\$DIRECTOR\$\$/$movie->{director}/g;
			$result =~ s/\$\$NAT\$\$/$movie->{nat}/g;
			(my $tmpType = $movie->{type}) =~ s/,*$//;
			$result =~ s/\$\$TYPE\$\$/$tmpType/g;
			$result =~ s/\$\$IMAGE\$\$/$movie->{image}/g;
			$result =~ s/\$\$HEIGHT_PIC\$\$/$self->{options}->{height_img}/g;
			$result =~ s/\$\$ORIGINAL_TITLE\$\$/$movie->{orig}/g;
			$result =~ s/\$\$ACTORS\$\$/$movie->{actors}/g;
			$result =~ s/\$\$COMMENT\$\$/$movie->{comment}/g;
			(my $synopsis = $movie->{synopsis}) =~ s/[\r\n]/<br \/>/g;
			$synopsis =~ s/<br>/<br \/>/g;
			$result =~ s/\$\$SYNOPSIS\$\$/$synopsis/g;
			$result =~ s/\$\$SEEN\$\$/$movie->{seen}/g;
			$result =~ s/\$\$ID\$\$/$movie->{id}/g;
			$result =~ s/\$\$RATING\$\$/$movie->{rating}/g;
			$result =~ s/\$\$FORMAT\$\$/$movie->{format}/g;
			$result =~ s/\$\$MEDIA_NUMBER\$\$/$movie->{number}/g;
			$result =~ s/\$\$URL\$\$/$movie->{url}/g;
			$result =~ s/\$\$PLACE\$\$/$movie->{place}/g;
			$result =~ s/\$\$AUDIO\$\$/$movie->{audio}/g;
			$result =~ s/\$\$SUBT\$\$/$movie->{subt}/g;
			my $tmpBorrower = $movie->{borrower};
			$tmpBorrower = $self->{options}->{lang}->{PanelNobody}
			    if $tmpBorrower eq 'none';
			$result =~ s/\$\$BORROWER\$\$/$tmpBorrower/g;
			$result =~ s/\$\$LENDDATE\$\$/$movie->{lendDate}/g;
			$result =~ s/\$\$HISTORY\$\$/$movie->{history}/g;
			$result =~ s/\$\$IDX\$\$/$idx/g;
			$result =~ s/\$\$NUMBER\$\$/$number/g;	
			$result =~ s/\$\$MOVIETITLE_LABEL\$\$/$self->{options}->{lang}->{PanelTitle}/g;
			$result =~ s/\$\$DATE_LABEL\$\$/$self->{options}->{lang}->{PanelDate}/g;
			$result =~ s/\$\$TIME_LABEL\$\$/$self->{options}->{lang}->{PanelTime}/g;
			$result =~ s/\$\$TYPE_LABEL\$\$/$self->{options}->{lang}->{PanelType}/g;
			$result =~ s/\$\$DIRECTOR_LABEL\$\$/$self->{options}->{lang}->{PanelDirector}/g;
			$result =~ s/\$\$NAT_LABEL\$\$/$self->{options}->{lang}->{PanelCountry}/g;
			$result =~ s/\$\$ORIGINAL_TITLE_LABEL\$\$/$self->{options}->{lang}->{PanelOriginal}/g;
			$result =~ s/\$\$ACTORS_LABEL\$\$/$self->{options}->{lang}->{PanelActors}/g;
			$result =~ s/\$\$COMMENT_LABEL\$\$/$self->{options}->{lang}->{PanelComment}/g;
			$result =~ s/\$\$SYNOPSIS_LABEL\$\$/$self->{options}->{lang}->{DisplayOptionsSynopsis}/g;
			$result =~ s/\$\$SEEN_LABEL\$\$/$self->{options}->{lang}->{PanelSeen}/g;
		    $result =~ s/\$\$RATING_LABEL\$\$/$self->{options}->{lang}->{PanelRating}/g;
			$result =~ s/\$\$FORMAT_LABEL\$\$/$self->{options}->{lang}->{PanelMedia}/g;
			$result =~ s/\$\$NUMBER_LABEL\$\$/$self->{options}->{lang}->{PanelNumber}/g;
			$result =~ s/\$\$URL_LABEL\$\$/$self->{options}->{lang}->{PanelWeb}/g;
			$result =~ s/\$\$PLACE\$\$/$self->{options}->{lang}->{place}/g;
			$result =~ s/\$\$AUDIO_LABEL\$\$/$self->{options}->{lang}->{PanelAudio}/g;
			$result =~ s/\$\$SUBT_LABEL\$\$/$self->{options}->{lang}->{PanelSub}/g;
			$result =~ s/\$\$BORROWER_LABEL\$\$/$self->{options}->{lang}->{PanelBorrower}/g;
			$result =~ s/\$\$LENDDATE_LABEL\$\$/$self->{options}->{lang}->{PanelLendDate}/g;
			$result =~ s/\$\$HISTORY_LABEL\$\$/$self->{options}->{lang}->{PanelHistory}/g;
			$result =~ s/\$\$INFO_LABEL\$\$/$self->{options}->{lang}->{DisplayOptionsInfo}/g;
    		$result =~ s/\$\$PERSO_LABEL\$\$/$self->{options}->{lang}->{DisplayOptionsPerso}/g;
	
			return $result."\n";
	}
	else {
	
        chdir $self->{origDir};
        #copy($movie->{image}, $self->{dirName});
        #my $image = basename($self->{dirName}).'/'.basename($movie->{image});
	## ajout�par BohwaZ ##
	my $audio = $movie->{audio};
	$audio =~ s/,*$//;
	my $subt = $movie->{subt};
	$subt =~ s/,*$//;
	#######################
        my $result = '<dt>';

        if ($self->{options}->{withJs})
        {
            $result .= '<script type="text/javascript">writeExpandControl('.$idx.',1)</script>';
        }
	$result .= '<a href="';
        $result .= $movie->{url};

	my $idString = '';
	my $firstLetter = substr($movie->{title}, 0, 1);
        $firstLetter =~ s/[^A-Z]/_/;
	if ($self->{previousLetter} ne $firstLetter)
	{
	    $self->{previousLetter} = $firstLetter;
	    $idString = 'id="'.$firstLetter.'"';
            push @{$self->{letters}}, $firstLetter;
	}

        $result .= '" '.$idString.'>';
	my $emprunt = $movie->{borrower};
	
	if (! $emprunt || ($emprunt eq 'none'))
	{ 
		$emprunt = ' <div id="pret" class="dispo";>'.$self->{options}->{lang}->{ExportHTMLnoBorrowed}.' </div>';
		# image dispo + lien mailto au proprio de la liste
		#$emprunt = '<div id="pret" class="dispo";>Disponible. </div>';
	}
	else
	{
		$emprunt = ' <div id="pret" class="nondispo";> '.$self->{options}->{lang}->{ExportHTMLBorrowed}.''.$movie->{borrower}.'. </div>';
		# image non dispo + lien mailto au proprio de la liste pour prevoir prochaine dispo
		#$emprunt = '<div id="pret" class="nondispo";> Emprunte par: ' .$movie->{borrower}.'. </div>';
	}
	$result .= $movie->{title};
        $result .= '</a>';
        $result .= ' | <a class="topl" href="#top">('.$self->{options}->{lang}->{ExportHTMLtop}.')</a>' .$emprunt.'</dt>
<dd><div id="movie'.$idx.'"';
        if ($self->{options}->{withJs})
        {
            $result .= ' style="display:none;"';
        }
        $result .= '><img src="'.$movie->{image}.'" alt="'.$movie->{title}.'" title= "'.$movie->{title}.'" height="'.$self->{options}->{height_img}.'" />';
        $result .= ' <table>';
        $result .= '  <tr class="tr1"><th>'.$self->{options}->{lang}->{ExportHTMLtableTime}.'</th><td>'.$movie->{time}.'</td></tr>';
        my $type = $movie->{type};
        $type =~ s/,*$//;
        $result .= '  <tr class="tr2"><th>'.$self->{options}->{lang}->{ExportHTMLtableType}.'</th><td>'.$type.'</td></tr>';
        $result .= '  <tr class="tr1"><th>'.$self->{options}->{lang}->{ExportHTMLtableDate}.'</th><td>'.$movie->{date}.'</td></tr>';
        $result .= '  <tr class="tr2"><th>'.$self->{options}->{lang}->{ExportHTMLtableDirector}.'</th><td>'.$movie->{director}.'</td></tr>';
        $result .= '  <tr class="tr1"><th>'.$self->{options}->{lang}->{ExportHTMLtableActors}.'</th><td>'.$movie->{actors}.'</td></tr>';
        $result .= '  <tr class="tr2"><th>'.$self->{options}->{lang}->{ExportHTMLtableFormat}.'</th><td>'.$movie->{format}.' ('.$movie->{number}.')</td></tr>';
        $result .= '  <tr class="tr2"><th>'.$self->{options}->{lang}->{ExportHTMLtableRating}.'</th><td>'.$movie->{rating}.'/10</td></tr>';
        ## ajoute grace a BohwaZ ##
	$result .= ' <tr class="tr2"><th>'.$self->{options}->{lang}->{ExportHTMLtableAudio}.'</th><td>'.$audio. '</td></tr>';
	$result .= ' <tr class="tr2"><th>'.$self->{options}->{lang}->{ExportHTMLtableSubtitle}.'</th><td>'.$subt.'</td></tr>';
	######################
        $result .= ' </table>';
        my $synopsis = $movie->{synopsis};
        $synopsis =~ s/[\r\n]/<br \/>/g;
        ## ajoute grace a BohwaZ ##
	$result .= ' <p>'.$synopsis.'<br /><br /><em>'.$movie->{comment}.'</em></p>';
	######################
	#$result .= '  <p>'.$synopsis.'</p>';
        $result .= '</div></dd>
';

        return $result;
	
	}
    }

    sub postProcess
    {
        my ($self, $value) = @_;
	if ($self->{options}->{fileExport} ne 'Tian') {
		my $result;
		return $result;
	}
	else {
	
		my $letter;
		foreach $letter(@{$self->{letters}})
		{
		$$value =~ s/\| $letter \|/| <a href="#$letter">$letter<\/a> |/;
		}
	
	}
    }

    sub getEndInfo
    {
        my $self = shift;
        my $message = $self->{options}->{lang}->{ExportHTMLInfoFile}.$self->{fileName};
        $message .= '

'.$self->{options}->{lang}->{ExportHTMLInfoDir}.$self->{dirName}
            if $self->{options}->{withPictures};
            
        return $message;
    }
}

1;
