package GCExport::GCExportSQL;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCExport::GCExportBase;

{
    package GCExport::GCExporterSQL;
    use base qw(GCExport::GCExportBaseClass);

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        

        bless ($self, $class);
        return $self;
    }

    sub getOptions
    {
        my $self = shift;
        
        return [
            {
                name => 'withDrop',
                type => 'checkBox',
                label => 'ExportSQLWithDrop',
                default => '1'
            },
            {
                name => 'withCreate',
                type => 'checkBox',
                label => 'ExportSQLWithCreate',
                default => '1'
            },
            
            {
                name => 'table',
                type => 'shortText',
                label => 'ExportSQLTableName',
                default => 'movies'
            },                        
        ]
    }
    
    sub wantsFieldsSelection
    {
        return 1;
    }
    
    sub wantsImagesSelection
    {
        return 1;
    }
    
    sub getName
    {
        my $self = shift;
        
        return "SQL";
    }
    
    sub preProcess
    {
        my $self =  shift;
    }

    sub getHeader
    {
        my ($self, $number) = @_;

        my $result = '';

        if ($self->{options}->{withDrop})
        {
            $result .= 'DROP TABLE '.$self->{options}->{table}.";\n";
        }
        if ($self->{options}->{withCreate})
        {
            $result .= 'CREATE TABLE '.$self->{options}->{table}.' (';
            
            foreach (@{$self->{options}->{fields}})
            {
                my $format;
                $format = 'NUMBER' if ($_ =~ /seen|number|rating/);
                $format = 'TEXT' if ($_ !~ /seen|number|rating/);
                $result .= "$_ $format, ";
            }
            $result =~ s/, $//;
            $result .= ");\n";
        }

        return $result;
    }

    sub getFooter
    {
        my $self = shift;

        my $result = "COMMIT;\n";
        return $result;
    }

    sub getItem
    {
        my ($self, $movie, $number) = @_;
        my $result;
     
        $result = 'INSERT INTO '.$self->{options}->{table}.' (';
        my $values = '';
        foreach (@{$self->{options}->{fields}})
        {
            $result .= "$_, ";
            (my $value = $movie->{$_}) =~ s/'/''/g;
            $values .= "'".$value."', ";
        }
        $result =~ s/, $//;
        $values =~ s/, $//;
        
        $result .= ") VALUES ($values);\n";
        return $result;
    }

    sub postProcess
    {
        my ($self, $value) = @_;

    }

    sub getEndInfo
    {
        my $self = shift;
        my $message = $self->{options}->{lang}->{ExportSQLInfoFile}.$self->{fileName};
        return $message;
    }
}

1;