package GCPlugins::GCOFDb;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginOFDb;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        return if $self->{parsingEnded};
        
        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
							if ($attr->{href} =~ m/view\.php\?page=film&fid=[0-9]*/)
							{
									$self->{isMovie} = 1;
              		$self->{isInfo} = 1;
              		$self->{movieIdx}++;
              		$self->{movieList}[$self->{movieIdx}]->{'url'} = $attr->{href};
							}
						}
            elsif ($tagname eq "div")
            {
							if ($attr->{class} eq "year")
							{
              		$self->{isYear} = 1;
							}
						}
        }
        else
        {
            if ($tagname eq "font")
            {
							if ($attr->{face} eq "Arial,Helvetica,sans-serif")
							{
									if ($attr->{size} eq "3")
									{
	              		$self->{insideName} = 1;
									}
									elsif ($attr->{size} eq "2")
									{
										$self->{insideInfosNames} = 1 if $attr->{class} eq "Normal";
										$self->{insideInfos} = 1 if $attr->{class} eq "Daten";
									}
							}
						}
						elsif (($tagname eq "img") && ($attr->{src} =~ m/^images\/film\/[0-9]\/[0-9]*.jpg/))
						{
							$self->{curInfo}->{image} = 'http://www.ofdb.de/' . $attr->{src};
						}
						elsif ($tagname eq "a")
						{
							$self->{insideNat} = 1 if $attr->{href} =~ m/view\.php\?page=blaettern&Kat=Land&Text=.*/;
							$self->{insideDate} = 1 if $attr->{href} =~ m/view\.php\?page=blaettern&Kat=Jahr&Text=[0-9]{4}/;
						}
						elsif (($tagname eq "div") && ($attr->{class} eq "synopsis"))
						{
							$self->{insideSynopsis} = 1;
						}
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

				if ($tagname eq "tr")
				{
					$self->{insideDirector} = 0;
					$self->{insideActors} = 0;
					$self->{insideType} = 0;
					$self->{insideInfos} = 0;
				}

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
           
        if ($self->{parsingList})
        {
            if ($self->{isMovie})
            {
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
						elsif ($self->{isYear})
						{
								$self->{movieList}[$self->{movieIdx}]->{"year"} = $origtext;
								$self->{isYear} = 0;
						}
        }
        else
        {
            if ($self->{insideName})
            {
                $self->{curInfo}->{title} = $origtext if !$self->{curInfo}->{title};
                $self->{insideName} = 0;
            }
            elsif ($self->{insideInfosNames})
            {
                $self->{insideOrig} = 1 if $origtext =~ m/Originaltitel:/;
								$self->{insideDirector} = 1 if $origtext =~ m/Regie:/;
								$self->{insideActors} = 1 if $origtext =~ m/Darsteller:/;
								$self->{insideType} = 1 if $origtext =~ m/Genre\(s\):/;
                $self->{insideInfosNames} = 0;
            }
            elsif ($self->{insideInfos} && $self->{inside}->{font})
            {
								if ($self->{insideOrig})
								{
	                $self->{curInfo}->{orig} = $origtext;
									$self->{insideOrig} = 0;
									$self->{insideInfos} = 0;
								}
								elsif ($self->{insideNat})
								{
	                $self->{curInfo}->{nat} = $origtext;
									$self->{insideNat} = 0;
									$self->{insideInfos} = 0;
								}
								elsif ($self->{insideDate})
								{
	                $self->{curInfo}->{date} = $origtext;
									$self->{insideDate} = 0;
									$self->{insideInfos} = 0;
								}
								elsif ($self->{insideDirector})
								{
	                $self->{curInfo}->{director} .= $self->{curInfo}->{director} ? ', ' . $origtext : $origtext;
								}
								elsif ($self->{insideActors})
								{
	                $self->{curInfo}->{actors} .= $self->{curInfo}->{actors} ? ', ' . $origtext : $origtext if $self->{actorsCounter} < $GCPluginParser::MAX_ACTORS;
									$self->{actorsCounter}++;
								}
								elsif ($self->{insideType})
								{
	                $self->{curInfo}->{type} .= $self->{curInfo}->{type} ? ',' . $origtext : $origtext;
								}
            }
						elsif ($self->{insideSynopsis})
						{
	          	$self->{curInfo}->{synopsis} = $origtext;
							$self->{insideSynopsis} = 0;
						}
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;
       
				$html =~ s/[0-9]*\. (<a href='view\.php\?page=film&fid=[0-9]*'>[^<]*)<font size='1'> \/ [^<]*<\/font> \(([0-9]{4})\)<\/a><br>/$1<\/a><div class="year">$2<\/div>/g;
				$html =~ s/<a href="view\.php\?page=liste&Name=[^"]*">([^<]*)<\/a>/$1/g;
				$html =~ s/<a href="view\.php\?page=genre&Genre=[^"]*">([^<]*)<\/a>/$1/g;
				$html =~ s/<font face="Arial,Helvetica,sans-serif" size="2" class="Blocksatz"><p class="Blocksatz"><b>Inhalt:<\/b>\s?([^<]*)<a href="(view\.php\?page=inhalt&fid=[0-9]*&sid=[0-9]*)">\s?<b>\[mehr\]<\/b><\/a><\/p><\/font>/<div class="synopsis">$1\nhttp:\/\/www.ofdb.de\/$2<\/div>/;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.ofdb.de/view.php?page=suchergebnis&Kat=DTitel&SText=$word";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
        return 'http://www.ofdb.de/' . $url;
    }

    sub getName
    {
        return "OFDb.de";
    }
    
    sub getImageFile
    {
        return "ofdb.png";
    }

    sub getAuthor
    {
        return 'MeV';
    }
    
    sub getLang
    {
        return 'DE';
    }

    sub hasSearchActors
    {
        return 0;
    }

    sub hasSearchDirector
    {
        return 0;
    }
}

1;
