package GCUtils;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

sub mySimpleListSplice
{
    my ($sl, $idx, $length, @new) = @_;

    my $data = $sl->{data};

    if ($^O =~ /win32/i)
    {
        my @newData;
        my $i = 0;
        my $pushed = 0;
        foreach (@$data)
        {
            push @newData, [$_->[0]] if ($i < $idx) || ($i >= $idx + $length);
            push @newData, @new if ($i == $idx);
            $pushed = 1 if ($i == $idx);
            $i++;
        }
        push @newData, @new if !$pushed;
        @{$data} = @newData;
    }
    else
    {
        splice @$data, $idx, $length, @new;
    }    
}

sub mySplice
{
    my ($data, $idx, $length, @new) = @_;

    if ($^O =~ /win32/i)
    {
        my @newData;
        my $i = 0;
        my $pushed = 0;
        foreach (@$data)
        {
            push @newData, $_ if ($i < $idx) || ($i >= $idx + $length);
            push @newData, @new if ($i == $idx);
            $pushed = 1 if ($i == $idx);
            $i++;
        }
        push @newData, @new if !$pushed;
        @{$data} = @newData;
    }
    else
    {
        splice @$data, $idx, $length, @new;
    }    
}

sub sensitive
{
    my ($widget, $value) = @_;
    
    $widget->sensitive($value);
}

sub findPosition
{
    use locale;
    my ($label, $menu) = @_;
    
    my @children = $menu->get_children;
    
    my $i = 0;
    my $child;
    foreach $child(@children)
    {
        return $i if ($i !=0) && ($child->child->get_label() gt $label);
        $i++;
    }
    
    return $i;
}

sub inArray
{
    my $val = shift;
 
        my $i = 0;
    my $elem;
    foreach $elem(@_)
    {
        if($val eq $elem)
        {
            return $i;
        }
        $i++;
    }
    return undef;
}

my $rc_style = Gtk2::RcStyle->new;

sub setWidgetPixmap
{
    my ($widget, $image) = @_;
    #my $rc_style = Gtk2::RcStyle->new;
    $rc_style->bg_pixmap_name('normal', $image);
    $rc_style->bg_pixmap_name('insensitive', $image);
    $widget->modify_style($rc_style);
}

use File::Basename;

sub getDisplayedImage
{
    my ($displayedImage, $default, $file) = @_;
    if (File::Spec->file_name_is_absolute($displayedImage))
    {
        $displayedImage = $default if (! -e $displayedImage);
    }
    else
    {            
        my $dir;
        $dir = '.';
        $dir = dirname($file)
            if $file;
        if (-f $dir.'/'.$displayedImage)
        {
            $displayedImage = $dir.'/'.$displayedImage;
        }
        else
        {
            $displayedImage = $default unless (-e $displayedImage);
        }
    }
    $displayedImage = $default if ! -f $displayedImage;
    
    return $displayedImage;
}

1;
