package GCImport::GCImportBase;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

{
    package GCImport::GCImportBaseClass;
    use File::Basename;
    
    #Methods to be overriden in specific classes
    
    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = {};

        $self->{parsingError} = '';

        bless ($self, $class);
        return $self;
    }

    sub getName
    {
    }
    
    sub getFilePatterns
    {
       return (['*.*', '*.*']);
    }

    sub getSuffix
    {
        my $self = shift;
        return '' if ! ($self->getFilePatterns)[0];
        (my $pattern = ($self->getFilePatterns)[0]->[1]) =~ s/.*?([[:alnum:]]+)/$1/;
        return $pattern;
    }

    sub getOptions
    {
    }
    
    sub wantsFieldsSelection
    {
        return 0;
    }

    sub wantsImagesSelection
    {
        return 0;
    }
    
    sub wantsFileSelection
    {
        return 1;
    }
    
    sub wantsDirectorySelection
    {
        return 0;
    }
    
    sub getEndInfo
    {
    }
    
    sub getMoviesArray
    {
    }

    #End of methods to be overriden
    
    # If you need really specific processing, you can instead override the process method
    
    sub process
    {
        my ($self, $options) = @_;

        $self->{options} = $options;
        
        $options->{parent}->{movies}->updateCurrent;
        if ($options->{newList})
        {
            $options->{parent}->newList;
        }

        $self->{options}->{parent}->setWaitCursor($self->{options}->{lang}->{ImportListTitle}.' ('.$options->{file}.')');
        my @tmpArray = @{$self->getMoviesArray($options->{file})};
        if ($self->{parsingError})
        {
            $self->{options}->{parent}->restoreCursor;
            return $self->getEndInfo;
        }

        foreach (@tmpArray)
        {
            $options->{parent}->{movies}->insertMovie($_);
        }
        $self->{options}->{parent}->restoreCursor;
        
        $options->{parent}->{movies}->reloadList;
        if ((scalar @tmpArray) && ($options->{parent}->{movies}->{currentMovie} == -1))
        {
            $options->{parent}->{movies}->{currentMovie} = 0;
            $options->{parent}->{movies}->{currentId} = 0;
        }
        $options->{parent}->{movies}->displayCurrent;
        $options->{parent}->{moviesList}->showCurrent;
        
        return $self->getEndInfo;
    }
}

1;
