/* StandaloneAppletWindow.java -- an applet frame
   Copyright (C) 2003, 2004  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;

class StandaloneAppletWindow extends Frame
  implements ActionListener
{
  private static int testWindowCount;
  private static HashMap contexts = new HashMap();
  private Applet applet;
  private Label status = new Label();

  private MenuItem restartItem;
  private MenuItem reloadItem;
  private MenuItem cancelItem;
  private MenuItem saveItem;
  private MenuItem startItem;
  private MenuItem cloneItem;
  private MenuItem tagItem;
  private MenuItem infoItem;
  private MenuItem editItem;
  private MenuItem encodingItem;
  private MenuItem printItem;
  private MenuItem propertiesItem;
  private MenuItem closeItem;
  private MenuItem quitItem;

  StandaloneAppletWindow(AppletTag tag, List appletWindows)
  {
    appletWindows.add(this);
    applet = AppletViewer.createApplet(tag);

    if (contexts.get(tag.codebase) == null)
      contexts.put(tag.codebase, new StandaloneAppletContext(appletWindows));

    setLayout(new BorderLayout());
    add(applet, BorderLayout.CENTER);
    add(status, BorderLayout.SOUTH);

    addWindowListener(new WindowAdapter()
        {
	  public void windowClosing(WindowEvent event)
	  {
	    applet.stop();
	    StandaloneAppletWindow.this.hide();
	    System.exit(0);
	  }
        });

    restartItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_restart"));
    restartItem.setEnabled(false);
    restartItem.addActionListener(this);
    reloadItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_reload"));
    reloadItem.setEnabled(false);
    reloadItem.addActionListener(this);
    cancelItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_cancel"));
    cancelItem.setEnabled(false);
    cancelItem.addActionListener(this);
    saveItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_save"));
    saveItem.setEnabled(false);
    saveItem.addActionListener(this);
    startItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_start"));
    startItem.setEnabled(false);
    startItem.addActionListener(this);
    cloneItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_clone"));
    cloneItem.setEnabled(false);
    cloneItem.addActionListener(this);
    closeItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_close"));
    closeItem.setEnabled(false);
    closeItem.addActionListener(this);
    tagItem =
      new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_tag"));
    tagItem.setEnabled(false);
    tagItem.addActionListener(this);
    infoItem =
      new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_info"));
    infoItem.setEnabled(false);
    infoItem.addActionListener(this);
    editItem =
      new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_edit"));
    editItem.setEnabled(false);
    editItem.addActionListener(this);
    editItem.setEnabled(false);
    encodingItem =
      new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_encoding"));
    encodingItem.setEnabled(false);
    encodingItem.addActionListener(this);
    printItem =
      new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_print"));
    printItem.setEnabled(false);
    printItem.addActionListener(this);
    propertiesItem =
      new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_properties"));
    propertiesItem.setEnabled(false);
    propertiesItem.addActionListener(this);
    quitItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_quit"));
    quitItem.addActionListener(this);

    MenuBar menuBar = new MenuBar();
    Menu menuApplet = new Menu(AppletViewer.messages.getString("gcjwebplugin.menu_title"));
    menuBar.add(menuApplet);
    menuApplet.add(restartItem);
    menuApplet.add(reloadItem);
    menuApplet.add(cancelItem);
    menuApplet.add(saveItem);
    menuApplet.add(startItem);
    menuApplet.add(cloneItem);
    menuApplet.addSeparator();
    menuApplet.add(tagItem);
    menuApplet.add(infoItem);
    menuApplet.add(editItem);
    menuApplet.add(encodingItem);
    menuApplet.addSeparator();
    menuApplet.add(printItem);
    menuApplet.addSeparator();
    menuApplet.add(propertiesItem);
    menuApplet.addSeparator();
    menuApplet.add(closeItem);
    menuApplet.add(quitItem);
    setMenuBar(menuBar);

    setTitle("GCJ Applet Viewer: " + tag.code);

    AppletContext context = (AppletContext) contexts.get(tag.codebase);
    ((StandaloneAppletContext) context).addApplet(applet);

    applet.setStub(new CommonAppletStub(tag, context, applet));

    String testWindowCountProperty =
      System.getProperty("gnu.gcjwebplugin.test.windowCount");

    if (testWindowCountProperty == null)
      {
	// Create the frame's peer.  Otherwise getPreferredSize will read
	// its insets as 0.
	addNotify();
        Insets i = getInsets ();
	Dimension size = AppletTag.getSize (tag);
	setSize(i.left + size.width + i.right,
		i.top + size.height + status.getPreferredSize ().height
		+ i.bottom);
        applet.setSize(size);

        // Initialize the applet before showing this window so that
        // the applet doesn't receive events before it has been
        // initialized.
	applet.init ();
	setVisible (true);
	applet.validate();
	applet.start();
      }
    else
      {
	applet.init();
	applet.start();

	if (++StandaloneAppletWindow.testWindowCount == Integer.decode(testWindowCountProperty).intValue())
	  System.exit(0);
      }
  }

  private void closeWindow()
  {
    applet.stop();
    StandaloneAppletViewer.appletWindows.remove(this);
    StandaloneAppletWindow.this.hide();
  }

  public void actionPerformed(ActionEvent e)
  {
    if (e.getSource() == quitItem)
      {
        closeWindow();
        System.exit(0);
      }
    else if (e.getSource() == closeItem)
      {
	// Close current window.
	closeWindow();
	
	// Exit if there are other windows left.
	if (StandaloneAppletViewer.appletWindows.isEmpty())
          System.exit(0);
      }
  }

  void showStatus(String status)
  {
    this.status.setText(status);
  }
}
