/* gcjwebplugin - Webbrowser plugin to execute Java (tm) applets.
   Copyright (C) 2003  Michael Koch <konqueror@gmx.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307  USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


#ifndef __GCJPLUGININSTANCE_H__
#define __GCJPLUGININSTANCE_H__

#include <nsIJVMPluginInstance.h>
#include <nsIPluginInstance.h>

#include "GCJPluginFactory.h"

class GCJPluginInstance : public nsIPluginInstance, public nsIJVMPluginInstance
{
 public:

  GCJPluginInstance (GCJPluginFactory* factory, JNIEnv* jniEnv);
  virtual ~GCJPluginInstance ();

  NS_DECL_ISUPPORTS
  NS_DECL_NSIJVMPLUGININSTANCE
    
  NS_IMETHOD Initialize (nsIPluginInstancePeer* peer);
  NS_IMETHOD GetPeer (nsIPluginInstancePeer** resulting);
  NS_IMETHOD Start();
  NS_IMETHOD Stop();
  NS_IMETHOD Destroy();
  NS_IMETHOD SetWindow (nsPluginWindow *window);
  NS_IMETHOD NewStream (nsIPluginStreamListener** listener);
  NS_IMETHOD Print (nsPluginPrint* platformPrint);
  NS_IMETHOD GetValue (nsPluginInstanceVariable variable, void* value);
  NS_IMETHOD HandleEvent (nsPluginEvent* event, PRBool* handled);

 private:

  nsIPluginInstancePeer* m_peer;
  const char* code;
  const char* codebase;
  const char* archive;
  const char* documentbase;
  PRUint16 numParams;
  const char* const* paramNames;
  const char* const* paramValues;
  int width;
  int height;
  int xid;

};

#endif // __GCJPLUGININSTANCE_H__
