/*
  GNOME Comics Organizer
  Copyright (C) 1999-2001 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>

#include "add_comic_window.h"
#include "add_issue_window.h"
#include "add_sequence_of_issues_window.h"
#include "open_file_selection.h"
#include "save_file_selection.h"
#include "export_selection.h"
#include "preferences_window.h"
#include "comiclist.h"
#include "functions.h"

extern GladeXML *xml;
extern GString *GLADE_FILE;
extern GList *ComicList;

extern gchar *new_filename;
extern gchar *current_filename;
extern gboolean file_changed;

extern gchar *MainWindowKey;
extern gchar *ComicListKey;
extern gchar *ComicToAddKey;
extern gchar *ComicToAddToKey;
extern gchar *ComicToEditKey;
extern gchar *IssueToEditKey;

extern GCompareFunc TComicCompare;

void clear_reply_callback (gint reply, gpointer data)
{
  if (reply==GNOME_YES)
    real_clear_list(GTK_WIDGET (data));
}

void request_new_list (GtkWidget *widget)
{
  GtkWidget *main_window;

  main_window = glade_xml_get_widget (xml, "main_window");
  if (file_changed)
    {
      gnome_app_question_modal (GNOME_APP (main_window), "List has changed.\nAre you sure you want to clear it?",
			        clear_reply_callback, widget);
    }
  else
    {
      real_clear_list (widget);
    }
}

void open_reply_callback (gint reply, gpointer data)
{
  if (reply==GNOME_YES)
    real_open (GTK_WIDGET (data));
}

void request_open (GtkWidget *widget)
{
  GtkWidget *main_window;

  main_window = glade_xml_get_widget (xml, "main_window");
  if (file_changed)
    {
      gnome_app_question_modal (GNOME_APP (main_window), "List has changed.\nAre you sure you want to open a new file?",
				open_reply_callback, widget);
    }
  else
    {
      real_open (widget);
    }
}

void on_mainmenu_file_new_file_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  request_new_list(GTK_WIDGET (menuitem));
}

void on_mainmenu_file_open_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  request_open(GTK_WIDGET (menuitem));
}

void on_mainmenu_file_save_activate (GtkMenuItem *menuitem,  gpointer user_data)
{
  GtkWidget *main_window;

  main_window = glade_xml_get_widget (xml, "main_window");

  if (current_filename==NULL)
    {
      show_save_dialog ();
    }
  else real_save_file(main_window);
}

void on_mainmenu_file_save_as_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  show_save_dialog ();
}

void exit_reply_callback (gint reply, gpointer data)
{
  if (reply==GNOME_YES)
    gtk_main_quit ();
}

void request_exit(GtkWidget *widget)
{
  GtkWidget *main_window;

  main_window = glade_xml_get_widget (xml, "main_window");
  if (file_changed)
    {
      gnome_app_question_modal (GNOME_APP (main_window), "List has changed.\nAre you sure you want to exit?",
				exit_reply_callback, widget);
    }
  else
    {
      gtk_main_quit ();
    }
}

void on_mainmenu_file_exit_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  request_exit (GTK_WIDGET (menuitem));
}

void on_mainmenu_edit_add_comic_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  new_title_activate (GTK_WIDGET(menuitem), "Add Comic Title", TRUE);
}

void on_mainmenu_edit_remove_comic_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *SelectedItem, *TempComicGList;
  GtkTree *comics_tree;
  GtkCList *issues_clist;
  GtkText *issues_info_text;
  TComic *TempComic;

  comics_tree = GTK_TREE (glade_xml_get_widget (xml, "comics_tree"));
  issues_clist = GTK_CLIST (glade_xml_get_widget (xml, "issues_clist"));
  issues_info_text = GTK_TEXT (glade_xml_get_widget (xml, "issues_info_text"));

  SelectedItem = GTK_TREE_SELECTION (comics_tree);

  if (SelectedItem != NULL) /* FIXME - split this into a function in comiclist.c */
    {
      TempComicGList = gtk_object_get_data (GTK_OBJECT (SelectedItem->data), ComicListKey);
      
      TempComic = TempComicGList->data;
      ComicList = g_list_remove(ComicList, TempComic);
      g_free(TempComic);
      gtk_tree_remove_items(comics_tree, SelectedItem);
      
      clear_clist(issues_clist);
      clear_text(issues_info_text);

      file_changed = TRUE;
    }
}

void on_mainmenu_edit_add_issue_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  new_issue_activate (GTK_WIDGET(menuitem));
}

void on_mainmenu_edit_add_sequence_of_issues_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  create_new_sequence_of_issues (GTK_WIDGET(menuitem));
}

void on_mainmenu_edit_remove_issue_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *SelectedComicItem, *SelectedIssueItem, *TempIssueGList, *TempComicGList;
  GtkTree *comics_tree;
  GtkCList *issues_clist;
  GtkText *issues_info_text;
  TComic *TempComic;
  TIssue *TempIssue;

  comics_tree = GTK_TREE (glade_xml_get_widget (xml, "comics_tree"));
  issues_clist = GTK_CLIST (glade_xml_get_widget (xml, "issues_clist"));
  issues_info_text = GTK_TEXT (glade_xml_get_widget (xml, "issues_info_text"));

  SelectedComicItem = GTK_TREE_SELECTION (comics_tree);
  SelectedIssueItem = issues_clist->selection;
  
  if (SelectedIssueItem != NULL) /* FIXME - split this into a function in comiclist.c */
    {
      TempIssueGList = gtk_clist_get_row_data (issues_clist,  (gint) SelectedIssueItem->data);
      
      TempIssue = TempIssueGList->data;
      
      TempComicGList = gtk_object_get_data (GTK_OBJECT (SelectedComicItem->data), ComicListKey);
      TempComic = TempComicGList->data;

      TempComic->IssueNumbers = g_list_remove(TempComic->IssueNumbers, TempIssue);
      g_free(TempIssue);
      gtk_clist_remove(issues_clist, (gint) SelectedIssueItem->data);
      
      clear_text(issues_info_text);

      file_changed = TRUE;
    }
}

void on_mainmenu_edit_add_file_link_activate (GtkMenuItem *menuitem, gpointer user_data)
{
/*    GtkWidget *add_file_link_window = NULL; */
/*    GladeXML *temp_xml; */

/*    temp_xml = glade_xml_new (GLADE_FILE->str, "add_file_link_window"); */
/*    add_file_link_window = glade_xml_get_widget (xml, "add_file_link_window"); */
/*    gtk_widget_show (add_file_link_window); */
}

void on_mainmenu_settings_preferences_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  create_preferences_dialog ();
}

void on_mainmenu_help_about_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  GString *description_msg = NULL;
  GtkWidget *about;

  const gchar *authors[] = {
    "Mads Villadsen <maxximum@get2net.dk>",
    NULL
  };

  description_msg = g_string_new (_("A program for keeping track of your comics collection. \n\n"));
#if USE_GNOME_VFS
  description_msg = g_string_append (description_msg, _("Compiled with gnome-vfs support\n"));
#endif

  about = gnome_about_new (_("GNOME Comics Organizer"), VERSION,
			   "(C) 1999-2001 Maxximum Software",
			   authors,
			   _(description_msg->str),
			   "gco-logo.png");
  gtk_window_set_modal (GTK_WINDOW (about), TRUE);
  
  gtk_widget_show (about);
  
/*   GtkWidget *about_box = NULL; */
/*   GladeXML *temp_xml; */
/*   temp_xml = glade_xml_new (GLADE_FILE->str, "about_box"); */
/*   about_box = glade_xml_get_widget (temp_xml, "about_box"); */
/*   gtk_widget_show (about_box); */
/*   gtk_object_unref (GTK_OBJECT(temp_xml)); */
}

gboolean on_main_window_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  request_exit (widget);

  return TRUE;
}


void on_maintoolbar_new_button_clicked (GtkButton *button, gpointer user_data)
{
  request_new_list(GTK_WIDGET (button));
}


void on_maintoolbar_open_button_clicked  (GtkButton *button, gpointer user_data)
{
  request_open (GTK_WIDGET (button));
}

void on_maintoolbar_save_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *main_window;

  main_window = glade_xml_get_widget (xml, "main_window");

  new_filename = current_filename;
  if (current_filename==NULL)
    {
      show_save_dialog ();
    }
  else real_save_file(main_window);
}

void on_issues_clist_select_row (GtkCList *clist, gint row, gint column,
				 GdkEventButton *event, gpointer user_data)
{
  GList *TempIssueGList;
  TIssue *TempIssue;
  GtkText *IssuesInfo;

  TempIssueGList = gtk_clist_get_row_data(clist, row);
  TempIssue = TempIssueGList->data;

  IssuesInfo = GTK_TEXT (glade_xml_get_widget (xml, "issues_info_text"));

  if (!event)
    {
      display_selected_issue_info(TempIssue, IssuesInfo);
    }
  else
    {
      switch (event->button)
	{
	case 1:
	  if (event->type == GDK_2BUTTON_PRESS)
	    {
	      edit_issue_activate(GTK_WIDGET(clist));
            }
	  else
	    {
	      display_selected_issue_info(TempIssue, IssuesInfo);
            }
	  break;
            
	default:
	  break;
        }
    }
}

void on_maintoolbar_ASCIIDump_button_clicked (GtkButton *button, gpointer user_data)
{
  ASCIIDumpComicList(ComicList);
}

void on_mainmenu_edit_edit_comic_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   edit_title_activate(GTK_WIDGET(menuitem));
}

void on_mainmenu_edit_edit_issues_activate (GtkMenuItem  *menuitem, gpointer user_data)
{
  edit_issue_activate(GTK_WIDGET(menuitem));
}

void on_mainmenu_sort_comics_by_title_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  GtkTree *comics_tree;

  TComicCompare = CompareTComic_Title;
  ComicList = g_list_sort(ComicList, TComicCompare);

  comics_tree = GTK_TREE (glade_xml_get_widget(xml, "comics_tree"));
  CreateComicsTreeList (comics_tree, ComicList);
}

void on_mainmenu_sort_comics_by_publisher_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  GtkTree *comics_tree;

  TComicCompare = CompareTComic_Publisher;
  ComicList = g_list_sort(ComicList, TComicCompare);

  comics_tree = GTK_TREE (glade_xml_get_widget(xml, "comics_tree"));
  CreateComicsTreeList(comics_tree, ComicList);
}

void on_mainmenu_sort_comics_by_type_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  GtkTree *comics_tree;

  TComicCompare = CompareTComic_Type;
  ComicList = g_list_sort(ComicList, TComicCompare);

  comics_tree = GTK_TREE (glade_xml_get_widget(xml, "comics_tree"));
  CreateComicsTreeList(comics_tree, ComicList);
}

void on_maintoolbar_refresh_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkTree *comics_tree;

  comics_tree = GTK_TREE (glade_xml_get_widget(xml, "comics_tree"));
  CreateComicsTreeList(comics_tree, ComicList);
}

void on_ascii_to_stdout_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  ASCIIDumpComicList(ComicList);
}

void on_new_title_button_clicked (GtkButton *button, gpointer user_data)
{
  new_title_activate(GTK_WIDGET(button), "Add Comic Title", TRUE);
}

void on_edit_title_button_clicked (GtkButton *button, gpointer user_data)
{
   edit_title_activate(GTK_WIDGET(button));
}

void on_new_issue_button_clicked (GtkButton *button, gpointer user_data)
{
   new_issue_activate(GTK_WIDGET(button));
}

void on_edit_issue_button_clicked (GtkButton *button, gpointer user_data)
{
   edit_issue_activate(GTK_WIDGET(button));
}

void on_mainmenu_file_export_to_ascii_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  create_export_selection (GTK_WIDGET(menuitem), "export_ascii_selection");
}

void on_export_to_html_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  create_export_selection (GTK_WIDGET(menuitem), "export_html_selection");
}

gboolean on_comics_tree_button_press_event (GtkWidget *widget, GdkEventButton  *event, gpointer user_data)
{
  GtkTree *comics_tree;
  GList *SelectedItem;

  comics_tree = GTK_TREE (glade_xml_get_widget (xml, "comics_tree"));
  SelectedItem = GTK_TREE_SELECTION (comics_tree);

  if (!event)
    {
      return FALSE;
    }
  else
    {
      switch (event->button)
	{
	case 1:
	  if (event->type == GDK_2BUTTON_PRESS)
	    {
	      edit_title_activate(widget);
	    }
	  break;
	default:
	  break;
	}
    }

  return FALSE;
}

void on_comics_tree_select_child (GtkTree *tree, GtkWidget *widget, gpointer user_data)
{
   display_selected_comic_title (widget);
}
