# Replace SiteTemplate with your plugin name.
# The package name must exactly match the file name (.pm)
package GCPlugins::GCSiteTemplate;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCPluginsBase;

{
    # Replace SiteTemplate with your exporter name
    # It must be the same name as the one used for file and main package name
    package GCPlugins::GCPluginSiteTemplate;

    use base qw(GCPluginParser);
 
    # getSearchUrl
    # Used to get the URL that to be used to perform searches.
    # $word is the query
    # Returns the full URL.
    sub getSearchUrl
    {
		my ($self, $word) = @_;
        my $url;
        
        # Your code here
        
		return $url;
    }
    
    # getItemUrl
    # Used to get the full URL of a movie page.
    # Useful when url on results pages are relative.
    # $url is the URL as found with a search.
    # Returns the absolute URL.
    sub getItemUrl
    {
		my ($self, $url) = @_;
		my $absUrl;
        
        # Your code here

        return $absUrl;
    }
    
    # getCharset
    # Used to convert charset in web pages.
    # Returns the charset as specified in pages.
    sub getCharset
    {
        my $self = shift;
    
        return "ISO-8859-1";
    }

    # getName
    # Used to display plugin name in GUI.
    # Returns the plugin name.
    sub getName
    {
        return "SiteTemplate";
    }
    
    # getImageFile
    # Used to display a plugin picture in GUI.
    # The picture should be in share/gcstar.
    # Returns the plugin picture file name.
    sub getImageFile
    {
        return "sitetemplate.png";
    }

    # getAuthor
    # Used to display the plugin author in GUI.
    # Returns the plugin author name.
    sub getAuthor
    {
        return 'Tian';
    }
    
    # getLang
    # Used to fill in plugin list with user language plugins
    # Return the language used for this site (2 letters code).
    sub getLang
    {
        return 'EN';
    }

    # hasSearchYear
    # Used to hide year column in search results
    # Return 0 to hide column, 1 to show it.
    sub hasSearchYear
    {
        return 1;
    }

    # hasSearchDirector
    # Used to hide director column in search results
    # Return 0 to hide column, 1 to show it.
    sub hasSearchDirector
    {
        return 1;
    }

    # hasSearchActors
    # Used to hide actors column in search results
    # Return 0 to hide column, 1 to show it.
    sub hasSearchActors
    {
        return 1;
    }

    # getExtra
    # Used if the plugin wants an extra column to be displayed in search results
    # Return the column title or empty string to hide the column.
    sub getExtra
    {
        return 'Extra';
    }

    # changeUrl
    # Can be used to change URL if movie URL and the one used to
    # extract information are different.
    # Return the modified URL.
    sub changeUrl
    {
        my ($self, $url) = @_;
        
        return $url;
    }

    # In processing functions below, self->{parsingList} can be used.
    # If true, we are processing a search results page
    # If false, we are processing a movie information page.
    
    # $self->{inside}->{tagname} (with correct value for tagname) can be used to test
    # if we are in the corresponding tag.
    
    # You have a counter $self->{movieIdx} that have to be used when processing search results.
    # It is your responsability to increment it!
    
    # When processing search results, you have to fill (if available) following fields:
    #
    #  $self->{movieList}[$self->{movieIdx}]->{title}
    #  $self->{movieList}[$self->{movieIdx}]->{url}
    #  $self->{movieList}[$self->{movieIdx}]->{actors}
    #  $self->{movieList}[$self->{movieIdx}]->{director}
    #  $self->{movieList}[$self->{movieIdx}]->{date}
    #  $self->{movieList}[$self->{movieIdx}]->{extra}
    
    # When processing a movie page, you need to fill the fields (if available) in $self->{curInfo}. They are:
    #
    #  $self->{curInfo}->{title}
    #  $self->{curInfo}->{director}
    #  $self->{curInfo}->{original}        (Original title)
    #  $self->{curInfo}->{actors}
    #  $self->{curInfo}->{genre}        (Comma separated list of movie type)
    #  $self->{curInfo}->{country}        (Movie Nationality or country)
    #  $self->{curInfo}->{date}
    #  $self->{curInfo}->{time}
    #  $self->{curInfo}->{synopsis}
    #  $self->{curInfo}->{image}
    #  $self->{curInfo}->{audio}
    #  $self->{curInfo}->{subt}
    #  $self->{curInfo}->{age}          0     : No information
    #                                   1     : Unrated
    #                                   2     : All audience
    #                                   5     : Parental Guidance
    #                                   >= 10 : Minimum age value
    
    # start
    # Called each time a new HTML tag begins.
    # $tagname is the tag name.
    # $attr is reference to an associative array of tag attributes.
    # $attrseq is an array reference containing all the attributes name.
    # $origtext is the tag text as found in source file
    # Returns nothing
    sub start
    {
		my ($self, $tagname, $attr, $attrseq, $origtext) = @_;	
		$self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {
            # Your code for processing search results here
        }
        else
        {
            # Your code for processing movie information here
        }
    }

    # end
    # Called each time a HTML tag ends.
    # $tagname is the tag name.
    sub end
    {
		my ($self, $tagname) = @_;		
		$self->{inside}->{$tagname}--;

        if ($self->{parsingList})
        {
            # Your code for processing search results here
        }
        else
        {
            # Your code for processing movie information here
        }
    }

    # text
    # Called each time some plain text (between tags) is processed.
    # $origtext is the read text.
    sub text
    {
        my ($self, $origtext) = @_;

       if ($self->{parsingList})
        {
            # Your code for processing search results here
        }
        else
        {
            # Your code for processing movie information here
        }
    }

    # new
    # Constructor.
    # Returns object reference.
    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();

        # Do your init stuff here
        
        bless ($self, $class);
        return $self;
    }

    # preProcess
    # Called before each page is processed. You can use it to do some substitutions.
    # $html is the page content.
    # Returns modified version of page content.
    sub preProcess
    {
        my ($self, $html) = @_;

        # Your code to modify $html here.
        
        return $html;
    }
    
}

1;
