package GCPlugins::GCfilms::GCAmazonFR;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCfilms::GCfilmsAmazonCommon;

{
    package GCPlugins::GCfilms::GCPluginAmazonFR;

    use base qw(GCPlugins::GCfilms::GCfilmsAmazonPluginsBase);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
    
        $self->{inside}->{$tagname}++;

	    if ($self->{parsingEnded})
        {
            if ($self->{itemIdx} < 0)
            {
                $self->{itemIdx} = 0;
                $self->{itemsList}[0]->{url} = $self->{loadedUrl};
            }
            return;
        }

        if ($self->{parsingList})
        {
            return if ! $self->{beginParsing};
            
            if ($tagname eq "a")
            {
                my $urlId;
                if ($urlId = $self->isItemUrl($attr->{href}))
#                if ($attr->{href} =~ m|/dp/[A-Z0-9]*/sr=([0-3]-[0-9]*)/qid=[0-9]*|)
                {
                    return if $self->{alreadyRetrieved}->{$urlId};
                    $self->{alreadyRetrieved}->{$urlId} = 1;
                    my $url = $attr->{href}; 
                    $self->{itemIdx}++;
                    $self->{itemsList}[$self->{itemIdx}]->{url} = $url;
                }
            }
        }
        else
        {
            if ($tagname eq "img")
            {
                if (!$self->{curInfo}->{image})
                {
                    $self->{curInfo}->{image} = $self->extractImage($attr);
                }
            }
            elsif ($tagname eq "b")
            {
            	$self->{insideNameAndDate} = 1 if $attr->{class} eq "sans";
            }
        }
    }

    sub end
    {
        my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
           
        if ($self->{parsingList})
        {
            if (($self->{inside}->{title})
             && ($origtext !~ /Amazon.fr:.*R.*sultats/)
             && ($origtext !~ /Amazon.fr:?\s+.*?DVD$/))
            {
                $self->{parsingEnded} = 1;
            }
            if (
                (($self->{inside}->{b})
                || ($self->{inside}->{span}))            
             && ($origtext =~ /Trier par/))
            {
                $self->{beginParsing} = 1;
                return;
            }
            return if ! $self->{beginParsing};
            if ($self->{inside}->{srtitle})
            {
                $self->{itemsList}[$self->{itemIdx}]->{title} = $origtext;
                return;
            }
#            if ($self->{isMovie})
#            {
#                $origtext =~ s/\n//g;
#                $origtext =~ s/^\s*//;
#                $self->{itemsList}[$self->{itemIdx}]->{"title"} = $origtext;
#                $self->{isMovie} = 0;
#                $self->{isInfo} = 1;
#                return;
#            }
            elsif ($self->{inside}->{actors})
            {
                $self->{itemsList}[$self->{itemIdx}]->{actors} = $origtext
                    if ! $self->{itemsList}[$self->{itemIdx}]->{actors};
            }
            elsif ($self->{inside}->{director})
            {
                $self->{itemsList}[$self->{itemIdx}]->{director} = $origtext
                    if ! $self->{itemsList}[$self->{itemIdx}]->{director};
            }
        }
        else
        {
            $origtext =~ s/\s{2,}//g;

            if ($self->{insideNameAndDate})
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{insideNameAndDate} = 0;
            }
            elsif ($self->{insideActors})
            {
                $self->{curInfo}->{actors} = $origtext;
                $self->{insideActors} = 0;
            }
            elsif ($self->{insideDirector})
            {
                $self->{curInfo}->{director} = $origtext;
                $self->{insideDirector} = 0;
            }
            elsif ($self->{insideTime})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/\n//g;
                $self->{curInfo}->{time} = $origtext;
                $self->{insideTime} = 0;
            }
            elsif ($self->{insideSynopsis})
            {
                $self->{curInfo}->{synopsis} = $origtext;
                $self->{insideSynopsis} = 0;
            }
            elsif ($self->{inside}->{b})
            {
                $self->{insideActors} = 1 if $origtext =~ /Acteurs\s*:/;
				$self->{insideDirector} = 1 if $origtext =~ /R.alisateurs?\s*:/;
    			$self->{insideSynopsis} = 1 if $origtext =~ /Description/;
			}        
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            date => 0,
            director => 1,
            actors => 1,
        };

        $self->{suffix} = 'fr';

        $self->{alreadyRetrieved} = {};
        $self->{beginParsing} = 0;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $html = $self->SUPER::preProcess($html);
        if ($self->{parsingList})
        {
            $html =~ s|^\s+par\s+([^,]*),?\s*(.*)$|<director>$1</director><actors>$2</actors>|gm;
        }
        else
        {
            $html =~ s/(<i>|<\/i>)//gim;
            $html =~ s/<p>/\n/gim;
            $html =~ s|</p>|\n|gim;
            $html =~ s/(<ul>|<\/ul>)/\n/gim;
            $html =~ s/<li>([^<])/- $1/gim;
            $html =~ s|([^>])</li>|$1\n|gim;
            $html =~ s|<br ?/?>|\n|gi;
            $html =~ s|<a href="/gp/imdb/[^"]*">(.*?)</a>|$1|gm;
            $html =~ s/<a href="\/exec\/obidos\/search-handle-url\/index=dvd-fr&field-(?:actor|director|keywords)=[^\/]*\/[-0-9]*">([^<]*)<\/a>/$1/gm;
            #"
        }

        return $html;
    }
    
    sub getName
    {
        return "Amazon (FR)";
    }

    sub getLang
    {
        return 'FR';
    }

}

1;
