/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.BaseType;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Type;

public class TextType
extends BaseType {
    protected int maxLength;

    public TextType() {
        this.maxLength = -1;
    }

    public TextType(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_textLenNegative"));
        }
        if (maxLength == 0) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_textType_lenZero"));
        }
        this.maxLength = maxLength;
    }

    public String toString() {
        if (this.maxLength != -1) {
            return "TEXT*" + Integer.toString(this.maxLength);
        }
        return "TEXT";
    }

    public boolean isAbstract() {
        return this.maxLength == -1;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    void checkTypeExtension(Type wantToExtend) {
        super.checkTypeExtension(wantToExtend);
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!(wantToExtend instanceof TextType)) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_textType_ExtOther"));
        }
        TextType general = (TextType)wantToExtend;
        if (general.maxLength != -1) {
            if (this.maxLength == -1) {
                throw new IllegalArgumentException(Element.formatMessage("err_textType_abstractExtConcrete", general.toString()));
            }
            if (this.maxLength > general.maxLength) {
                throw new IllegalArgumentException(Element.formatMessage("err_textType_longerExtShorter", this.toString(), general.toString()));
            }
        }
    }
}

